/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.internal.jpa.jpql.AbstractObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectLevelReadQueryVisitor
extends AbstractObjectLevelReadQueryVisitor<ObjectLevelReadQuery> {
    private JoinedAttributeExpressionVisitor joinedAttributeExpressionVisitor;

    ObjectLevelReadQueryVisitor(DefaultJPQLQueryContext queryContext) {
        super(queryContext);
    }

    private JoinedAttributeExpressionVisitor joinedAttributeExpressionVisitor() {
        if (this.joinedAttributeExpressionVisitor == null) {
            this.joinedAttributeExpressionVisitor = new JoinedAttributeExpressionVisitor();
        }
        return this.joinedAttributeExpressionVisitor;
    }

    @Override
    public void visit(SelectClause expression) {
        super.visit(expression);
        expression.getSelectExpression().accept((ExpressionVisitor)this.joinedAttributeExpressionVisitor());
    }

    private class JoinedAttributeExpressionVisitor
    extends AbstractExpressionVisitor {
        private JoinedAttributeExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariable expression) {
            String variableName = expression.getText();
            for (JoinFetch joinFetch : ObjectLevelReadQueryVisitor.this.queryContext.getJoinFetches(variableName)) {
                String joinFetchVariableName = ObjectLevelReadQueryVisitor.this.queryContext.literal((Expression)joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                if (!variableName.equalsIgnoreCase(joinFetchVariableName)) continue;
                ObjectLevelReadQueryVisitor.this.getDatabaseQuery().addJoinedAttribute(ObjectLevelReadQueryVisitor.this.queryContext.buildQueryExpression((Expression)joinFetch));
            }
        }
    }
}

