/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

final class ReadQueryBuilder
extends AnonymousExpressionVisitor {
    ReadAllQuery query;
    private final DefaultJPQLQueryContext queryContext;

    ReadQueryBuilder(DefaultJPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void initializeReadAllQuery() {
        ReadAllQuery query = new ReadAllQuery();
        query.dontUseDistinct();
        this.query = query;
    }

    private void initializeReportQuery() {
        ReportQuery query = new ReportQuery();
        query.returnWithoutReportQueryResult();
        query.dontUseDistinct();
        this.query = query;
    }

    public void visit(CollectionExpression expression) {
        this.initializeReportQuery();
    }

    public void visit(IdentificationVariable expression) {
        if (this.queryContext.isRangeIdentificationVariable(expression.getText())) {
            this.initializeReadAllQuery();
        } else {
            this.initializeReportQuery();
        }
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    protected void visit(Expression expression) {
        this.initializeReportQuery();
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectClause expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectStatement expression) {
        expression.getSelectClause().accept((ExpressionVisitor)this);
    }
}

