/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUnmarshaller
implements Cloneable {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private static final String XML_STREAM_READER_CLASS_NAME = "javax.xml.stream.XMLStreamReader";
    private static final String XML_EVENT_READER_CLASS_NAME = "javax.xml.stream.XMLEventReader";
    private static final String GET_XML_STREAM_READER_METHOD_NAME = "getXMLStreamReader";
    private static final String GET_XML_EVENT_READER_METHOD_NAME = "getXMLEventReader";
    private static final String XML_STREAM_READER_READER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader";
    private static final String XML_EVENT_READER_READER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader";
    private static final String XML_STREAM_READER_INPUT_SOURCE_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource";
    private static final String XML_EVENT_READER_INPUT_SOURCE_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource";
    private static Class staxSourceClass;
    private static Method staxSourceGetStreamReaderMethod;
    private static Method staxSourceGetEventReaderMethod;
    private static Constructor xmlStreamReaderReaderConstructor;
    private static Constructor xmlStreamReaderInputSourceConstructor;
    private static Constructor xmlEventReaderReaderConstructor;
    private static Constructor xmlEventReaderInputSourceConstructor;
    private XMLContext xmlContext;
    private XMLUnmarshallerHandler xmlUnmarshallerHandler;
    private PlatformUnmarshaller platformUnmarshaller;
    private boolean schemasAreInitialized;
    private XMLUnmarshalListener unmarshalListener;
    private XMLAttachmentUnmarshaller attachmentUnmarshaller;
    private Properties unmarshalProperties;
    private Class unmappedContentHandlerClass;
    private StrBuffer stringBuffer;
    private MediaType mediaType = MediaType.APPLICATION_XML;
    private String valueWrapper;

    static {
        try {
            staxSourceClass = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            if (staxSourceClass != null) {
                staxSourceGetStreamReaderMethod = PrivilegedAccessHelper.getDeclaredMethod(staxSourceClass, GET_XML_STREAM_READER_METHOD_NAME, new Class[0]);
                staxSourceGetEventReaderMethod = PrivilegedAccessHelper.getDeclaredMethod(staxSourceClass, GET_XML_EVENT_READER_METHOD_NAME, new Class[0]);
                Class xmlStreamReaderInputSourceClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_INPUT_SOURCE_CLASS_NAME);
                Class xmlEventReaderInputSourceClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_INPUT_SOURCE_CLASS_NAME);
                Class xmlStreamReaderClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_CLASS_NAME);
                xmlStreamReaderInputSourceConstructor = PrivilegedAccessHelper.getConstructorFor(xmlStreamReaderInputSourceClass, new Class[]{xmlStreamReaderClass}, true);
                Class xmlEventReaderClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_CLASS_NAME);
                xmlEventReaderInputSourceConstructor = PrivilegedAccessHelper.getConstructorFor(xmlEventReaderInputSourceClass, new Class[]{xmlEventReaderClass}, true);
                Class xmlStreamReaderReaderClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_READER_CLASS_NAME);
                xmlStreamReaderReaderConstructor = PrivilegedAccessHelper.getConstructorFor(xmlStreamReaderReaderClass, new Class[0], true);
                Class xmlEventReaderReaderClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_READER_CLASS_NAME);
                xmlEventReaderReaderConstructor = PrivilegedAccessHelper.getConstructorFor(xmlEventReaderReaderClass, new Class[0], true);
            }
        }
        catch (Exception exception) {}
    }

    protected XMLUnmarshaller(XMLContext xmlContext) {
        this(xmlContext, null);
    }

    protected XMLUnmarshaller(XMLContext xmlContext, Map<String, Boolean> parserFeatures) {
        this.setXMLContext(xmlContext);
        this.stringBuffer = new StrBuffer();
        this.initialize(parserFeatures);
    }

    private void initialize(Map<String, Boolean> parserFeatures) {
        DatabaseSession session = this.xmlContext.getSession(0);
        XMLPlatform xmlPlatform = (XMLPlatform)session.getDatasourceLogin().getDatasourcePlatform();
        this.platformUnmarshaller = xmlPlatform.newPlatformUnmarshaller(this, parserFeatures);
        this.platformUnmarshaller.setWhitespacePreserving(false);
        this.setValidationMode(0);
    }

    private void initializeSchemas() {
        if (!this.schemasAreInitialized) {
            HashSet<String> schemas = new HashSet<String>();
            int numberOfSessions = this.xmlContext.getSessions().size();
            int x = 0;
            while (x < numberOfSessions) {
                for (XMLDescriptor xMLDescriptor : ((DatabaseSession)this.xmlContext.getSessions().get(x)).getDescriptors().values()) {
                    URL schemaURL;
                    XMLSchemaReference xmlSchemaReference = xMLDescriptor.getSchemaReference();
                    if (xmlSchemaReference == null || (schemaURL = xmlSchemaReference.getURL()) == null) continue;
                    schemas.add(schemaURL.toString());
                }
                ++x;
            }
            schemas.remove(null);
            this.platformUnmarshaller.setSchemas(schemas.toArray());
            this.schemasAreInitialized = true;
        }
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext value) {
        this.xmlContext = value;
    }

    public int getValidationMode() {
        return this.platformUnmarshaller.getValidationMode();
    }

    public void resolveReferences(AbstractSession unitOfWork) {
        ReferenceResolver resolver = ReferenceResolver.getInstance(unitOfWork);
        if (resolver != null) {
            resolver.resolveReferences(unitOfWork);
        }
    }

    public void setValidationMode(int validationMode) {
        if (validationMode == 3) {
            this.initializeSchemas();
        }
        this.platformUnmarshaller.setValidationMode(validationMode);
    }

    public EntityResolver getEntityResolver() {
        return this.platformUnmarshaller.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.platformUnmarshaller.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.platformUnmarshaller.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.platformUnmarshaller.setErrorHandler(errorHandler);
    }

    public XMLUnmarshalListener getUnmarshalListener() {
        return this.unmarshalListener;
    }

    public void setUnmarshalListener(XMLUnmarshalListener listener) {
        this.unmarshalListener = listener;
    }

    public Class getUnmappedContentHandlerClass() {
        return this.unmappedContentHandlerClass;
    }

    public void setUnmappedContentHandlerClass(Class aClass) {
        this.unmappedContentHandlerClass = aClass;
    }

    public StrBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public Object unmarshal(File file) throws XMLMarshalException {
        if (file == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file);
    }

    public Object unmarshal(File file, Class clazz) throws XMLMarshalException {
        if (file == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file, clazz);
    }

    public Object unmarshal(InputStream inputStream) throws XMLMarshalException {
        if (inputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(InputStream inputStream, Class clazz) throws XMLMarshalException {
        if (inputStream == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream, clazz);
    }

    public Object unmarshal(Reader reader) throws XMLMarshalException {
        if (reader == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader);
    }

    public Object unmarshal(Reader reader, Class clazz) throws XMLMarshalException {
        if (reader == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader, clazz);
    }

    public Object unmarshal(URL url) throws XMLMarshalException {
        if (url == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(url);
    }

    public Object unmarshal(URL url, Class clazz) throws XMLMarshalException {
        if (url == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(url, clazz);
    }

    public Object unmarshal(InputSource inputSource) throws XMLMarshalException {
        if (inputSource == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource);
    }

    public Object unmarshal(InputSource inputSource, Class clazz) throws XMLMarshalException {
        if (inputSource == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(Node node) throws XMLMarshalException {
        if (node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 1 || node.getNodeType() == 11) {
            return this.platformUnmarshaller.unmarshal(node);
        }
        throw XMLMarshalException.unmarshalException();
    }

    public Object unmarshal(Node node, Class clazz) throws XMLMarshalException {
        if (node == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(node, clazz);
    }

    public Object unmarshal(Source source) throws XMLMarshalException {
        if (source == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (source.getClass() == staxSourceClass) {
            try {
                Object xmlStreamReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetStreamReaderMethod, source);
                if (xmlStreamReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderInputSourceConstructor, new Object[]{xmlStreamReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderReaderConstructor, new Object[0]);
                    return this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
                }
                Object xmlEventReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetEventReaderMethod, source);
                if (xmlEventReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderInputSourceConstructor, new Object[]{xmlEventReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderReaderConstructor, new Object[0]);
                    return this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
                }
            }
            catch (Exception e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return this.platformUnmarshaller.unmarshal(source);
    }

    public Properties getProperties() {
        if (this.unmarshalProperties == null) {
            this.unmarshalProperties = new Properties();
        }
        return this.unmarshalProperties;
    }

    public Object getProperty(Object key) {
        if (this.unmarshalProperties == null) {
            return null;
        }
        return this.unmarshalProperties.get(key);
    }

    public Object unmarshal(Source source, Class clazz) throws XMLMarshalException {
        if (source == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (source.getClass() == staxSourceClass) {
            try {
                Object xmlStreamReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetStreamReaderMethod, source);
                if (xmlStreamReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderInputSourceConstructor, new Object[]{xmlStreamReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderReaderConstructor, new Object[0]);
                    return this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
                }
                Object xmlEventReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetEventReaderMethod, source);
                if (xmlEventReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderInputSourceConstructor, new Object[]{xmlEventReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderReaderConstructor, new Object[0]);
                    return this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
                }
            }
            catch (Exception e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return this.platformUnmarshaller.unmarshal(source, clazz);
    }

    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        return this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
    }

    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class clazz) {
        return this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
    }

    public XMLUnmarshallerHandler getUnmarshallerHandler() {
        if (this.xmlUnmarshallerHandler == null) {
            this.xmlUnmarshallerHandler = new XMLUnmarshallerHandler(this);
        }
        return this.xmlUnmarshallerHandler;
    }

    public XMLAttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(XMLAttachmentUnmarshaller atu) {
        this.attachmentUnmarshaller = atu;
    }

    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.platformUnmarshaller.setResultAlwaysXMLRoot(alwaysReturnRoot);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.platformUnmarshaller.isResultAlwaysXMLRoot();
    }

    public void setSchema(Schema schema) {
        this.platformUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.platformUnmarshaller.getSchema();
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    public XMLUnmarshaller clone() {
        XMLUnmarshaller clone = new XMLUnmarshaller(this.xmlContext);
        clone.setAttachmentUnmarshaller(this.attachmentUnmarshaller);
        clone.setEntityResolver(this.getEntityResolver());
        clone.setErrorHandler(this.getErrorHandler());
        for (Map.Entry<Object, Object> entry : this.unmarshalProperties.entrySet()) {
            clone.getProperties().put(entry.getKey(), entry.getValue());
        }
        clone.setResultAlwaysXMLRoot(this.platformUnmarshaller.isResultAlwaysXMLRoot());
        try {
            Schema schema = this.getSchema();
            if (schema != null) {
                clone.setSchema(schema);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        clone.setUnmappedContentHandlerClass(this.unmappedContentHandlerClass);
        clone.setUnmarshalListener(this.unmarshalListener);
        clone.setValidationMode(this.getValidationMode());
        return clone;
    }
}

