/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping,
XMLNillableMapping {
    private boolean isCDATA;
    private boolean isWriteOnly;
    private AbstractNullPolicy nullPolicy = new NullPolicy();
    protected boolean reuseContainer;

    public XMLCompositeDirectCollectionMapping() {
        this.nullPolicy.setNullRepresentedByEmptyNode(true);
    }

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        super.initialize(session);
        if (this.getField() instanceof XMLField) {
            if (this.getValueConverter() instanceof TypeConversionConverter) {
                TypeConversionConverter converter = (TypeConversionConverter)this.getValueConverter();
                this.getField().setType(converter.getObjectClass());
            }
            String xpathString = ((XMLField)this.getField()).getXPath();
            if (this.isAbstractCompositeDirectCollectionMapping() && xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
                throw DescriptorException.invalidXpathForXMLDirectMapping(this);
            }
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    public void setXPath(String xpathString) {
        if (xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
            xpathString = String.valueOf(xpathString) + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        DOMRecord domRecord = (DOMRecord)row;
        Object fieldValue = domRecord.getValues(this.getField(), this.getNullPolicy());
        if (fieldValue == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            result = container != null ? container : cp.containerInstance();
        } else {
            result = cp.containerInstance(fieldValues.size());
        }
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (this.hasValueConverter()) {
                element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertDataValueToObjectValue(element, executionSession, ((XMLRecord)row).getUnmarshaller()) : this.getValueConverter().convertDataValueToObjectValue(element, executionSession);
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.hasValueConverter()) {
                element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(element, session);
            }
            if (element != null) {
                elements.addElement(element);
                continue;
            }
            if (this.getNullPolicy() == null) {
                elements.addElement(null);
                continue;
            }
            if (this.getNullPolicy().getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                elements.addElement(XMLRecord.NIL);
                continue;
            }
            if (this.getNullPolicy().getMarshalNullRepresentation() == XMLNullRepresentationType.ABSENT_NODE) continue;
            elements.addElement("");
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = value;
        if (this.hasValueConverter()) {
            element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(element, session, record.getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(element, session);
        }
        record.add(this.getField(), element);
    }

    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public void setNullPolicy(AbstractNullPolicy value) {
        this.nullPolicy = value;
    }

    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }
}

