/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSONWriterRecord
extends MarshalRecord {
    protected Writer writer;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    protected Stack<Level> levels = new Stack();
    protected static final String NULL = "null";
    protected String attributePrefix;

    public JSONWriterRecord() {
        this.namespaceSeparator = (char)46;
    }

    public boolean supportsSingleNode() {
        return false;
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.attributePrefix = marshaller.getAttributePrefix();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument(String encoding, String version) {
        try {
            if (this.levels.isEmpty()) {
                this.levels.push(new Level(true, false));
            }
            this.writer.write(123);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            this.writer.write(125);
            this.levels.pop();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.openStartElement(xPathFragment, namespaceResolver, true);
    }

    private void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean addOpenBrace) {
        try {
            Level position = null;
            if (this.levels.isEmpty()) {
                this.levels.push(new Level(true, true));
            } else {
                position = this.levels.peek();
                this.levels.push(new Level(true, true));
                if (position.isFirst()) {
                    position.setFirst(false);
                } else {
                    this.writer.write(44);
                    this.writer.write(32);
                }
            }
            if (xPathFragment.nameIsText() && position != null && position.isCollection() && position.isEmptyCollection()) {
                this.writer.write(91);
                position.setEmptyCollection(false);
                position.setNeedToOpenComplex(false);
                return;
            }
            if (position == null || !position.isCollection() || position.isEmptyCollection()) {
                if (position != null && position.needToOpenComplex) {
                    this.writer.write(123);
                    position.needToOpenComplex = false;
                    position.needToCloseComplex = true;
                }
                super.openStartElement(xPathFragment, namespaceResolver);
                this.isStartElementOpen = true;
                this.writer.write(34);
                if (xPathFragment.isAttribute() && this.attributePrefix != null) {
                    this.writer.write(this.attributePrefix);
                }
                if (this.isNamespaceAware() && xPathFragment.getNamespaceURI() != null) {
                    String prefix = null;
                    if (this.getNamespaceResolver() != null) {
                        prefix = this.getNamespaceResolver().resolveNamespaceURI(xPathFragment.getNamespaceURI());
                    } else if (namespaceResolver != null) {
                        prefix = namespaceResolver.resolveNamespaceURI(xPathFragment.getNamespaceURI());
                    }
                    if (prefix != null && !prefix.equals("")) {
                        this.writer.write(prefix);
                        this.writer.write(this.getNamespaceSeparator());
                    }
                }
                this.writer.write(xPathFragment.getLocalName());
                this.writer.write("\" : ");
                if ((xPathFragment.getNextFragment() == null || xPathFragment.getNextFragment().nameIsText()) && position != null && position.isCollection()) {
                    this.writer.write(91);
                }
                if (position != null && position.isEmptyCollection()) {
                    position.setEmptyCollection(false);
                }
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(60);
            this.writer.write(frag.getShortName());
            this.writer.write(47);
            this.writer.write(62);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.attribute(namespaceURI, localName, qName, value, true);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(xPathFragment, namespaceResolver, (Object)value, null);
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    private void attribute(String namespaceURI, String localName, String qName, String value, boolean wrapInQuotes) {
        if (namespaceURI != null && namespaceURI == "http://www.w3.org/2000/xmlns/") {
            return;
        }
        try {
            Level position = null;
            if (!this.levels.isEmpty()) {
                position = this.levels.peek();
                if (position.isFirst()) {
                    position.setFirst(false);
                } else {
                    this.writer.write(44);
                    this.writer.write(32);
                }
            }
            this.writer.write(34);
            if (this.attributePrefix != null) {
                this.writer.write(this.attributePrefix);
            }
            this.writer.write(localName);
            this.writer.write(34);
            this.writer.write(58);
            if (position != null && position.isCollection()) {
                this.writer.write(91);
            }
            if (wrapInQuotes) {
                this.characters(value);
            } else {
                this.nonStringCharacters(value);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.endElement(xPathFragment, namespaceResolver, true);
    }

    private void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean addCloseBrace) {
        try {
            if (!this.levels.isEmpty()) {
                Level position = this.levels.pop();
                if (position.needToOpenComplex) {
                    this.writer.write(123);
                    this.writer.write(125);
                } else if (position.needToCloseComplex) {
                    this.writer.write(125);
                }
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startCollection() {
        this.levels.peek().setCollection(true);
        this.levels.peek().setEmptyCollection(true);
    }

    public void endCollection() {
        try {
            this.writer.write(93);
            if (!this.levels.isEmpty()) {
                this.levels.peek().setCollection(false);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        Level position = this.levels.peek();
        position.setNeedToOpenComplex(false);
        try {
            this.writer.write(34);
            this.writeValue(value);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI() == "http://www.w3.org/2000/xmlns/") {
            return;
        }
        xPathFragment.setAttribute(true);
        xPathFragment.setAttribute(true);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(schemaType, value, false);
        this.endElement(xPathFragment, namespaceResolver);
    }

    public void characters(QName schemaType, Object value, boolean isCDATA) {
        Level position = this.levels.peek();
        position.setNeedToOpenComplex(false);
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            this.getStringForQName((QName)value);
            this.characters((String)value);
        } else if (value.getClass() == String.class) {
            if (schemaType != null && this.isNumericOrBooleanType(schemaType)) {
                String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
                this.nonStringCharacters(convertedValue);
            } else if (isCDATA) {
                this.cdata((String)value);
            } else {
                this.characters((String)value);
            }
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (schemaType == null) {
                if (value.getClass() == ClassConstants.BOOLEAN || ClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                    this.nonStringCharacters(convertedValue);
                } else {
                    this.characters(convertedValue);
                }
            } else if (schemaType != null && !this.isNumericOrBooleanType(schemaType)) {
                this.characters(convertedValue);
            } else if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.nonStringCharacters(convertedValue);
            }
        }
    }

    private boolean isNumericOrBooleanType(QName schemaType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(XMLConstants.BOOLEAN_QNAME) || schemaType.equals(XMLConstants.INTEGER_QNAME) || schemaType.equals(XMLConstants.INT_QNAME) || schemaType.equals(XMLConstants.DECIMAL_QNAME) || schemaType.equals(XMLConstants.FLOAT_QNAME) || schemaType.equals(XMLConstants.DOUBLE_QNAME) || schemaType.equals(XMLConstants.SHORT_QNAME);
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver, false);
        this.nonStringCharacters(NULL);
        this.endElement(xPathFragment, namespaceResolver, false);
    }

    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.nonStringCharacters(NULL);
        this.closeStartGroupingElements(groupingFragment);
    }

    public void emptySimple(NamespaceResolver namespaceResolver) {
        this.nilSimple(namespaceResolver);
    }

    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.endElement(xPathFragment, namespaceResolver);
    }

    protected void nonStringCharacters(String value) {
        Level position = this.levels.peek();
        position.setNeedToOpenComplex(false);
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        this.characters(value);
    }

    public XPathFragment getTextWrapperFragment() {
        return this.textWrapperFragment;
    }

    protected void writeValue(String value) {
        try {
            if (value.indexOf(34) > -1) {
                char[] chars = value.toCharArray();
                int x = 0;
                int charsSize = chars.length;
                while (x < charsSize) {
                    char character = chars[x];
                    if ('\"' == character) {
                        this.writer.write("\\\"");
                    } else {
                        this.writer.write(character);
                    }
                    ++x;
                }
            } else {
                this.writer.write(value);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            attr.getNamespaceURI();
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.nonStringCharacters(node.getNodeValue());
        } else {
            try {
                WriterRecordContentHandler wrcHandler = new WriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    protected static class Level {
        private boolean first;
        private boolean collection;
        private boolean emptyCollection;
        private boolean needToOpenComplex;
        private boolean needToCloseComplex;

        public Level(boolean value, boolean needToOpen) {
            this.first = value;
            this.needToOpenComplex = needToOpen;
        }

        public boolean isNeedToOpenComplex() {
            return this.needToOpenComplex;
        }

        public void setNeedToOpenComplex(boolean needToOpenComplex) {
            this.needToOpenComplex = needToOpenComplex;
        }

        public boolean isNeedToCloseComplex() {
            return this.needToCloseComplex;
        }

        public void setNeedToCloseComplex(boolean needToCloseComplex) {
            this.needToCloseComplex = needToCloseComplex;
        }

        public boolean isEmptyCollection() {
            return this.emptyCollection;
        }

        public void setEmptyCollection(boolean emptyCollection) {
            this.emptyCollection = emptyCollection;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean value) {
            this.first = value;
        }

        public boolean isCollection() {
            return this.collection;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }
    }

    protected class WriterRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        WriterRecordContentHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (JSONWriterRecord.this.isStartElementOpen) {
                    JSONWriterRecord.this.writer.write(62);
                }
                JSONWriterRecord.this.writer.write(60);
                JSONWriterRecord.this.writer.write(qName);
                JSONWriterRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (JSONWriterRecord.this.isStartElementOpen) {
                    JSONWriterRecord.this.writer.write(47);
                    JSONWriterRecord.this.writer.write(62);
                } else {
                    JSONWriterRecord.this.writer.write(60);
                    JSONWriterRecord.this.writer.write(47);
                    JSONWriterRecord.this.writer.write(qName);
                    JSONWriterRecord.this.writer.write(62);
                }
                JSONWriterRecord.this.isStartElementOpen = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = JSONWriterRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        public void characters(CharSequence characters) throws SAXException {
            if (JSONWriterRecord.this.isProcessingCData) {
                JSONWriterRecord.this.cdata(characters.toString());
                return;
            }
            if (JSONWriterRecord.this.isStartElementOpen) {
                try {
                    JSONWriterRecord.this.writer.write(62);
                    JSONWriterRecord.this.isStartElementOpen = false;
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            JSONWriterRecord.this.writeValue(characters.toString());
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (JSONWriterRecord.this.isStartElementOpen) {
                    JSONWriterRecord.this.writer.write(62);
                    JSONWriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    for (String prefix : this.prefixMappings.keySet()) {
                        JSONWriterRecord.this.writer.write(32);
                        JSONWriterRecord.this.writer.write("xmlns");
                        if (prefix != null && prefix.length() > 0) {
                            JSONWriterRecord.this.writer.write(58);
                            JSONWriterRecord.this.writer.write(prefix);
                        }
                        JSONWriterRecord.this.writer.write(61);
                        JSONWriterRecord.this.writer.write(34);
                        String uri = this.prefixMappings.get(prefix);
                        if (uri != null) {
                            JSONWriterRecord.this.writer.write(this.prefixMappings.get(prefix));
                        }
                        JSONWriterRecord.this.writer.write(34);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    JSONWriterRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            try {
                JSONWriterRecord.this.writer.write(60);
                JSONWriterRecord.this.writer.write(33);
                JSONWriterRecord.this.writer.write(45);
                JSONWriterRecord.this.writer.write(45);
                int x = start;
                while (x < length) {
                    JSONWriterRecord.this.writer.write(chars[x]);
                    ++x;
                }
                JSONWriterRecord.this.writer.write(45);
                JSONWriterRecord.this.writer.write(45);
                JSONWriterRecord.this.writer.write(62);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                int x = start;
                while (x < length) {
                    JSONWriterRecord.this.writer.write(chars[x]);
                    ++x;
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

