/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.persistence.jpa.internal.jpql.ContentAssistVisitor;
import org.eclipse.persistence.jpa.internal.jpql.DefaultContentAssistProposals;
import org.eclipse.persistence.jpa.internal.jpql.GrammarValidator;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.NumericTypeComparator;
import org.eclipse.persistence.jpa.internal.jpql.SemanticValidator;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPQLQueryHelper {
    private ContentAssistVisitor contentAssistVisitor;
    private GrammarValidator grammarValidator;
    private final JPQLQueryContext queryContext;
    private SemanticValidator semanticValidator;

    protected AbstractJPQLQueryHelper() {
        this(new JPQLQueryContext());
    }

    protected AbstractJPQLQueryHelper(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    protected ContentAssistProposals buildContentAssistProposals(int position) {
        QueryPosition queryPosition = this.getJPQLExpression().buildPosition(this.queryContext.getQuery().getExpression(), position);
        ContentAssistVisitor visitor = this.contentAssistVisitor();
        try {
            visitor.prepare(queryPosition);
            queryPosition.getExpression().accept(visitor);
            DefaultContentAssistProposals defaultContentAssistProposals = visitor.getProposals();
            return defaultContentAssistProposals;
        }
        finally {
            visitor.dispose();
        }
    }

    private ContentAssistVisitor contentAssistVisitor() {
        if (this.contentAssistVisitor == null) {
            this.contentAssistVisitor = new ContentAssistVisitor(this.queryContext);
        }
        return this.contentAssistVisitor;
    }

    protected void dispose() {
        this.queryContext.dispose();
    }

    private JPQLExpression getJPQLExpression() {
        return this.queryContext.getJPQLExpression();
    }

    protected IType getParameterType(String parameterName) {
        char character;
        char c = character = parameterName.length() > 0 ? parameterName.charAt(0) : (char)'\u0000';
        if (character != ':' && character != '?') {
            return this.getTypeHelper().objectType();
        }
        Collection<InputParameter> inputParameters = this.queryContext.findInputParameters(parameterName);
        if (inputParameters.isEmpty()) {
            return this.getTypeHelper().objectType();
        }
        TreeSet<IType> types = new TreeSet<IType>(this.buildNumericTypeComparator());
        for (InputParameter inputParameter : inputParameters) {
            IType type = this.queryContext.getParameterType(inputParameter);
            if (!type.isResolvable()) continue;
            types.add(type);
        }
        return types.isEmpty() ? this.getTypeHelper().objectType() : types.first();
    }

    private Comparator<IType> buildNumericTypeComparator() {
        return new NumericTypeComparator(this.getTypeHelper());
    }

    protected String getParsedJPQLQuery() {
        return this.getJPQLExpression().toParsedText();
    }

    protected IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    protected IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    protected JPQLQueryContext getQueryContext() {
        return this.queryContext;
    }

    protected IType getResultType() {
        IType type = this.queryContext.getType(this.getJPQLExpression());
        if (!type.isResolvable()) {
            type = this.getTypeHelper().objectType();
        }
        return type;
    }

    protected IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    protected TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    protected ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    private GrammarValidator grammarValidator() {
        if (this.grammarValidator == null) {
            this.grammarValidator = new GrammarValidator(this.queryContext);
        }
        return this.grammarValidator;
    }

    private SemanticValidator semanticValidator() {
        if (this.semanticValidator == null) {
            this.semanticValidator = new SemanticValidator(this.queryContext);
        }
        return this.semanticValidator;
    }

    public final void setJPQLExpression(JPQLExpression jpqlExpression) {
        this.queryContext.setJPQLExpression(jpqlExpression);
    }

    protected void setQuery(IQuery query) {
        this.queryContext.setQuery(query);
    }

    protected List<JPQLQueryProblem> validate() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validate(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validate(Expression expression, List<JPQLQueryProblem> problems) {
        this.validateGrammar(expression, problems);
        this.validateSemantic(expression, problems);
    }

    protected List<JPQLQueryProblem> validateGrammar() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validateGrammar(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateGrammar(Expression expression, List<JPQLQueryProblem> problems) {
        GrammarValidator visitor = this.grammarValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }

    protected List<JPQLQueryProblem> validateSemantic() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validateSemantic(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateSemantic(Expression expression, List<JPQLQueryProblem> problems) {
        SemanticValidator visitor = this.semanticValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }
}

