/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVisitor
extends AnonymousExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    private ManagedTypeVisitor managedTypeVisitor;
    private NullExpressionVisitor nullExpressionVisitor;
    protected final JPQLQueryContext queryContext;

    protected AbstractVisitor(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
        this.initialize();
    }

    protected final CollectionExpression collectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.collectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    private CollectionExpressionVisitor collectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = new CollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    public void dispose() {
    }

    protected IEmbeddable embeddable(IManagedType managedType) {
        if (managedType == null) {
            return null;
        }
        ManagedTypeVisitor visitor = this.managedTypeVisitor();
        try {
            managedType.accept(visitor);
            IEmbeddable iEmbeddable = visitor.embeddable;
            return iEmbeddable;
        }
        finally {
            visitor.embeddable = null;
            visitor.entity = null;
            visitor.mappedSuperclass = null;
        }
    }

    protected IEntity entity(IManagedType managedType) {
        if (managedType == null) {
            return null;
        }
        ManagedTypeVisitor visitor = this.managedTypeVisitor();
        try {
            managedType.accept(visitor);
            IEntity iEntity = visitor.entity;
            return iEntity;
        }
        finally {
            visitor.embeddable = null;
            visitor.entity = null;
            visitor.mappedSuperclass = null;
        }
    }

    protected IJPAVersion getJPAVersion() {
        return this.getProvider().getVersion();
    }

    protected IManagedType getManagedType(IType type) {
        return this.getProvider().getManagedType(type);
    }

    protected IManagedType getManagedType(String abstractSchemaName) {
        return this.getProvider().getManagedType(abstractSchemaName);
    }

    protected IMapping getMapping(Expression expression) {
        return this.queryContext.getMapping(expression);
    }

    protected IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    protected IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    protected String getQueryExpression() {
        return this.getQuery().getExpression();
    }

    protected Resolver getResolver(Expression expression) {
        return this.queryContext.getResolver(expression);
    }

    protected IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    protected IType getType(Expression expression) {
        return this.queryContext.getType(expression);
    }

    protected IType getType(String name) {
        return this.getTypeRepository().getType(name);
    }

    protected ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.queryContext.getTypeDeclaration(expression);
    }

    protected TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    protected ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    protected void initialize() {
    }

    protected boolean isEclipseLinkPlatform() {
        return this.getProvider().getPlatform() == IPlatform.ECLIPSE_LINK;
    }

    protected boolean isEmbeddable(IManagedType managedType) {
        return this.embeddable(managedType) != null;
    }

    protected boolean isEntity(IManagedType managedType) {
        return this.entity(managedType) != null;
    }

    protected boolean isJavaPlatform() {
        return this.getProvider().getPlatform() == IPlatform.JAVA;
    }

    protected boolean isMappedSuperclass(IManagedType managedType) {
        return this.mappedSuperclass(managedType) != null;
    }

    protected final boolean isNull(Expression expression) {
        NullExpressionVisitor visitor = this.nullExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    private ManagedTypeVisitor managedTypeVisitor() {
        if (this.managedTypeVisitor == null) {
            this.managedTypeVisitor = new ManagedTypeVisitor();
        }
        return this.managedTypeVisitor;
    }

    protected IMappedSuperclass mappedSuperclass(IManagedType managedType) {
        if (managedType == null) {
            return null;
        }
        ManagedTypeVisitor visitor = this.managedTypeVisitor();
        try {
            managedType.accept(visitor);
            IMappedSuperclass iMappedSuperclass = visitor.mappedSuperclass;
            return iMappedSuperclass;
        }
        finally {
            visitor.embeddable = null;
            visitor.entity = null;
            visitor.mappedSuperclass = null;
        }
    }

    private NullExpressionVisitor nullExpressionVisitor() {
        if (this.nullExpressionVisitor == null) {
            this.nullExpressionVisitor = new NullExpressionVisitor();
        }
        return this.nullExpressionVisitor;
    }

    @Override
    protected abstract void visit(Expression var1);

    private static class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        CollectionExpression expression;

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    private static class ManagedTypeVisitor
    implements IManagedTypeVisitor {
        IEmbeddable embeddable;
        IEntity entity;
        IMappedSuperclass mappedSuperclass;

        private ManagedTypeVisitor() {
        }

        public void visit(IEmbeddable embeddable) {
            this.embeddable = embeddable;
        }

        public void visit(IEntity entity) {
            this.entity = entity;
        }

        public void visit(IMappedSuperclass mappedSuperclass) {
            this.mappedSuperclass = mappedSuperclass;
        }
    }

    private static class NullExpressionVisitor
    extends AbstractExpressionVisitor {
        NullExpression expression;

        private NullExpressionVisitor() {
        }

        public void visit(NullExpression expression) {
            this.expression = expression;
        }
    }
}

