/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.internal.jpql.IdentificationVariableResolver;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.NullResolver;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclarationResolver
extends Resolver {
    private List<Declaration> declarations;
    private DeclarationVisitor declarationVisitor;
    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor;
    private JPQLQueryContext queryContext;
    private Map<String, Resolver> resolvers;
    private Map<IdentificationVariable, String> resultVariables;

    DeclarationResolver(DeclarationResolver parent, JPQLQueryContext queryContext) {
        super(parent);
        this.initialize(queryContext);
    }

    @Override
    public void accept(ResolverVisitor visitor) {
    }

    @Override
    IType buildType() {
        return this.getTypeHelper().unknownType();
    }

    @Override
    ITypeDeclaration buildTypeDeclaration() {
        return this.getTypeHelper().unknownTypeDeclaration();
    }

    @Override
    void checkParent(Resolver parent) {
    }

    void convertUnqualifiedDeclaration(Declaration declaration, String outerVariableName) {
        QualifyRangeDeclarationVisitor visitor = this.qualifyRangeDeclarationVisitor();
        try {
            visitor.declaration = declaration;
            visitor.outerVariableName = outerVariableName;
            declaration.declarationExpression.accept(visitor);
        }
        finally {
            visitor.declaration = null;
            visitor.outerVariableName = null;
        }
    }

    private DeclarationVisitor declarationVisitor() {
        if (this.declarationVisitor == null) {
            this.declarationVisitor = new DeclarationVisitor();
        }
        return this.declarationVisitor;
    }

    void dispose() {
        this.resolvers.clear();
        this.declarations.clear();
        this.resultVariables.clear();
    }

    List<Declaration> getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    Collection<JoinFetch> getJoinFetches(String variableName) {
        Collection<JoinFetch> joinFetches = this.getJoinFetchesImp(variableName);
        if (joinFetches.isEmpty() && this.getParent() != null) {
            joinFetches = this.getParent().getJoinFetchesImp(variableName);
        }
        return joinFetches;
    }

    private Collection<JoinFetch> getJoinFetchesImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return declaration.getJoinFetches();
        }
        return Collections.emptyList();
    }

    @Override
    public DeclarationResolver getParent() {
        return (DeclarationResolver)super.getParent();
    }

    @Override
    IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    Resolver getResolver(String variableName) {
        Resolver resolver = this.getResolverImp(variableName = variableName.toUpperCase());
        if (resolver == null && this.getParent() != null) {
            resolver = this.getParent().getResolver(variableName);
        }
        if (resolver == null) {
            resolver = new NullResolver(this);
            this.resolvers.put(variableName, resolver);
        }
        return resolver;
    }

    private Resolver getResolverImp(String variableName) {
        return this.resolvers.get(variableName);
    }

    Set<String> getResultVariables() {
        return new HashSet<String>(this.resultVariables.values());
    }

    boolean hasJoins() {
        for (Declaration declaration : this.declarations) {
            if (!declaration.hasJoins()) continue;
            return true;
        }
        return false;
    }

    private void initialize(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
        this.resolvers = new HashMap<String, Resolver>();
        this.declarations = new ArrayList<Declaration>();
        this.resultVariables = new HashMap<IdentificationVariable, String>();
    }

    boolean isCollectionIdentificationVariable(String variableName) {
        boolean result = this.isCollectionIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isCollectionIdentificationVariableImp(variableName);
        }
        return result;
    }

    private boolean isCollectionIdentificationVariableImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.rangeDeclaration && declaration.getVariableName().equalsIgnoreCase(variableName)) {
                return true;
            }
            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                if (!joinIdentificationVariable.equalsIgnoreCase(variableName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRangeIdentificationVariable(String variableName) {
        boolean result = this.isRangeIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isRangeIdentificationVariableImp(variableName);
        }
        return result;
    }

    private boolean isRangeIdentificationVariableImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.rangeDeclaration || !declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return true;
        }
        return false;
    }

    void populate(Expression expression) {
        expression.accept(this.declarationVisitor());
    }

    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor() {
        if (this.qualifyRangeDeclarationVisitor == null) {
            this.qualifyRangeDeclarationVisitor = new QualifyRangeDeclarationVisitor();
        }
        return this.qualifyRangeDeclarationVisitor;
    }

    private String visitDeclaration(Expression expression, Expression identificationVariable) {
        String variableName = this.queryContext.literal(identificationVariable, LiteralType.IDENTIFICATION_VARIABLE);
        if (ExpressionTools.stringIsNotEmpty(variableName)) {
            String internalVariableName = variableName.toUpperCase();
            if (!this.resolvers.containsKey(internalVariableName)) {
                Resolver resolver = this.queryContext.getResolver(expression);
                resolver = new IdentificationVariableResolver(resolver, variableName);
                this.resolvers.put(internalVariableName, resolver);
            }
            return variableName;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Declaration {
        String abstractSchemaName;
        Expression baseExpression;
        Expression declarationExpression;
        IdentificationVariable identificationVariable;
        List<JoinFetch> joinFetches;
        Set<String> joinIdentificationVariables;
        Map<Join, IdentificationVariable> joins;
        boolean rangeDeclaration;

        private void addJoin(Join join, IdentificationVariable identificationVariable) {
            if (this.joins == null) {
                this.joins = new LinkedHashMap<Join, IdentificationVariable>();
            }
            this.joins.put(join, identificationVariable);
        }

        private void addJoinFetch(JoinFetch joinFetch) {
            if (this.joinFetches == null) {
                this.joinFetches = new ArrayList<JoinFetch>();
            }
            this.joinFetches.add(joinFetch);
        }

        private Set<String> buildJoinIdentificationVariables() {
            HashSet<String> variables = new HashSet<String>();
            HashSet upperCaseVariables = new HashSet();
            for (IdentificationVariable identificationVariable : this.joins.values()) {
                String joinVariable = identificationVariable.getText();
                if (joinVariable.length() <= 0 || upperCaseVariables.contains(joinVariable.toUpperCase())) continue;
                variables.add(joinVariable);
            }
            return Collections.unmodifiableSet(variables);
        }

        private Map.Entry<Join, String> buildMapEntry(Map.Entry<Join, IdentificationVariable> entry) {
            IdentificationVariable variable = entry.getValue();
            String variableName = variable != null ? variable.getText() : "";
            return new AbstractMap.SimpleEntry<Join, String>(entry.getKey(), variableName);
        }

        public String getAbstractSchemaName() {
            return this.abstractSchemaName;
        }

        public Expression getBaseExpression() {
            return this.baseExpression;
        }

        public Expression getDeclarationExpression() {
            return this.declarationExpression;
        }

        public List<Map.Entry<Join, String>> getJoinEntries() {
            ArrayList<Map.Entry<Join, String>> entries = new ArrayList<Map.Entry<Join, String>>();
            for (Map.Entry<Join, IdentificationVariable> entry : this.joins.entrySet()) {
                entries.add(this.buildMapEntry(entry));
            }
            return entries;
        }

        public List<JoinFetch> getJoinFetches() {
            return this.joinFetches;
        }

        public Set<String> getJoinIdentificationVariables() {
            if (this.joinIdentificationVariables == null) {
                this.joinIdentificationVariables = this.hasJoins() ? this.buildJoinIdentificationVariables() : Collections.emptySet();
            }
            return this.joinIdentificationVariables;
        }

        public Collection<Join> getJoins() {
            return this.joins.keySet();
        }

        public String getVariableName() {
            if (this.identificationVariable == null) {
                return "";
            }
            return this.identificationVariable.getText();
        }

        public boolean hasJoinFetches() {
            return !this.joinFetches.isEmpty();
        }

        public boolean hasJoins() {
            return !this.joins.isEmpty();
        }

        public boolean isRange() {
            return this.rangeDeclaration;
        }

        private void lockData() {
            this.joins = this.joins != null ? Collections.unmodifiableMap(this.joins) : Collections.emptyMap();
            this.joinFetches = this.joinFetches != null ? Collections.unmodifiableList(this.joinFetches) : Collections.emptyList();
        }

        public String toString() {
            return this.declarationExpression.toParsedText();
        }
    }

    private class DeclarationVisitor
    extends AbstractExpressionVisitor {
        private Declaration currentDeclaration;

        private DeclarationVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        public void visit(CollectionMemberDeclaration expression) {
            Declaration declaration = new Declaration();
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            if (variableName.length() > 0) {
                declaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getCollectionValuedPathExpression();
            declaration.lockData();
            DeclarationResolver.this.declarations.add(declaration);
        }

        public void visit(DeleteClause expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.rangeDeclaration = true;
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            DeclarationResolver.this.resultVariables.put(expression, expression.getText());
        }

        public void visit(IdentificationVariableDeclaration expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getRangeVariableDeclaration();
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
                expression.getJoins().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(Join expression) {
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            if (variableName.length() > 0) {
                this.currentDeclaration.addJoin(expression, (IdentificationVariable)identificationVariable);
            } else {
                this.currentDeclaration.addJoin(expression, null);
            }
        }

        public void visit(JoinFetch expression) {
            this.currentDeclaration.addJoinFetch(expression);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            String entityName;
            Expression identificationVariable;
            Expression abstractSchemaName = expression.getAbstractSchemaName();
            String variableName = DeclarationResolver.this.visitDeclaration(abstractSchemaName, identificationVariable = expression.getIdentificationVariable());
            if (variableName.length() > 0) {
                this.currentDeclaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
            if (ExpressionTools.stringIsNotEmpty(entityName = DeclarationResolver.this.queryContext.literal(abstractSchemaName, LiteralType.ABSTRACT_SCHEMA_NAME))) {
                this.currentDeclaration.rangeDeclaration = true;
                this.currentDeclaration.abstractSchemaName = entityName;
            } else {
                String joinAssociation;
                this.currentDeclaration.abstractSchemaName = joinAssociation = DeclarationResolver.this.queryContext.literal(abstractSchemaName, LiteralType.PATH_EXPRESSION_ALL_PATH);
            }
        }

        public void visit(ResultVariable expression) {
            expression.getResultVariable().accept(this);
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SelectStatement expression) {
            expression.getFromClause().accept(this);
            expression.getSelectClause().accept(this);
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SimpleSelectStatement expression) {
            expression.getFromClause().accept(this);
        }

        public void visit(UpdateClause expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.rangeDeclaration = true;
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }

    private class QualifyRangeDeclarationVisitor
    extends AbstractExpressionVisitor {
        Declaration declaration;
        String outerVariableName;

        private QualifyRangeDeclarationVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.declaration.baseExpression = expression;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            this.declaration.rangeDeclaration = false;
            expression.setVirtualIdentificationVariable(this.outerVariableName, this.declaration.abstractSchemaName);
            expression.getAbstractSchemaName().accept(this);
        }
    }
}

