/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.persistence.jpa.internal.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractConditionalClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrammarValidator
extends AbstractValidator {
    private CollectionSeparatedByCommaValidator collectionSeparatedByCommaValidator;
    private CollectionSeparatedBySpaceValidator collectionSeparatedBySpaceValidator;
    private ComparisonExpressionVisitor comparisonExpressionVisitor;
    private FuncExpressionFinder funcExpressionFinder;
    private Map<String, Object> helpers;
    private Collection<InputParameter> inputParameters;
    private static Pattern numericalLiteralPattern;
    private static final String REGULAR_EXPRESSION_NUMERIC_LITERAL = "^[-+]?[0-9]*((\\.[0-9]+([fFdD]|([eE][-+]?[0-9]+))?)|([fFdDlL]|([eE][-+]?[0-9]+)))?$";

    public GrammarValidator(JPQLQueryContext context) {
        super(context);
    }

    private AbstractSingleEncapsulatedExpressionHelper<AbsExpression> absExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AbsExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<AbsExpression>)this.getHelper("ABS");
        if (helper == null) {
            helper = this.buildAbsExpressionHelper();
            this.helpers.put("ABS", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> allOrAnyExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression>)this.getHelper("ALL");
        if (helper == null) {
            helper = this.buildAllOrAnyExpressionHelper();
            this.helpers.put("ALL", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<AvgFunction> avgFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AvgFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<AvgFunction>)this.getHelper("AVG");
        if (helper == null) {
            helper = this.buildAvgFunctionHelper();
            this.helpers.put("AVG", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<AbsExpression> buildAbsExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AbsExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "ABS_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "ABS_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "ABS_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "ABS_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> buildAllOrAnyExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression>(){

            @Override
            public String[] arguments(AllOrAnyExpression expression) {
                return new String[]{expression.getIdentifier()};
            }

            @Override
            public String expressionInvalidKey() {
                return "ALL_OR_ANY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "ALL_OR_ANY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "ALL_OR_ANY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "ALL_OR_ANY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<AvgFunction> buildAvgFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AvgFunction>(){

            @Override
            public String expressionInvalidKey() {
                return "AVG_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "AVG_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "AVG_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(AvgFunction expression) {
                return expression.hasDistinct() ? "DISTINCT".length() + (expression.hasSpaceAfterDistinct() ? 1 : 0) : (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "AVG_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> buildCoalesceExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "COALESCE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "COALESCE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "COALESCE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "COALESCE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> buildConcatExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ConcatExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "CONCAT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "CONCAT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(ConcatExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "CONCAT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "CONCAT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<CountFunction> buildCountFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<CountFunction>(){

            @Override
            public String expressionInvalidKey() {
                return "COUNT_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "COUNT_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "COUNT_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(CountFunction expression) {
                return expression.hasDistinct() ? "DISTINCT".length() + (expression.hasSpaceAfterDistinct() ? 1 : 0) : (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "COUNT_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<EntryExpression> buildEntryExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<EntryExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "ENTRY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "ENTRY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(EntryExpression expression) {
                return GrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "ENTRY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "ENTRY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> buildExistsExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ExistsExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "EXISTS_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "EXISTS_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "EXISTS_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "EXISTS_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<FuncExpression> buildFuncExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<FuncExpression>(){

            @Override
            public String expressionInvalidKey() {
                return null;
            }

            @Override
            public String expressionMissingKey() {
                return "FUNC_EXPRESSION_MISSING_FUNCTION_NAME";
            }

            @Override
            public boolean hasExpression(FuncExpression expression) {
                return true;
            }

            @Override
            public boolean isValidExpression(FuncExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "FUNC_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "FUNC_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<IndexExpression> buildIndexExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<IndexExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "INDEX_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "INDEX_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(IndexExpression expression) {
                return GrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "INDEX_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "INDEX_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<KeyExpression> buildKeyExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<KeyExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "KEY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "KEY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(KeyExpression expression) {
                return GrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "KEY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "KEY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<LengthExpression> buildLengthExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<LengthExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "LENGTH_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "LENGTH_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "LENGTH_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "LENGTH_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractTripleEncapsulatedExpressionHelper<LocateExpression> buildLocateExpressionHelper() {
        return new AbstractTripleEncapsulatedExpressionHelper<LocateExpression>(){

            @Override
            public String firstCommaMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_FIRST_COMMA";
            }

            @Override
            public String firstExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            public String firstExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String identifier(LocateExpression expression) {
                return "LOCATE";
            }

            @Override
            public boolean isFirstExpressionValid(LocateExpression expression) {
                return GrammarValidator.this.isValid(expression.getFirstExpression(), "string_primary");
            }

            @Override
            public boolean isSecondExpressionValid(LocateExpression expression) {
                return GrammarValidator.this.isValid(expression.getSecondExpression(), "string_primary");
            }

            @Override
            public boolean isThirdExpressionValid(LocateExpression expression) {
                return GrammarValidator.this.isValid(expression.getThirdExpression(), "string_primary");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            public String secondCommaMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_SECOND_COMMA";
            }

            @Override
            public String secondExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            public String secondExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }

            @Override
            public String thirdExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_THIRD_EXPRESSION";
            }

            @Override
            public String thirdExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_THIRD_EXPRESSION";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<LowerExpression> buildLowerExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<LowerExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "LOWER_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "LOWER_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "LOWER_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "LOWER_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<MaxFunction> buildMaxFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<MaxFunction>(){

            @Override
            public String expressionInvalidKey() {
                return "MAX_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "MAX_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "MAX_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(MaxFunction expression) {
                return expression.hasDistinct() ? "DISTINCT".length() + (expression.hasSpaceAfterDistinct() ? 1 : 0) : (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "MAX_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<MinFunction> buildMinFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<MinFunction>(){

            @Override
            public String expressionInvalidKey() {
                return "MIN_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "MIN_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "MIN_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(MinFunction expression) {
                return expression.hasDistinct() ? "DISTINCT".length() + (expression.hasSpaceAfterDistinct() ? 1 : 0) : (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "MIN_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractDoubleEncapsulatedExpressionHelper<ModExpression> buildModExpressionHelper() {
        return new AbstractDoubleEncapsulatedExpressionHelper<ModExpression>(){

            @Override
            public String firstExpressionInvalidKey() {
                return "MOD_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            public String firstExpressionMissingKey() {
                return "MOD_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String identifier(ModExpression expression) {
                return "MOD";
            }

            @Override
            public boolean isFirstExpressionValid(ModExpression expression) {
                return GrammarValidator.this.isValid(expression.getFirstExpression(), "simple_arithmetic_expression");
            }

            @Override
            public boolean isSecondExpressionValid(ModExpression expression) {
                return GrammarValidator.this.isValid(expression.getSecondExpression(), "simple_arithmetic_expression");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "MOD_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String missingCommaKey() {
                return "MOD_EXPRESSION_MISSING_COMMA";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "MOD_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            public String secondExpressionInvalidKey() {
                return "MOD_EXPRESSION_INVALID_SECOND_PARENTHESIS";
            }

            @Override
            public String secondExpressionMissingKey() {
                return "MOD_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }
        };
    }

    private AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> buildNullIfExpressionHelper() {
        return new AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression>(){

            @Override
            public String firstExpressionInvalidKey() {
                return "NULLIF_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            public String firstExpressionMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String identifier(NullIfExpression expression) {
                return "NULLIF";
            }

            @Override
            public boolean isFirstExpressionValid(NullIfExpression expression) {
                return GrammarValidator.this.isValid(expression.getFirstExpression(), "scalar_expression");
            }

            @Override
            public boolean isSecondExpressionValid(NullIfExpression expression) {
                return GrammarValidator.this.isValid(expression.getSecondExpression(), "scalar_expression");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String missingCommaKey() {
                return "NULLIF_EXPRESSION_MISSING_COMMA";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            public String secondExpressionInvalidKey() {
                return "NULLIF_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            public String secondExpressionMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> buildObjectExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ObjectExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "OBJECT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "OBJECT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(ObjectExpression expression) {
                return GrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "OBJECT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "OBJECT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<SizeExpression> buildSizeExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SizeExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "SIZE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "SIZE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "SIZE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "SIZE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> buildSqrtExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SqrtExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "SQRT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "SQRT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "SQRT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "SQRT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> buildSubstringExpressionHelper() {
        return new AbstractTripleEncapsulatedExpressionHelper<SubstringExpression>(){

            @Override
            public String firstCommaMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_FIRST_COMMA";
            }

            @Override
            public String firstExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            public String firstExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public boolean hasThirdExpression(SubstringExpression expression) {
                boolean hasThirdExpression = super.hasThirdExpression(expression);
                if (!hasThirdExpression && GrammarValidator.this.getJPAVersion().isNewerThanOrEqual(IJPAVersion.VERSION_2_0)) {
                    hasThirdExpression = true;
                }
                return hasThirdExpression;
            }

            @Override
            public String identifier(SubstringExpression expression) {
                return "SUBSTRING";
            }

            @Override
            public boolean isFirstExpressionValid(SubstringExpression expression) {
                return GrammarValidator.this.isValid(expression.getFirstExpression(), "simple_arithmetic_expression");
            }

            @Override
            public boolean isSecondExpressionValid(SubstringExpression expression) {
                return GrammarValidator.this.isValid(expression.getSecondExpression(), "simple_arithmetic_expression");
            }

            @Override
            public boolean isThirdExpressionValid(SubstringExpression expression) {
                return GrammarValidator.this.isValid(expression.getThirdExpression(), "simple_arithmetic_expression");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            public String secondCommaMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_SECOND_COMMA";
            }

            @Override
            public String secondExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            public String secondExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }

            @Override
            public String thirdExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_THIRD_EXPRESSION";
            }

            @Override
            public String thirdExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_THIRD_EXPRESSION";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<SumFunction> buildSumFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SumFunction>(){

            @Override
            public String expressionInvalidKey() {
                return "SUM_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "SUM_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "SUM_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(SumFunction expression) {
                return expression.hasDistinct() ? "DISTINCT".length() + (expression.hasSpaceAfterDistinct() ? 1 : 0) : (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "SUM_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<TrimExpression> buildTrimExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<TrimExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "TRIM_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "TRIM_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean hasExpression(TrimExpression expression) {
                return true;
            }

            @Override
            public boolean isValidExpression(TrimExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "TRIM_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "TRIM_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<TypeExpression> buildTypeExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<TypeExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "TYPE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "TYPE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "TYPE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "TYPE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<UpperExpression> buildUpperExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<UpperExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "UPPER_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "UPPER_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "UPPER_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "UPPER_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<ValueExpression> buildValueExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ValueExpression>(){

            @Override
            public String expressionInvalidKey() {
                return "VALUE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String expressionMissingKey() {
                return "VALUE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isValidExpression(ValueExpression expression) {
                return GrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey() {
                return "VALUE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey() {
                return "VALUE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    private AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> coalesceExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression>)this.getHelper("COALESCE");
        if (helper == null) {
            helper = this.buildCoalesceExpressionHelper();
            this.helpers.put("COALESCE", helper);
        }
        return helper;
    }

    private CollectionSeparatedByCommaValidator collectionSeparatedByCommaValidator() {
        if (this.collectionSeparatedByCommaValidator == null) {
            this.collectionSeparatedByCommaValidator = new CollectionSeparatedByCommaValidator();
        }
        return this.collectionSeparatedByCommaValidator;
    }

    private CollectionSeparatedBySpaceValidator collectionSeparatedBySpaceValidator() {
        if (this.collectionSeparatedBySpaceValidator == null) {
            this.collectionSeparatedBySpaceValidator = new CollectionSeparatedBySpaceValidator();
        }
        return this.collectionSeparatedBySpaceValidator;
    }

    private ComparisonExpressionVisitor comparisonExpressionVisitor() {
        if (this.comparisonExpressionVisitor == null) {
            this.comparisonExpressionVisitor = new ComparisonExpressionVisitor();
        }
        return this.comparisonExpressionVisitor;
    }

    private AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> concatExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ConcatExpression>)this.getHelper("CONCAT");
        if (helper == null) {
            helper = this.buildConcatExpressionHelper();
            this.helpers.put("CONCAT", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<CountFunction> countFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<CountFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<CountFunction>)this.getHelper("COUNT");
        if (helper == null) {
            helper = this.buildCountFunctionHelper();
            this.helpers.put("COUNT", helper);
        }
        return helper;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.inputParameters.clear();
    }

    private AbstractSingleEncapsulatedExpressionHelper<EntryExpression> entryExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<EntryExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<EntryExpression>)this.getHelper("ENTRY");
        if (helper == null) {
            helper = this.buildEntryExpressionHelper();
            this.helpers.put("ENTRY", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> existsExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ExistsExpression>)this.getHelper("EXISTS");
        if (helper == null) {
            helper = this.buildExistsExpressionHelper();
            this.helpers.put("EXISTS", helper);
        }
        return helper;
    }

    private FuncExpressionFinder funcExpressionFinder() {
        if (this.funcExpressionFinder == null) {
            this.funcExpressionFinder = new FuncExpressionFinder();
        }
        return this.funcExpressionFinder;
    }

    private AbstractSingleEncapsulatedExpressionHelper<FuncExpression> funcExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<FuncExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<FuncExpression>)this.getHelper("FUNC");
        if (helper == null) {
            helper = this.buildFuncExpressionHelper();
            this.helpers.put("FUNC", helper);
        }
        return helper;
    }

    private <T> T getHelper(String identifier) {
        return (T)this.helpers.get(identifier);
    }

    private AbstractSingleEncapsulatedExpressionHelper<IndexExpression> indexExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<IndexExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<IndexExpression>)this.getHelper("INDEX");
        if (helper == null) {
            helper = this.buildIndexExpressionHelper();
            this.helpers.put("INDEX", helper);
        }
        return helper;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.helpers = new HashMap<String, Object>();
        this.inputParameters = new ArrayList<InputParameter>();
    }

    private boolean isChildOfComparisonExpession(AllOrAnyExpression expression) {
        ComparisonExpressionVisitor visitor = this.comparisonExpressionVisitor();
        AbstractValidator.BypassParentSubExpressionVisitor bypassVisitor = this.bypassParentSubExpressionVisitor();
        try {
            bypassVisitor.visitor = visitor;
            expression.getParent().accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            bypassVisitor.visitor = null;
            visitor.expression = null;
        }
    }

    private boolean isIdentificationVariableDeclaredBefore(String variableName, int variableNameIndex, int joinIndex, List<DeclarationResolver.Declaration> declarations) {
        boolean scanDeclaration = joinIndex > -1;
        int index = 0;
        while (!(scanDeclaration ? index > variableNameIndex : index >= variableNameIndex)) {
            DeclarationResolver.Declaration declaration = declarations.get(index);
            String previousVariableName = declaration.getVariableName();
            if (variableName.equalsIgnoreCase(previousVariableName)) {
                return true;
            }
            if (declaration.hasJoins()) {
                List<Map.Entry<Join, String>> joinEntries = declaration.getJoinEntries();
                int endIndex = index == variableNameIndex ? joinIndex : joinEntries.size();
                int subIndex = 0;
                while (subIndex < endIndex) {
                    Map.Entry<Join, String> join = joinEntries.get(subIndex);
                    previousVariableName = join.getValue();
                    if (variableName.equalsIgnoreCase(previousVariableName)) {
                        return true;
                    }
                    ++subIndex;
                }
            }
            ++index;
        }
        return false;
    }

    private boolean isInFuncExpressionInSelectClause(AbstractValidator.OwningClauseVisitor visitor, InputParameter expression) {
        if (visitor.selectClause == null && visitor.simpleSelectClause == null) {
            return false;
        }
        FuncExpressionFinder finder = this.funcExpressionFinder();
        try {
            expression.accept(finder);
            boolean bl = finder.expression != null;
            return bl;
        }
        finally {
            finder.expression = null;
        }
    }

    private boolean isNumericLiteral(String text) {
        return this.numericalLiteralPattern().matcher(text).matches();
    }

    private boolean isRightParenthesisMissing(AbstractTripleEncapsulatedExpression expression) {
        if (!expression.hasLeftParenthesis() || !expression.hasFirstExpression() || expression.hasRightParenthesis()) {
            return false;
        }
        if (!(!expression.hasFirstExpression() || expression.hasFirstComma() || expression.hasSecondExpression() || expression.hasSecondComma() || expression.hasThirdExpression())) {
            return false;
        }
        if (expression.hasFirstComma() && !expression.hasSecondExpression() && !expression.hasSecondComma() && !expression.hasThirdExpression()) {
            return false;
        }
        return !expression.hasSecondExpression() || !expression.hasSecondComma() || expression.hasThirdExpression();
    }

    private boolean isValidJPA20Identifier() {
        return this.isEclipseLinkPlatform() || this.getJPAVersion().isNewerThanOrEqual(IJPAVersion.VERSION_2_0);
    }

    private AbstractSingleEncapsulatedExpressionHelper<KeyExpression> keyExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<KeyExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<KeyExpression>)this.getHelper("KEY");
        if (helper == null) {
            helper = this.buildKeyExpressionHelper();
            this.helpers.put("KEY", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<LengthExpression> lengthExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<LengthExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<LengthExpression>)this.getHelper("LENGTH");
        if (helper == null) {
            helper = this.buildLengthExpressionHelper();
            this.helpers.put("LENGTH", helper);
        }
        return helper;
    }

    private AbstractTripleEncapsulatedExpressionHelper<LocateExpression> locateExpressionHelper() {
        AbstractTripleEncapsulatedExpressionHelper<LocateExpression> helper = (AbstractTripleEncapsulatedExpressionHelper<LocateExpression>)this.getHelper("LOCATE");
        if (helper == null) {
            helper = this.buildLocateExpressionHelper();
            this.helpers.put("LOCATE", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<LowerExpression> lowerExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<LowerExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<LowerExpression>)this.getHelper("LOWER");
        if (helper == null) {
            helper = this.buildLowerExpressionHelper();
            this.helpers.put("LOWER", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<MaxFunction> maxFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<MaxFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<MaxFunction>)this.getHelper("MAX");
        if (helper == null) {
            helper = this.buildMaxFunctionHelper();
            this.helpers.put("MAX", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<MinFunction> minFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<MinFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<MinFunction>)this.getHelper("MIN");
        if (helper == null) {
            helper = this.buildMinFunctionHelper();
            this.helpers.put("MIN", helper);
        }
        return helper;
    }

    private AbstractDoubleEncapsulatedExpressionHelper<ModExpression> modExpressionHelper() {
        AbstractDoubleEncapsulatedExpressionHelper<ModExpression> helper = (AbstractDoubleEncapsulatedExpressionHelper<ModExpression>)this.getHelper("MOD");
        if (helper == null) {
            helper = this.buildModExpressionHelper();
            this.helpers.put("MOD", helper);
        }
        return helper;
    }

    private AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> nullIfExpressionHelper() {
        AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> helper = (AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression>)this.getHelper("NULLIF");
        if (helper == null) {
            helper = this.buildNullIfExpressionHelper();
            this.helpers.put("NULLIF", helper);
        }
        return helper;
    }

    private Pattern numericalLiteralPattern() {
        if (numericalLiteralPattern == null) {
            numericalLiteralPattern = Pattern.compile(REGULAR_EXPRESSION_NUMERIC_LITERAL);
        }
        return numericalLiteralPattern;
    }

    private AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> objectExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ObjectExpression>)this.getHelper("OBJECT");
        if (helper == null) {
            helper = this.buildObjectExpressionHelper();
            this.helpers.put("OBJECT", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<SizeExpression> sizeExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SizeExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<SizeExpression>)this.getHelper("SIZE");
        if (helper == null) {
            helper = this.buildSizeExpressionHelper();
            this.helpers.put("SIZE", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> sqrtExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<SqrtExpression>)this.getHelper("SQRT");
        if (helper == null) {
            helper = this.buildSqrtExpressionHelper();
            this.helpers.put("SQRT", helper);
        }
        return helper;
    }

    private AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> substringExpressionHelper() {
        AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> helper = (AbstractTripleEncapsulatedExpressionHelper<SubstringExpression>)this.getHelper("SUBSTRING");
        if (helper == null) {
            helper = this.buildSubstringExpressionHelper();
            this.helpers.put("SUBSTRING", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<SumFunction> sumFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SumFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<SumFunction>)this.getHelper("SUM");
        if (helper == null) {
            helper = this.buildSumFunctionHelper();
            this.helpers.put("SUM", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<TrimExpression> trimExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<TrimExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<TrimExpression>)this.getHelper("TRIM");
        if (helper == null) {
            helper = this.buildTrimExpressionHelper();
            this.helpers.put("TRIM", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<TypeExpression> typeExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<TypeExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<TypeExpression>)this.getHelper("TYPE");
        if (helper == null) {
            helper = this.buildTypeExpressionHelper();
            this.helpers.put("TYPE", helper);
        }
        return helper;
    }

    private AbstractSingleEncapsulatedExpressionHelper<UpperExpression> upperExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<UpperExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<UpperExpression>)this.getHelper("UPPER");
        if (helper == null) {
            helper = this.buildUpperExpressionHelper();
            this.helpers.put("UPPER", helper);
        }
        return helper;
    }

    private void validateAbstractConditionalClause(AbstractConditionalClause expression, String missingConditionalExpressionMessageKey, String invalidConditionalExpressionMessageKey) {
        if (!expression.hasConditionalExpression()) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + expression.getIdentifier().length();
            if (expression.hasSpaceAfterIdentifier()) {
                ++endPosition;
            }
            this.addProblem((Expression)expression, startPosition, endPosition, missingConditionalExpressionMessageKey, new String[0]);
        } else {
            Expression conditionalExpression = expression.getConditionalExpression();
            if (!this.isValid(conditionalExpression, "conditional_expression")) {
                int startPosition = this.position(conditionalExpression);
                int endPosition = startPosition + this.length(conditionalExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, invalidConditionalExpressionMessageKey, new String[0]);
            }
        }
    }

    private <T extends AbstractDoubleEncapsulatedExpression> void validateAbstractDoubleEncapsulatedExpression(T expression, AbstractDoubleEncapsulatedExpressionHelper<T> helper) {
        int endPosition;
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!expression.hasLeftParenthesis()) {
            endPosition = startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, endPosition, helper.leftParenthesisMissingKey(), new String[0]);
        }
        if (expression.hasLeftParenthesis() && helper.hasSecondExpression(expression) && !expression.hasRightParenthesis()) {
            startPosition = this.position(expression) + identifier.length() + 1;
            if (helper.hasFirstExpression(expression)) {
                startPosition += this.length(expression.getFirstExpression());
            }
            if (expression.hasComma()) {
                ++startPosition;
            }
            if (expression.hasSpaceAfterComma()) {
                ++startPosition;
            }
            if (helper.hasSecondExpression(expression)) {
                startPosition += this.length(expression.getSecondExpression());
            }
            endPosition = startPosition;
            this.addProblem(expression, startPosition, endPosition, helper.rightParenthesisMissingKey(), new String[0]);
        }
        if (expression.hasLeftParenthesis()) {
            if (!helper.hasFirstExpression(expression)) {
                endPosition = startPosition = this.position(expression) + identifier.length() + 1;
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionMissingKey(), new String[0]);
            } else if (!helper.isFirstExpressionValid(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                endPosition = startPosition + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionInvalidKey(), new String[0]);
            } else {
                expression.getFirstExpression().accept(this);
            }
            if (helper.hasFirstExpression(expression) && !expression.hasComma()) {
                startPosition = this.position(expression) + identifier.length() + 1;
                if (helper.hasFirstExpression(expression)) {
                    startPosition += this.length(expression.getFirstExpression());
                }
                endPosition = startPosition;
                this.addProblem(expression, startPosition, endPosition, helper.missingCommaKey(), new String[0]);
            }
            if (expression.hasComma()) {
                if (!helper.hasSecondExpression(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1;
                    if (helper.hasFirstExpression(expression)) {
                        startPosition += helper.firstExpressionLength(expression);
                    }
                    if (expression.hasComma()) {
                        ++startPosition;
                    }
                    if (expression.hasSpaceAfterComma()) {
                        ++startPosition;
                    }
                    endPosition = startPosition;
                    this.addProblem(expression, startPosition, endPosition, helper.secondExpressionMissingKey(), new String[0]);
                } else if (!helper.isSecondExpressionValid(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1;
                    if (helper.hasFirstExpression(expression)) {
                        startPosition += helper.firstExpressionLength(expression);
                    }
                    if (expression.hasComma()) {
                        ++startPosition;
                    }
                    if (expression.hasSpaceAfterComma()) {
                        ++startPosition;
                    }
                    endPosition = startPosition + helper.secondExpressionLength(expression);
                    this.addProblem(expression, startPosition, endPosition, helper.secondExpressionInvalidKey(), new String[0]);
                } else {
                    expression.getSecondExpression().accept(this);
                }
            }
        }
    }

    private void validateAbstractFromClause(AbstractFromClause expression) {
        if (expression.hasDeclaration()) {
            this.validateCollectionSeparatedByComma(expression.getDeclaration(), "ABSTRACT_FROM_CLAUSE_IDENTIFICATION_VARIABLE_DECLARATION_ENDS_WITH_COMMA", "ABSTRACT_FROM_CLAUSE_IDENTIFICATION_VARIABLE_DECLARATION_IS_MISSING_COMMA");
            List<DeclarationResolver.Declaration> declarations = this.queryContext.getDeclarations();
            int index = 0;
            int count = declarations.size();
            while (index < count) {
                String variableName;
                DeclarationResolver.Declaration declaration = declarations.get(index);
                if (declaration.isRange() && declaration.hasJoins()) {
                    List<Map.Entry<Join, String>> joinEntries = declaration.getJoinEntries();
                    int joinIndex = 0;
                    int joinCount = joinEntries.size();
                    while (joinIndex < joinCount) {
                        Map.Entry<Join, String> joinEntry = joinEntries.get(joinIndex);
                        Join join = joinEntry.getKey();
                        String variableName2 = this.queryContext.literal(join.getJoinAssociationPath(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                        if (ExpressionTools.stringIsNotEmpty(variableName2) && !this.isIdentificationVariableDeclaredBefore(variableName2, index, joinIndex, declarations)) {
                            int startPosition = this.position(join.getJoinAssociationPath());
                            int endPosition = startPosition + variableName2.length();
                            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName2);
                        }
                        ++joinIndex;
                    }
                } else if (!declaration.isRange() && ExpressionTools.stringIsNotEmpty(variableName = this.queryContext.literal(declaration.getBaseExpression(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE)) && !this.isIdentificationVariableDeclaredBefore(variableName, index, -1, declarations)) {
                    int startPosition = this.position(declaration.getDeclarationExpression()) - variableName.length();
                    int endPosition = startPosition + variableName.length();
                    this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName);
                }
                ++index;
            }
        } else {
            int startPosition = this.position(expression) + "FROM".length();
            if (expression.hasSpaceAfterFrom()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_MISSING_IDENTIFICATION_VARIABLE_DECLARATION", new String[0]);
        }
    }

    private <T extends AbstractSingleEncapsulatedExpression> void validateAbstractSingleEncapsulatedExpression(T expression, AbstractSingleEncapsulatedExpressionHelper<T> helper) {
        int endPosition;
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!expression.hasLeftParenthesis()) {
            endPosition = startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, endPosition, helper.leftParenthesisMissingKey(), helper.arguments(expression));
        } else if (!helper.hasExpression(expression)) {
            endPosition = startPosition = this.position(expression) + identifier.length() + 1 + helper.lengthBeforeEncapsulatedExpression(expression);
            this.addProblem(expression, startPosition, endPosition, helper.expressionMissingKey(), helper.arguments(expression));
        } else if (!helper.isValidExpression(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1 + helper.lengthBeforeEncapsulatedExpression(expression);
            endPosition = startPosition + helper.encapsulatedExpressionLength(expression);
            this.addProblem(expression, startPosition, endPosition, helper.expressionInvalidKey(), helper.arguments(expression));
        } else {
            super.visit(expression);
        }
        if (!expression.hasRightParenthesis()) {
            endPosition = startPosition = this.position(expression) + this.length(expression);
            this.addProblem(expression, startPosition, endPosition, helper.rightParenthesisMissingKey(), helper.arguments(expression));
        }
    }

    private <T extends AbstractTripleEncapsulatedExpression> void validateAbstractTripleEncapsulatedExpression(T expression, AbstractTripleEncapsulatedExpressionHelper<T> helper) {
        int endPosition;
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!expression.hasLeftParenthesis()) {
            endPosition = startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, endPosition, helper.leftParenthesisMissingKey(), new String[0]);
        }
        if (expression.hasLeftParenthesis() && helper.hasFirstExpression(expression) && !expression.hasRightParenthesis() && this.isRightParenthesisMissing(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1;
            if (helper.hasFirstExpression(expression)) {
                startPosition += this.length(expression.getFirstExpression());
            }
            if (expression.hasFirstComma()) {
                ++startPosition;
            }
            if (expression.hasSpaceAfterFirstComma()) {
                ++startPosition;
            }
            if (helper.hasSecondExpression(expression)) {
                startPosition += this.length(expression.getSecondExpression());
            }
            if (expression.hasSecondComma()) {
                ++startPosition;
            }
            if (expression.hasSpaceAfterSecondComma()) {
                ++startPosition;
            }
            if (helper.hasThirdExpression(expression)) {
                startPosition += this.length(expression.getThirdExpression());
            }
            endPosition = startPosition;
            this.addProblem(expression, startPosition, endPosition, helper.rightParenthesisMissingKey(), new String[0]);
        }
        if (expression.hasLeftParenthesis()) {
            if (!helper.hasFirstExpression(expression)) {
                endPosition = startPosition = this.position(expression) + identifier.length() + 1;
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionMissingKey(), new String[0]);
            } else if (!helper.isFirstExpressionValid(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                endPosition = startPosition + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionInvalidKey(), new String[0]);
            } else {
                expression.getFirstExpression().accept(this);
            }
            if (helper.hasFirstExpression(expression) && !expression.hasFirstComma()) {
                startPosition = this.position(expression) + identifier.length() + 1;
                if (helper.hasFirstExpression(expression)) {
                    startPosition += helper.firstExpressionLength(expression);
                }
                endPosition = startPosition;
                this.addProblem(expression, startPosition, endPosition, helper.firstCommaMissingKey(), new String[0]);
            }
            if (expression.hasFirstComma()) {
                startPosition = this.position(expression) + identifier.length() + 1;
                if (helper.hasFirstExpression(expression)) {
                    startPosition += helper.firstExpressionLength(expression);
                }
                if (expression.hasFirstComma()) {
                    ++startPosition;
                }
                if (expression.hasSpaceAfterFirstComma()) {
                    ++startPosition;
                }
                if (!helper.hasSecondExpression(expression)) {
                    endPosition = startPosition;
                    this.addProblem(expression, startPosition, endPosition, helper.secondExpressionMissingKey(), new String[0]);
                } else if (!helper.isSecondExpressionValid(expression)) {
                    endPosition = startPosition + helper.secondExpressionLength(expression);
                    this.addProblem(expression, startPosition, endPosition, helper.secondExpressionInvalidKey(), new String[0]);
                } else {
                    expression.getSecondExpression().accept(this);
                }
            }
            if (helper.hasSecondExpression(expression) && !expression.hasSecondComma() && helper.hasThirdExpression(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                if (helper.hasFirstExpression(expression)) {
                    startPosition += this.length(expression.getFirstExpression());
                }
                if (expression.hasFirstComma()) {
                    ++startPosition;
                }
                if (expression.hasSpaceAfterFirstComma()) {
                    ++startPosition;
                }
                if (helper.hasSecondExpression(expression)) {
                    startPosition += helper.secondExpressionLength(expression);
                }
                endPosition = startPosition;
                this.addProblem(expression, startPosition, endPosition, helper.secondCommaMissingKey(), new String[0]);
            }
            if (expression.hasSecondComma()) {
                startPosition = this.position(expression) + identifier.length() + 1;
                if (helper.hasFirstExpression(expression)) {
                    startPosition += helper.firstExpressionLength(expression);
                }
                if (expression.hasFirstComma()) {
                    ++startPosition;
                }
                if (expression.hasSpaceAfterFirstComma()) {
                    ++startPosition;
                }
                if (helper.hasSecondExpression(expression)) {
                    startPosition += helper.secondExpressionLength(expression);
                }
                if (expression.hasSecondComma()) {
                    ++startPosition;
                }
                if (expression.hasSpaceAfterSecondComma()) {
                    ++startPosition;
                }
                if (!helper.hasThirdExpression(expression)) {
                    endPosition = startPosition;
                    this.addProblem(expression, startPosition, endPosition, helper.thirdExpressionMissingKey(), new String[0]);
                } else if (!helper.isThirdExpressionValid(expression)) {
                    endPosition = startPosition + helper.thirdExpressionLength(expression);
                    this.addProblem(expression, startPosition, endPosition, helper.thirdExpressionInvalidKey(), new String[0]);
                } else {
                    expression.getThirdExpression().accept(this);
                }
            }
        }
    }

    private void validateArithmeticExpression(ArithmeticExpression expression) {
        this.validateCompoundExpression(expression, expression.getArithmeticSign(), "ARITHMETIC_EXPRESSION_MISSING_LEFT_EXPRESSION", "ARITHMETIC_EXPRESSION_INVALID_LEFT_EXPRESSION", "ARITHMETIC_EXPRESSION_MISSING_RIGHT_EXPRESSION", "ARITHMETIC_EXPRESSION_INVALID_RIGHT_EXPRESSION", "arithmetic_expression", "arithmetic_term");
    }

    private void validateCollectionSeparatedByComma(Expression expression, String endsWithCommaProblemKey, String missingCommaProblemKey) {
        CollectionSeparatedByCommaValidator validator = this.collectionSeparatedByCommaValidator();
        try {
            validator.endsWithCommaProblemKey = endsWithCommaProblemKey;
            validator.wrongSeparatorProblemKey = missingCommaProblemKey;
            expression.accept(validator);
        }
        finally {
            validator.endsWithCommaProblemKey = null;
            validator.wrongSeparatorProblemKey = null;
        }
    }

    private void validateCollectionSeparatedBySpace(Expression expression, String endsWithCommaProblemKey, String hasCommaProblemKey) {
        CollectionSeparatedBySpaceValidator validator = this.collectionSeparatedBySpaceValidator();
        try {
            validator.endsWithCommaProblemKey = endsWithCommaProblemKey;
            validator.wrongSeparatorProblemKey = hasCommaProblemKey;
            expression.accept(validator);
        }
        finally {
            validator.endsWithCommaProblemKey = null;
            validator.wrongSeparatorProblemKey = null;
        }
    }

    private void validateCompoundExpression(CompoundExpression expression, String identifier, String missingLeftExpression, String invalidLeftExpression, String missingRightExpression, String invalidRightExpression, String leftExpressionQueryBNF, String rightExpressionQueryBNF) {
        int endPosition;
        int startPosition;
        if (!expression.hasLeftExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, missingLeftExpression, new String[0]);
        } else if (!this.isValid(expression.getLeftExpression(), leftExpressionQueryBNF)) {
            startPosition = this.position(expression);
            endPosition = startPosition + this.length(expression.getLeftExpression());
            this.addProblem((Expression)expression, startPosition, endPosition, invalidLeftExpression, new String[0]);
        } else {
            expression.getLeftExpression().accept(this);
        }
        if (!expression.hasRightExpression()) {
            startPosition = this.position(expression) + identifier.length();
            if (expression.hasLeftExpression()) {
                startPosition += this.length(expression.getLeftExpression()) + 1;
            }
            if (expression.hasSpaceAfterIdentifier()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, missingRightExpression, new String[0]);
        } else if (!this.isValid(expression.getRightExpression(), rightExpressionQueryBNF)) {
            startPosition = this.position(expression) + identifier.length();
            if (expression.hasLeftExpression()) {
                startPosition += this.length(expression.getLeftExpression()) + 1;
            }
            if (expression.hasSpaceAfterIdentifier()) {
                ++startPosition;
            }
            endPosition = startPosition + this.length(expression.getRightExpression());
            this.addProblem((Expression)expression, startPosition, endPosition, invalidRightExpression, new String[0]);
        } else {
            expression.getRightExpression().accept(this);
        }
    }

    private void validateIdentifier(Expression expression, String variableName, int variableLength, String reservedWordProblemKey, String invalidJavaIdentifierProblemKey) {
        if (AbstractExpression.isIdentifier(variableName)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + variableLength;
            this.addProblem(expression, startPosition, endPosition, reservedWordProblemKey, variableName);
        } else if (!this.isValidJavaIdentifier(variableName)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + variableLength;
            this.addProblem(expression, startPosition, endPosition, invalidJavaIdentifierProblemKey, variableName);
        }
    }

    private void validateInputParameters(JPQLExpression expression) {
        int positionalCount = 0;
        int namedCount = 0;
        for (InputParameter inputParameter : this.inputParameters) {
            if (inputParameter.isNamed()) {
                ++namedCount;
                continue;
            }
            if (!inputParameter.isPositional()) continue;
            ++positionalCount;
        }
        if (positionalCount > 0 && namedCount > 0) {
            for (InputParameter parameter : this.inputParameters) {
                this.addProblem(parameter, "INPUT_PARAMETER_MIXTURE");
            }
        }
    }

    private void validateLogicalExpression(LogicalExpression expression, String leftExpressionQueryBNF, String rightExpressionQueryBNF) {
        this.validateCompoundExpression(expression, expression.getIdentifier(), "LOGICAL_EXPRESSION_MISSING_LEFT_EXPRESSION", "LOGICAL_EXPRESSION_INVALID_LEFT_EXPRESSION", "LOGICAL_EXPRESSION_MISSING_RIGHT_EXPRESSION", "LOGICAL_EXPRESSION_INVALID_RIGHT_EXPRESSION", leftExpressionQueryBNF, rightExpressionQueryBNF);
    }

    private void validatePathExpression(AbstractPathExpression expression) {
        if (!expression.hasIdentificationVariable() && !expression.hasVirtualIdentificationVariable()) {
            this.addProblem(expression, "ABSTRACT_PATH_EXPRESSION_MISSING_IDENTIFICATION_VARIABLE");
        }
        if (expression.endsWithDot()) {
            this.addProblem(expression, "ABSTRACT_PATH_EXPRESSION_CANNOT_END_WITH_COMMA");
        }
    }

    private void validateSelectStatement(AbstractSelectStatement expression) {
        if (!expression.hasFromClause()) {
            int startPosition = this.position(expression) + this.length(expression.getSelectClause());
            if (expression.hasSpaceAfterSelect()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_SELECT_STATEMENT_FROM_CLAUSE_MSSING", new String[0]);
        }
    }

    private AbstractSingleEncapsulatedExpressionHelper<ValueExpression> valueExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ValueExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ValueExpression>)this.getHelper("VALUE");
        if (helper == null) {
            helper = this.buildValueExpressionHelper();
            this.helpers.put("VALUE", helper);
        }
        return helper;
    }

    @Override
    public void visit(AbsExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.absExpressionHelper());
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.allOrAnyExpressionHelper());
        if (!this.isChildOfComparisonExpession(expression)) {
            this.addProblem(expression, "ALL_OR_ANY_EXPRESSION_NOT_PART_OF_COMPARISON_EXPRESSION");
        }
    }

    @Override
    public void visit(AndExpression expression) {
        this.validateLogicalExpression(expression, "conditional_expression", "conditional_expression");
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        if (!expression.hasExpression()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression) + 1;
            this.addProblem((Expression)expression, startPosition, endPosition, "ARITHMETIC_FACTOR_MISSING_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(AvgFunction expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.avgFunctionHelper());
    }

    @Override
    public void visit(BadExpression expression) {
    }

    @Override
    public void visit(BetweenExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "BETWEEN_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        }
        if (!expression.hasLowerBoundExpression()) {
            startPosition = this.position(expression);
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            startPosition += expression.hasNot() ? "NOT BETWEEN".length() : "BETWEEN".length();
            if (expression.hasSpaceAfterBetween()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "BETWEEN_EXPRESSION_MISSING_LOWER_BOUND_EXPRESSION", new String[0]);
        }
        if (expression.hasLowerBoundExpression() && !expression.hasAnd()) {
            startPosition = this.position(expression);
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            startPosition += expression.hasNot() ? "NOT BETWEEN".length() : "BETWEEN".length();
            if (expression.hasSpaceAfterBetween()) {
                ++startPosition;
            }
            startPosition += this.length(expression.getLowerBoundExpression());
            if (expression.hasSpaceAfterLowerBound()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "BETWEEN_EXPRESSION_MISSING_AND", new String[0]);
        }
        if (expression.hasAnd() && !expression.hasUpperBoundExpression()) {
            startPosition = this.position(expression);
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            startPosition += expression.hasNot() ? "NOT BETWEEN".length() : "BETWEEN".length();
            if (expression.hasSpaceAfterBetween()) {
                ++startPosition;
            }
            if (expression.hasLowerBoundExpression()) {
                startPosition += this.length(expression.getLowerBoundExpression());
            }
            if (expression.hasSpaceAfterLowerBound()) {
                ++startPosition;
            }
            startPosition += 3;
            if (expression.hasSpaceAfterAnd()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "BETWEEN_EXPRESSION_MISSING_UPPER_BOUND_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(CaseExpression expression) {
        if (!this.isValidJPA20Identifier()) {
            this.addProblem(expression, "CASE_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            int endPosition;
            int startPosition;
            if (expression.hasWhenClauses()) {
                this.validateCollectionSeparatedBySpace(expression.getWhenClauses(), "CASE_EXPRESSION_WHEN_CLAUSES_END_WITH_COMMA", "CASE_EXPRESSION_WHEN_CLAUSES_HAS_COMMA");
            } else {
                startPosition = this.position(expression) + "CASE".length();
                if (expression.hasSpaceAfterCase()) {
                    ++startPosition;
                }
                if (expression.hasCaseOperand()) {
                    startPosition += this.length(expression.getCaseOperand());
                }
                if (expression.hasSpaceAfterCaseOperand()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "CASE_EXPRESSION_MISSING_WHEN_CLAUSE", new String[0]);
            }
            if (expression.hasWhenClauses() && !expression.hasElse()) {
                startPosition = this.position(expression) + "CASE".length();
                if (expression.hasSpaceAfterCase()) {
                    ++startPosition;
                }
                if (expression.hasCaseOperand()) {
                    startPosition += this.length(expression.getCaseOperand());
                }
                if (expression.hasSpaceAfterCaseOperand()) {
                    ++startPosition;
                }
                if (expression.hasWhenClauses()) {
                    startPosition += this.length(expression.getWhenClauses());
                }
                if (expression.hasSpaceAfterWhenClauses()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "CASE_EXPRESSION_MISSING_ELSE_IDENTIFIER", new String[0]);
            }
            if (expression.hasWhenClauses() && expression.hasElse() && !expression.hasElseExpression()) {
                startPosition = this.position(expression) + "CASE".length();
                if (expression.hasSpaceAfterCase()) {
                    ++startPosition;
                }
                if (expression.hasCaseOperand()) {
                    startPosition += this.length(expression.getCaseOperand());
                }
                if (expression.hasSpaceAfterCaseOperand()) {
                    ++startPosition;
                }
                if (expression.hasWhenClauses()) {
                    startPosition += this.length(expression.getWhenClauses());
                }
                if (expression.hasSpaceAfterWhenClauses()) {
                    ++startPosition;
                }
                if (expression.hasElse()) {
                    startPosition += "ELSE".length();
                }
                if (expression.hasSpaceAfterElse()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "CASE_EXPRESSION_MISSING_ELSE_EXPRESSION", new String[0]);
            }
            if (expression.hasWhenClauses() && expression.hasElseExpression() && !expression.hasEnd()) {
                startPosition = this.position(expression) + "CASE".length();
                if (expression.hasSpaceAfterCase()) {
                    ++startPosition;
                }
                if (expression.hasCaseOperand()) {
                    startPosition += this.length(expression.getCaseOperand());
                }
                if (expression.hasSpaceAfterCaseOperand()) {
                    ++startPosition;
                }
                if (expression.hasWhenClauses()) {
                    startPosition += this.length(expression.getWhenClauses());
                }
                if (expression.hasSpaceAfterWhenClauses()) {
                    ++startPosition;
                }
                if (expression.hasElse()) {
                    startPosition += "ELSE".length();
                }
                if (expression.hasSpaceAfterElse()) {
                    ++startPosition;
                }
                startPosition += this.length(expression.getElseExpression());
                if (expression.hasSpaceAfterElseExpression()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "CASE_EXPRESSION_MISSING_END_IDENTIFIER", new String[0]);
            }
            super.visit(expression);
        }
    }

    @Override
    public void visit(CoalesceExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.coalesceExpressionHelper());
        } else {
            this.addProblem(expression, "COALESCE_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(CollectionExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        if (this.isOwnedByFromClause(expression)) {
            int endPosition;
            int startPosition;
            if (!expression.hasLeftParenthesis()) {
                endPosition = startPosition = this.position(expression) + 2;
                this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_LEFT_PARENTHESIS", new String[0]);
            } else if (!expression.hasCollectionValuedPathExpression()) {
                endPosition = startPosition = this.position(expression) + 3;
                this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_COLLECTION_VALUED_PATH_EXPRESSION", new String[0]);
            } else if (!expression.hasRightParenthesis()) {
                startPosition = this.position(expression) + 2;
                if (expression.hasLeftParenthesis()) {
                    ++startPosition;
                }
                endPosition = startPosition += this.length(expression.getCollectionValuedPathExpression());
                this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_RIGHT_PARENTHESIS", new String[0]);
            }
            if (expression.hasRightParenthesis() && !expression.hasIdentificationVariable()) {
                startPosition = this.position(expression) + 4;
                startPosition += this.length(expression.getCollectionValuedPathExpression());
                if (expression.hasSpaceAfterRightParenthesis()) {
                    ++startPosition;
                }
                if (expression.hasAs()) {
                    startPosition += 2;
                }
                if (expression.hasSpaceAfterAs()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasEntityExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_EXPRESSION_MISSING_ENTITY_EXPRESSION", new String[0]);
        }
        if (!expression.hasCollectionValuedPathExpression()) {
            startPosition = this.position(expression);
            if (expression.hasEntityExpression()) {
                startPosition += this.length(expression.getEntityExpression()) + 1;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            startPosition += "MEMBER".length();
            if (expression.hasSpaceAfterMember()) {
                ++startPosition;
            }
            if (expression.hasOf()) {
                startPosition += 2;
            }
            if (expression.hasSpaceAfterOf()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_MEMBER_EXPRESSION_MISSING_COLLECTION_VALUED_PATH_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.validatePathExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasLeftExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "COMPARISON_EXPRESSION_MISSING_LEFT_EXPRESSION", new String[0]);
        }
        if (!expression.hasRightExpression()) {
            startPosition = this.position(expression);
            if (expression.hasLeftExpression()) {
                startPosition += 1 + this.length(expression.getLeftExpression());
            }
            startPosition += expression.getComparisonOperator().length();
            if (expression.hasSpaceAfterIdentifier()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "COMPARISON_EXPRESSION_MISSING_RIGHT_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.concatExpressionHelper());
        if (expression.hasLeftParenthesis() && expression.hasExpression()) {
            CollectionExpression collectionExpression = this.collectionExpression(expression.getExpression());
            if (collectionExpression == null) {
                this.addProblem(expression, "CONCAT_EXPRESSION_MISSING_EXPRESSION");
            } else {
                Expression[] expressionArray = collectionExpression.getChildren();
                int n = expressionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression child = expressionArray[n2];
                    if (!this.isValid(child, "string_primary")) {
                        this.addProblem(child, "CONCAT_EXPRESSION_INVALID_EXPRESSION", child.toParsedText());
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void visit(ConstructorExpression expression) {
        int endPosition;
        int startPosition;
        if (expression.getClassName().length() == 0) {
            int startPosition2 = this.position(expression) + 3;
            if (expression.hasSpaceAfterNew()) {
                ++startPosition2;
            }
            int endPosition2 = startPosition2;
            this.addProblem((Expression)expression, startPosition2, endPosition2, "CONSTRUCTOR_EXPRESSION_MISSING_CONSTRUCTOR_NAME", new String[0]);
        }
        if (!expression.hasLeftParenthesis()) {
            String className = expression.getClassName();
            startPosition = this.position(expression) + 3;
            if (expression.hasSpaceAfterNew()) {
                ++startPosition;
            }
            if (className != null) {
                startPosition += className.length();
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_MISSING_LEFT_PARENTHESIS", new String[0]);
        }
        if (expression.hasLeftParenthesis()) {
            if (!expression.hasConstructorItems()) {
                String className = expression.getClassName();
                startPosition = this.position(expression) + 4;
                if (expression.hasSpaceAfterNew()) {
                    ++startPosition;
                }
                if (className != null) {
                    startPosition += className.length();
                }
                endPosition = startPosition += this.length(expression.getConstructorItems());
                this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_MISSING_CONSTRUCTOR_ITEM", new String[0]);
            } else {
                this.validateCollectionSeparatedByComma(expression.getConstructorItems(), "CONSTRUCTOR_EXPRESSION_CONSTRUCTOR_ITEM_ENDS_WITH_COMMA", "CONSTRUCTOR_EXPRESSION_CONSTRUCTOR_ITEM_IS_MISSING_COMMA");
            }
        }
        if (expression.hasLeftParenthesis() && expression.hasConstructorItems() && !expression.hasRightParenthesis()) {
            String className = expression.getClassName();
            startPosition = this.position(expression) + 4;
            if (expression.hasSpaceAfterNew()) {
                ++startPosition;
            }
            if (className != null) {
                startPosition += className.length();
            }
            endPosition = startPosition += this.length(expression.getConstructorItems());
            this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(CountFunction expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.countFunctionHelper());
    }

    @Override
    public void visit(DateTime expression) {
        String dateTime = expression.getText();
        if (dateTime.startsWith("{")) {
            int endPosition;
            int startPosition;
            int length = dateTime.length();
            if (!(dateTime.startsWith("{d ") || dateTime.startsWith("{t ") || dateTime.startsWith("{ts "))) {
                endPosition = startPosition = this.position(expression) + 1;
                int index = 1;
                while (index < length) {
                    if (Character.isWhitespace(dateTime.charAt(index))) break;
                    ++endPosition;
                    ++index;
                }
                this.addProblem((Expression)expression, startPosition, endPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_INVALID_SPECIFICATION", new String[0]);
            } else if (!(dateTime.startsWith("{d '") || dateTime.startsWith("{t '") || dateTime.startsWith("{ts '"))) {
                startPosition = this.position(expression) + 1;
                int index = 1;
                while (index < length) {
                    ++startPosition;
                    if (Character.isWhitespace(dateTime.charAt(index))) break;
                    ++index;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_OPEN_QUOTE", new String[0]);
            }
            if (length > 1 && dateTime.charAt(length - (dateTime.endsWith("}") ? 2 : 1)) != '\'') {
                startPosition = this.position(expression) + length;
                if (dateTime.endsWith("}")) {
                    --startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_CLOSE_QUOTE", new String[0]);
            } else if (!dateTime.endsWith("}")) {
                endPosition = startPosition = this.position(expression) + length;
                this.addProblem((Expression)expression, startPosition, endPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_RIGHT_CURLY_BRACE", new String[0]);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(DeleteClause expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasFrom()) {
            startPosition = "DELETE".length();
            if (expression.hasSpaceAfterDelete()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "DELETE_CLAUSE_FROM_MISSING", new String[0]);
        } else if (!expression.hasRangeVariableDeclaration()) {
            endPosition = startPosition = "DELETE FROM".length() + 1;
            this.addProblem((Expression)expression, startPosition, endPosition, "DELETE_CLAUSE_RANGE_VARIABLE_DECLARATION_MISSING", new String[0]);
        }
        CollectionExpression collectionExpression = this.collectionExpression(expression.getRangeVariableDeclaration());
        if (collectionExpression != null) {
            Expression firstChild = collectionExpression.getChild(0);
            int startPosition2 = this.position(firstChild) + this.length(firstChild);
            int endPosition2 = this.position(collectionExpression) + this.length(collectionExpression);
            boolean malformed = false;
            int index = collectionExpression.childrenSize() - 1;
            while (--index >= 0) {
                if (collectionExpression.hasComma(index)) continue;
                malformed = true;
            }
            if (collectionExpression.toParsedText().endsWith(" ")) {
                --endPosition2;
            }
            this.addProblem((Expression)expression, startPosition2, endPosition2, malformed ? "DELETE_CLAUSE_RANGE_VARIABLE_DECLARATION_MALFORMED" : "DELETE_CLAUSE_MULTIPLE_RANGE_VARIABLE_DECLARATION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(DeleteStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "EMPTY_COLLECTION_COMPARISON_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(EntryExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.entryExpressionHelper());
        } else {
            this.addProblem(expression, "ENTRY_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.existsExpressionHelper());
    }

    @Override
    public void visit(FromClause expression) {
        this.validateAbstractFromClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(FuncExpression expression) {
        if (this.isEclipseLinkPlatform()) {
            String functionName;
            this.validateAbstractSingleEncapsulatedExpression(expression, this.funcExpressionHelper());
            if (expression.hasLeftParenthesis() && ExpressionTools.stringIsEmpty(functionName = expression.getFunctionName())) {
                int startPosition = this.position(expression) + "FUNC".length();
                if (expression.hasLeftParenthesis()) {
                    ++startPosition;
                }
                int endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "FUNC_EXPRESSION_MISSING_FUNCTION_NAME", new String[0]);
            }
            super.visit(expression);
        } else {
            this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
        }
    }

    @Override
    public void visit(GroupByClause expression) {
        if (!expression.hasGroupByItems()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression.getGroupByItems());
            this.addProblem((Expression)expression, startPosition, endPosition, "GROUP_BY_CLAUSE_GROUP_BY_ITEM_MISSING", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getGroupByItems(), "GROUP_BY_CLAUSE_GROUP_BY_ITEM_ENDS_WITH_COMMA", "GROUP_BY_CLAUSE_GROUP_BY_ITEM_IS_MISSING_COMMA");
            super.visit(expression);
        }
    }

    @Override
    public void visit(HavingClause expression) {
        this.validateAbstractConditionalClause(expression, "HAVING_CLAUSE_MISSING_CONDITIONAL_EXPRESSION", "HAVING_CLAUSE_INVALID_CONDITIONAL_EXPRESSION");
        super.visit(expression);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        if (!expression.isVirtual()) {
            String variable = expression.getText();
            this.validateIdentifier(expression, variable, variable.length(), "IDENTIFICATION_VARIABLE_INVALID_RESERVED_WORD", "IDENTIFICATION_VARIABLE_INVALID_JAVA_IDENTIFIER");
        }
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        if (!expression.hasRangeVariableDeclaration()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "IDENTIFICATION_VARIABLE_DECLARATION_MISSING_RANGE_VARIABLE_DECLARATION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(IndexExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.indexExpressionHelper());
        } else {
            this.addProblem(expression, "INDEX_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(InExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "IN_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            Expression pathExpression = expression.getExpression();
            if (!this.isValid(pathExpression, "state_field_path_expression") && !this.isValid(pathExpression, "type_discriminator")) {
                int startPosition2 = this.position(expression);
                int endPosition2 = startPosition2 + this.length(expression.getExpression());
                this.addProblem((Expression)expression, startPosition2, endPosition2, "IN_EXPRESSION_MALFORMED_EXPRESSION", new String[0]);
            }
        }
        if (!expression.hasLeftParenthesis()) {
            startPosition = this.position(expression) + 2;
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "IN_EXPRESSION_MISSING_LEFT_PARENTHESIS", new String[0]);
        } else if (!expression.hasInItems()) {
            startPosition = this.position(expression) + 3;
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "IN_EXPRESSION_MISSING_IN_ITEMS", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getInItems(), "IN_EXPRESSION_IN_ITEM_ENDS_WITH_COMMA", "IN_EXPRESSION_IN_ITEM_IS_MISSING_COMMA");
        }
        if (expression.hasLeftParenthesis() && expression.hasInItems() && !expression.hasRightParenthesis()) {
            startPosition = this.position(expression) + 3;
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            endPosition = startPosition += this.length(expression.getInItems());
            this.addProblem((Expression)expression, startPosition, endPosition, "IN_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(InputParameter expression) {
        int startPosition;
        this.inputParameters.add(expression);
        String parameter = expression.getParameter();
        if (parameter.length() == 1) {
            startPosition = this.position(expression);
            int endPosition = startPosition + 1;
            this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_MISSING_PARAMETER", new String[0]);
        } else if (expression.isNamed()) {
            if (!this.isValidJavaIdentifier(parameter.substring(1))) {
                startPosition = this.position(expression);
                int endPosition = startPosition + parameter.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_JAVA_IDENTIFIER", new String[0]);
            }
        } else {
            Integer value;
            boolean valid = true;
            int index = parameter.length();
            while (--index > 0) {
                char character = parameter.charAt(index);
                if (Character.isDigit(character)) continue;
                int startPosition2 = this.position(expression);
                int endPosition = startPosition2 + parameter.length();
                this.addProblem((Expression)expression, startPosition2, endPosition, "INPUT_PARAMETER_NOT_INTEGER", new String[0]);
                valid = false;
                break;
            }
            if (valid && (value = Integer.valueOf(parameter.substring(1))) < 1) {
                int startPosition3 = this.position(expression);
                int endPosition = startPosition3 + parameter.length();
                this.addProblem((Expression)expression, startPosition3, endPosition, "INPUT_PARAMETER_SMALLER_THAN_ONE", new String[0]);
            }
        }
        AbstractValidator.OwningClauseVisitor visitor = this.owningClauseVisitor();
        expression.accept(visitor);
        try {
            if (visitor.whereClause == null && visitor.havingClause == null && visitor.orderByClause == null && visitor.updateClause == null && visitor.deleteClause == null && !this.isInFuncExpressionInSelectClause(visitor, expression)) {
                int startPosition4 = this.position(expression);
                int endPosition = startPosition4 + parameter.length();
                this.addProblem((Expression)expression, startPosition4, endPosition, "INPUT_PARAMETER_WRONG_CLAUSE_DECLARATION", new String[0]);
            }
        }
        finally {
            visitor.dispose();
        }
    }

    @Override
    public void visit(Join expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasJoinAssociationPath()) {
            startPosition = this.position(expression) + expression.getIdentifier().length();
            if (expression.hasSpaceAfterJoin()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_MISSING_JOIN_ASSOCIATION_PATH", new String[0]);
        }
        if (expression.hasJoinAssociationPath() && !expression.hasIdentificationVariable()) {
            startPosition = this.position(expression) + expression.getIdentifier().length();
            if (expression.hasSpaceAfterJoin()) {
                ++startPosition;
            }
            startPosition += this.length(expression.getJoinAssociationPath());
            if (expression.hasSpaceAfterJoinAssociation()) {
                ++startPosition;
            }
            if (expression.hasAs()) {
                startPosition += 2;
            }
            if (expression.hasSpaceAfterAs()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(JoinFetch expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasJoinAssociationPath()) {
            startPosition = this.position(expression) + expression.getIdentifier().toString().length();
            if (expression.hasSpaceAfterFetch()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_FETCH_MISSING_JOIN_ASSOCIATION_PATH", new String[0]);
        }
        if (this.isOwnedBySubFromClause(expression)) {
            startPosition = this.position(expression);
            endPosition = startPosition + this.length(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_FETCH_WRONG_CLAUSE_DECLARATION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (!expression.hasQueryStatement()) {
            int startPosition = 0;
            int endPosition = this.getQueryExpression().length();
            this.addProblem((Expression)expression, startPosition, endPosition, "JPQL_EXPRESSION_INVALID_QUERY", new String[0]);
        } else if (expression.hasUnknownEndingStatement()) {
            int startPosition = this.length(expression.getQueryStatement());
            int endPosition = startPosition + this.length(expression.getUnknownEndingStatement());
            this.addProblem((Expression)expression, startPosition, endPosition, "JPQL_EXPRESSION_UNKNOWN_ENDING", new String[0]);
        }
        super.visit(expression);
        this.validateInputParameters(expression);
    }

    @Override
    public void visit(KeyExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.keyExpressionHelper());
        } else {
            this.addProblem(expression, "KEY_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(KeywordExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(LengthExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.lengthExpressionHelper());
    }

    @Override
    public void visit(LikeExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasStringExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "LIKE_EXPRESSION_MISSING_STRING_EXPRESSION", new String[0]);
        }
        if (!expression.hasPatternValue()) {
            startPosition = this.position(expression) + this.length(expression.getStringExpression()) + 4;
            if (expression.hasSpaceAfterStringExpression()) {
                ++startPosition;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            if (expression.hasSpaceAfterLike()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "LIKE_EXPRESSION_MISSING_PATTERN_VALUE", new String[0]);
        }
        if (expression.hasEscape()) {
            startPosition = this.position(expression) + this.length(expression.getStringExpression()) + 4;
            if (expression.hasSpaceAfterStringExpression()) {
                ++startPosition;
            }
            if (expression.hasNot()) {
                startPosition += 4;
            }
            if (expression.hasSpaceAfterLike()) {
                ++startPosition;
            }
            startPosition += this.length(expression.getPatternValue());
            if (expression.hasSpaceAfterPatternValue()) {
                ++startPosition;
            }
            startPosition += "ESCAPE".length();
            if (expression.hasSpaceAfterEscape()) {
                ++startPosition;
            }
            if (expression.hasEscapeCharacter()) {
                Expression escapeCharacter = expression.getEscapeCharacter();
                int endPosition2 = startPosition + this.length(escapeCharacter);
                String character = this.queryContext.literal(escapeCharacter, LiteralType.STRING_LITERAL);
                if (character.length() > 0) {
                    if ((character = ExpressionTools.unquote(character)).length() != 1) {
                        this.addProblem((Expression)expression, startPosition, endPosition2, "LIKE_EXPRESSION_INVALID_ESCAPE_CHARACTER", escapeCharacter.toParsedText());
                    }
                } else {
                    character = this.queryContext.literal(escapeCharacter, LiteralType.INPUT_PARAMETER);
                    if (character.length() == 0) {
                        this.addProblem((Expression)expression, startPosition, endPosition2, "LIKE_EXPRESSION_INVALID_ESCAPE_CHARACTER", escapeCharacter.toParsedText());
                    }
                }
            } else {
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "LIKE_EXPRESSION_MISSING_ESCAPE_CHARACTER", new String[0]);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.validateAbstractTripleEncapsulatedExpression(expression, this.locateExpressionHelper());
    }

    @Override
    public void visit(LowerExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.lowerExpressionHelper());
    }

    @Override
    public void visit(MaxFunction expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.maxFunctionHelper());
    }

    @Override
    public void visit(MinFunction expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.minFunctionHelper());
    }

    @Override
    public void visit(ModExpression expression) {
        this.validateAbstractDoubleEncapsulatedExpression(expression, this.modExpressionHelper());
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression) + 3;
            if (expression.hasSpaceAfterNot()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "NOT_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "NULL_COMPARISON_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(NullExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NullIfExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractDoubleEncapsulatedExpression(expression, this.nullIfExpressionHelper());
        } else {
            this.addProblem(expression, "COALESCE_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(NumericLiteral expression) {
        String text = expression.getText();
        if (!this.isNumericLiteral(text)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + text.length();
            this.addProblem((Expression)expression, startPosition, endPosition, "NUMERIC_LITERAL_INVALID", text);
        }
        super.visit(expression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.objectExpressionHelper());
    }

    @Override
    public void visit(OrderByClause expression) {
        if (!expression.hasOrderByItems()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression.getOrderByItems());
            this.addProblem((Expression)expression, startPosition, endPosition, "ORDER_BY_CLAUSE_ORDER_BY_ITEM_MISSING", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getOrderByItems(), "ORDER_BY_CLAUSE_ORDER_BY_ITEM_ENDS_WITH_COMMA", "ORDER_BY_CLAUSE_ORDER_BY_ITEM_IS_MISSING_COMMA");
        }
        super.visit(expression);
    }

    @Override
    public void visit(OrderByItem expression) {
        if (!expression.hasExpression()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "ORDER_BY_ITEM_MISSING_STATE_FIELD_PATH_EXPRESSION", new String[0]);
        } else if (this.isEclipseLinkPlatform() && !this.isValid(expression.getExpression(), "internal_orderby_item")) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + this.length(expression.getExpression());
            this.addProblem((Expression)expression, startPosition, endPosition, "ORDER_BY_ITEM_INVALID_PATH", new String[0]);
        } else if (this.isJavaPlatform()) {
            AbstractValidator.ExpressionValidator validator = this.buildExpressionValidator("state_field_path_expression", "identification_variable", "result_variable");
            expression.getExpression().accept(validator);
            if (!validator.valid) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression.getExpression());
                this.addProblem((Expression)expression, startPosition, endPosition, "ORDER_BY_ITEM_INVALID_PATH", new String[0]);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(OrExpression expression) {
        this.validateLogicalExpression(expression, "conditional_expression", "conditional_expression");
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasAbstractSchemaName()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "RANGE_VARIABLE_DECLARATION_MISSING_ABSTRACT_SCHEMA_NAME", new String[0]);
        }
        if (!expression.hasIdentificationVariable() && !expression.hasVirtualIdentificationVariable()) {
            startPosition = this.position(expression);
            if (expression.hasAbstractSchemaName()) {
                startPosition += this.length(expression.getAbstractSchemaName());
            }
            if (expression.hasSpaceAfterAbstractSchemaName()) {
                ++startPosition;
            }
            if (expression.hasAs()) {
                startPosition += 2;
            }
            if (expression.hasSpaceAfterAs()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "RANGE_VARIABLE_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(ResultVariable expression) {
        if (this.isValidJPA20Identifier()) {
            int endPosition;
            int startPosition;
            if (!expression.hasSelectExpression()) {
                endPosition = startPosition = this.position(expression);
                this.addProblem((Expression)expression, startPosition, endPosition, "RESULT_VARIABLE_MISSING_SELECT_EXPRESSION", new String[0]);
            }
            if (!expression.hasResultVariable()) {
                startPosition = this.position(expression) + 2;
                if (expression.hasSelectExpression()) {
                    startPosition += this.length(expression.getSelectExpression()) + 1;
                }
                if (expression.hasSpaceAfterAs()) {
                    ++startPosition;
                }
                endPosition = startPosition;
                this.addProblem((Expression)expression, startPosition, endPosition, "RESULT_VARIABLE_MISSING_RESULT_VARIABLE", new String[0]);
            }
            super.visit(expression);
        } else {
            this.addProblem(expression, "RESULT_VARIABLE_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(SelectClause expression) {
        if (!expression.hasSelectExpression()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression) + this.length(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_SELECT_CLAUSE_SELECT_MISSING_EXPRESSION", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getSelectExpression(), "ABSTRACT_SELECT_CLAUSE_SELECT_EXPRESSION_ENDS_WITH_COMMA", "ABSTRACT_SELECT_CLAUSE_SELECT_EXPRESSION_IS_MISSING_COMMA");
            super.visit(expression);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        this.validateSelectStatement(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.validateAbstractFromClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        if (expression.hasSelectExpression()) {
            Expression selectExpression = expression.getSelectExpression();
            if (this.collectionExpression(selectExpression) != null) {
                this.addProblem(selectExpression, "SIMPLE_SELECT_CLAUSE_NOT_SINGLE_EXPRESSION", selectExpression.toParsedText());
            }
            super.visit(expression);
        } else {
            int startPosition;
            int endPosition = startPosition = this.position(expression) + this.length(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_SELECT_CLAUSE_SELECT_MISSING_EXPRESSION", new String[0]);
        }
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        if (this.isOwnedByConditionalClause(expression)) {
            this.validateSelectStatement(expression);
            this.queryContext.newSubqueryContext(expression);
            try {
                super.visit(expression);
            }
            finally {
                this.queryContext.disposeSubqueryContext();
            }
        } else {
            this.addProblem(expression, "SIMPLE_SELECT_STATEMENT_INVALID_LOCATION");
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.sizeExpressionHelper());
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.sqrtExpressionHelper());
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.validatePathExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        if (!expression.hasCloseQuote()) {
            this.addProblem(expression, "STRING_LITERAL_MISSING_CLOSING_QUOTE");
        }
    }

    @Override
    public void visit(SubExpression expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasExpression()) {
            startPosition = this.position(expression);
            endPosition = startPosition + 1;
            if (expression.hasRightParenthesis()) {
                ++endPosition;
            }
            this.addProblem((Expression)expression, startPosition, endPosition, "SUB_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        }
        if (!expression.hasRightParenthesis()) {
            startPosition = this.position(expression);
            if (expression.hasExpression()) {
                startPosition += this.length(expression.getExpression()) + 1;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "SUB_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.validateAbstractTripleEncapsulatedExpression(expression, this.substringExpressionHelper());
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.sumFunctionHelper());
    }

    @Override
    public void visit(TreatExpression expression) {
        if (this.isEclipseLinkPlatform()) {
            super.visit(expression);
        } else {
            this.addProblem(expression, "FUNC_EXPRESSION_INVALID_JPA_PLATFORM");
        }
    }

    @Override
    public void visit(TrimExpression expression) {
        Expression trimCharacter;
        String inputParameter;
        int endPosition;
        int startPosition;
        this.validateAbstractSingleEncapsulatedExpression(expression, this.trimExpressionHelper());
        if (!expression.hasExpression()) {
            startPosition = this.position(expression) + 4;
            if (expression.hasLeftParenthesis()) {
                ++startPosition;
            }
            if (expression.hasSpecification()) {
                startPosition += expression.getSpecification().name().length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++startPosition;
            }
            if (expression.hasTrimCharacter()) {
                startPosition += this.length(expression.getTrimCharacter());
            }
            if (expression.hasSpaceAfterTrimCharacter()) {
                ++startPosition;
            }
            if (expression.hasFrom()) {
                startPosition += 4;
            }
            if (expression.hasSpaceAfterFrom()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "TRIM_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else if (!this.isValid(expression.getExpression(), "string_primary")) {
            startPosition = this.position(expression) + 4;
            if (expression.hasLeftParenthesis()) {
                ++startPosition;
            }
            if (expression.hasSpecification()) {
                startPosition += expression.getSpecification().name().length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++startPosition;
            }
            if (expression.hasTrimCharacter()) {
                startPosition += this.length(expression.getTrimCharacter());
            }
            if (expression.hasSpaceAfterTrimCharacter()) {
                ++startPosition;
            }
            if (expression.hasFrom()) {
                startPosition += 4;
            }
            if (expression.hasSpaceAfterFrom()) {
                ++startPosition;
            }
            endPosition = startPosition + this.length(expression.getExpression());
            this.addProblem((Expression)expression, startPosition, endPosition, "TRIM_EXPRESSION_INVALID_EXPRESSION", new String[0]);
        }
        if (expression.hasTrimCharacter() && ExpressionTools.stringIsEmpty(inputParameter = this.queryContext.literal(trimCharacter = expression.getTrimCharacter(), LiteralType.INPUT_PARAMETER))) {
            String stringLiteral = this.queryContext.literal(trimCharacter, LiteralType.STRING_LITERAL);
            int startPosition2 = this.position(expression) + 4;
            if (expression.hasLeftParenthesis()) {
                ++startPosition2;
            }
            if (expression.hasSpecification()) {
                startPosition2 += expression.getSpecification().name().length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++startPosition2;
            }
            int endPosition2 = startPosition2 + this.length(expression.getTrimCharacter());
            if (ExpressionTools.stringIsEmpty(stringLiteral)) {
                this.addProblem(trimCharacter, startPosition2, endPosition2, "TRIM_EXPRESSION_INVALID_TRIM_CHARACTER", new String[0]);
            } else if ((stringLiteral = stringLiteral.substring(1, stringLiteral.length() - (stringLiteral.endsWith("'") ? 1 : 0))).length() != 1) {
                this.addProblem(trimCharacter, startPosition2, endPosition2, "TRIM_EXPRESSION_NOT_SINGLE_STRING_LITERAL", new String[0]);
            }
        }
    }

    @Override
    public void visit(TypeExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.typeExpressionHelper());
        } else {
            this.addProblem(expression, "TYPE_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(UnknownExpression expression) {
    }

    @Override
    public void visit(UpdateClause expression) {
        if (!expression.hasRangeVariableDeclaration()) {
            int startPosition = this.position(expression) + "UPDATE".length();
            if (expression.hasSpaceAfterUpdate()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_CLAUSE_MISSING_RANGE_VARIABLE_DECLARATION", new String[0]);
        } else if (!expression.hasSet()) {
            int startPosition = this.position(expression) + "UPDATE".length();
            if (expression.hasSpaceAfterUpdate()) {
                ++startPosition;
            }
            if (expression.hasRangeVariableDeclaration()) {
                startPosition += this.length(expression.getRangeVariableDeclaration());
            }
            if (expression.hasSpaceAfterRangeVariableDeclaration()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_CLAUSE_MISSING_SET", new String[0]);
        } else if (!expression.hasUpdateItems()) {
            int startPosition = this.position(expression) + "UPDATE".length();
            if (expression.hasSpaceAfterUpdate()) {
                ++startPosition;
            }
            if (expression.hasRangeVariableDeclaration()) {
                startPosition += this.length(expression.getRangeVariableDeclaration());
            }
            if (expression.hasSpaceAfterRangeVariableDeclaration()) {
                ++startPosition;
            }
            startPosition += 3;
            if (expression.hasSpaceAfterSet()) {
                ++startPosition;
            }
            int endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_CLAUSE_MISSING_UPDATE_ITEMS", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getUpdateItems(), "UPDATE_CLAUSE_UPDATE_ITEM_ENDS_WITH_COMMA", "UPDATE_CLAUSE_UPDATE_ITEM_IS_MISSING_COMMA");
        }
        super.visit(expression);
    }

    @Override
    public void visit(UpdateItem expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasStateFieldPathExpression()) {
            endPosition = startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_ITEM_MISSING_STATE_FIELD_PATH_EXPRESSION", new String[0]);
        }
        if (expression.hasStateFieldPathExpression() && !expression.hasEqualSign()) {
            startPosition = this.position(expression) + this.length(expression.getStateFieldPathExpression());
            if (expression.hasSpaceAfterStateFieldPathExpression()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_ITEM_MISSING_EQUAL_SIGN", new String[0]);
        }
        if (expression.hasEqualSign() && !expression.hasNewValue()) {
            startPosition = this.position(expression) + 1;
            if (expression.hasStateFieldPathExpression()) {
                startPosition += this.length(expression.getStateFieldPathExpression());
            }
            if (expression.hasSpaceAfterStateFieldPathExpression()) {
                ++startPosition;
            }
            if (expression.hasSpaceAfterEqualSign()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "UPDATE_ITEM_MISSING_NEW_VALUE", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(UpdateStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.upperExpressionHelper());
    }

    @Override
    public void visit(ValueExpression expression) {
        if (this.isValidJPA20Identifier()) {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.valueExpressionHelper());
        } else {
            this.addProblem(expression, "VALUE_EXPRESSION_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(WhenClause expression) {
        int endPosition;
        int startPosition;
        if (!expression.hasWhenExpression()) {
            startPosition = this.position(expression) + "THEN".length();
            if (expression.hasSpaceAfterWhen()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "WHEN_CLAUSE_MISSING_WHEN_EXPRESSION", new String[0]);
        }
        if (expression.hasWhenExpression() && !expression.hasThen()) {
            startPosition = this.position(expression) + "THEN".length();
            if (expression.hasSpaceAfterWhen()) {
                ++startPosition;
            }
            startPosition += this.length(expression.getWhenExpression());
            if (expression.hasSpaceAfterWhenExpression()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "WHEN_CLAUSE_MISSING_THEN_IDENTIFIER", new String[0]);
        }
        if (expression.hasThen() && !expression.hasThenExpression()) {
            startPosition = this.position(expression) + "THEN".length();
            if (expression.hasSpaceAfterWhen()) {
                ++startPosition;
            }
            startPosition += this.length(expression.getWhenExpression());
            if (expression.hasSpaceAfterWhenExpression()) {
                ++startPosition;
            }
            startPosition += "THEN".length();
            if (expression.hasSpaceAfterThen()) {
                ++startPosition;
            }
            endPosition = startPosition;
            this.addProblem((Expression)expression, startPosition, endPosition, "WHEN_CLAUSE_MISSING_THEN_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(WhereClause expression) {
        this.validateAbstractConditionalClause(expression, "WHERE_CLAUSE_MISSING_CONDITIONAL_EXPRESSION", "WHERE_CLAUSE_INVALID_CONDITIONAL_EXPRESSION");
        super.visit(expression);
    }

    private abstract class AbstractCollectionValidator
    extends AbstractExpressionVisitor {
        String endsWithCommaProblemKey;
        boolean validateOnly;
        String wrongSeparatorProblemKey;

        private AbstractCollectionValidator() {
        }

        private void validateEndsWithComma(CollectionExpression expression) {
            if (expression.endsWithComma()) {
                int lastIndex = expression.childrenSize() - 1;
                int length = expression.toParsedText(lastIndex).length();
                int startPosition = GrammarValidator.this.position(expression) + length - 1;
                if (expression.endsWithSpace()) {
                    --startPosition;
                }
                int endPosition = startPosition + 1;
                if (!this.validateOnly) {
                    GrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, this.endsWithCommaProblemKey, new String[0]);
                }
            }
        }

        private void validateSeparation(CollectionExpression expression) {
            int index = 0;
            int count = expression.childrenSize();
            while (index + 1 < count) {
                Expression expression1 = expression.getChild(index);
                if (GrammarValidator.this.isNull(expression1)) {
                    int startPosition;
                    int endPosition = startPosition = GrammarValidator.this.position(expression1);
                    GrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_EXPRESSION_MISSING_EXPRESSION", String.valueOf(index + 1));
                }
                if (!this.validateSeparator(expression, index)) {
                    Expression expression2 = expression.getChild(index + 1);
                    int startPosition = GrammarValidator.this.position(expression1) + GrammarValidator.this.length(expression1);
                    int endPosition = GrammarValidator.this.position(expression2);
                    if (!expression.hasSpace(index)) {
                        --startPosition;
                    }
                    if (!this.validateOnly) {
                        GrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, this.wrongSeparatorProblemKey, expression1.toParsedText(), expression2.toParsedText());
                    }
                }
                ++index;
            }
        }

        abstract boolean validateSeparator(CollectionExpression var1, int var2);

        public void visit(CollectionExpression expression) {
            this.validateSeparation(expression);
            this.validateEndsWithComma(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractDoubleEncapsulatedExpressionHelper<T extends AbstractDoubleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        private AbstractDoubleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        abstract String firstExpressionInvalidKey();

        public int firstExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractDoubleEncapsulatedExpression)expression).getFirstExpression());
        }

        abstract String firstExpressionMissingKey();

        public boolean hasFirstExpression(T expression) {
            return ((AbstractDoubleEncapsulatedExpression)expression).hasFirstExpression();
        }

        public boolean hasSecondExpression(T expression) {
            return ((AbstractDoubleEncapsulatedExpression)expression).hasSecondExpression();
        }

        abstract boolean isFirstExpressionValid(T var1);

        abstract boolean isSecondExpressionValid(T var1);

        abstract String missingCommaKey();

        abstract String secondExpressionInvalidKey();

        public int secondExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractDoubleEncapsulatedExpression)expression).getSecondExpression());
        }

        abstract String secondExpressionMissingKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AbstractEncapsulatedExpressionHelper<T extends AbstractEncapsulatedExpression> {
        public String[] arguments(T var1);

        public String identifier(T var1);

        public String leftParenthesisMissingKey();

        public String rightParenthesisMissingKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractSingleEncapsulatedExpressionHelper<T extends AbstractSingleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        private AbstractSingleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        public int encapsulatedExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractSingleEncapsulatedExpression)expression).getExpression());
        }

        abstract String expressionInvalidKey();

        abstract String expressionMissingKey();

        public boolean hasExpression(T expression) {
            return ((AbstractSingleEncapsulatedExpression)expression).hasExpression();
        }

        @Override
        public final String identifier(T expression) {
            return ((AbstractEncapsulatedExpression)expression).getIdentifier();
        }

        public boolean isValidExpression(T expression) {
            return GrammarValidator.this.isValid(((AbstractSingleEncapsulatedExpression)expression).getExpression(), ((AbstractSingleEncapsulatedExpression)expression).encapsulatedExpressionBNF());
        }

        public int lengthBeforeEncapsulatedExpression(T expression) {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractTripleEncapsulatedExpressionHelper<T extends AbstractTripleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        private AbstractTripleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        abstract String firstCommaMissingKey();

        abstract String firstExpressionInvalidKey();

        public int firstExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getFirstExpression());
        }

        abstract String firstExpressionMissingKey();

        public boolean hasFirstExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasFirstExpression();
        }

        public boolean hasSecondExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasSecondExpression();
        }

        public boolean hasThirdExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasThirdExpression();
        }

        abstract boolean isFirstExpressionValid(T var1);

        abstract boolean isSecondExpressionValid(T var1);

        abstract boolean isThirdExpressionValid(T var1);

        abstract String secondCommaMissingKey();

        abstract String secondExpressionInvalidKey();

        public int secondExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getSecondExpression());
        }

        abstract String secondExpressionMissingKey();

        abstract String thirdExpressionInvalidKey();

        public int thirdExpressionLength(T expression) {
            return GrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getThirdExpression());
        }

        abstract String thirdExpressionMissingKey();
    }

    private class CollectionSeparatedByCommaValidator
    extends AbstractCollectionValidator {
        private CollectionSeparatedByCommaValidator() {
        }

        boolean validateSeparator(CollectionExpression expression, int index) {
            return expression.hasComma(index);
        }
    }

    private class CollectionSeparatedBySpaceValidator
    extends AbstractCollectionValidator {
        private CollectionSeparatedBySpaceValidator() {
        }

        boolean validateSeparator(CollectionExpression expression, int index) {
            return !expression.hasComma(index);
        }
    }

    private static class ComparisonExpressionVisitor
    extends AbstractExpressionVisitor {
        ComparisonExpression expression;

        private ComparisonExpressionVisitor() {
        }

        public void visit(ComparisonExpression expression) {
            this.expression = expression;
        }
    }

    private static class FuncExpressionFinder
    extends AbstractTraverseParentVisitor {
        private FuncExpression expression;

        private FuncExpressionFinder() {
        }

        public void visit(FuncExpression expression) {
            this.expression = expression;
        }
    }
}

