/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.internal.jpql.ParameterTypeVisitor;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverBuilder;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPQLQueryContext {
    private Map<Expression, JPQLQueryContext> contexts;
    protected JPQLQueryContext currentContext;
    private Expression currentQuery;
    private DeclarationResolver declarationResolver;
    private InputParameterVisitor inputParameterVisitor;
    private JPQLExpression jpqlExpression;
    private LiteralVisitor literalVisitor;
    private ParameterTypeVisitor parameterTypeVisitor;
    protected JPQLQueryContext parent;
    private IQuery query;
    private QueryExpressionVisitor queryExpressionVisitor;
    private ResolverBuilder resolverBuilder;
    private boolean traversed;

    public JPQLQueryContext() {
        this.initialize();
    }

    protected JPQLQueryContext(JPQLQueryContext parent, Expression currentQuery) {
        this();
        this.store(parent, currentQuery);
    }

    private DeclarationResolver buildDeclarationResolver() {
        DeclarationResolver parentResolver = this.parent != null ? this.parent.getDeclarationResolverImp() : null;
        return new DeclarationResolver(parentResolver, this);
    }

    protected void convertUnqualifiedDeclaration(DeclarationResolver.Declaration declaration) {
        if (this.parent != null) {
            DeclarationResolver.Declaration parentDeclaration = this.parent.getDeclarationResolverImp().getDeclarations().get(0);
            String outerVariableName = parentDeclaration.getVariableName();
            this.getDeclarationResolverImp().convertUnqualifiedDeclaration(declaration, outerVariableName);
        }
    }

    public void dispose() {
        this.query = null;
        this.traversed = false;
        this.currentQuery = null;
        this.currentContext = this;
        this.jpqlExpression = null;
        this.contexts.clear();
        if (this.declarationResolver != null) {
            this.declarationResolver.dispose();
        }
    }

    public void disposeSubqueryContext() {
        this.currentContext = this.currentContext.parent;
    }

    protected Collection<InputParameter> findInputParameters(String parameterName) {
        InputParameterVisitor visitor = this.inputParameterVisitor();
        try {
            visitor.parameterName = parameterName;
            visitor.inputParameters = new ArrayList<InputParameter>();
            this.jpqlExpression.accept(visitor);
            Collection<InputParameter> collection = visitor.inputParameters;
            return collection;
        }
        finally {
            visitor.parameterName = null;
            visitor.inputParameters = null;
        }
    }

    public DeclarationResolver getActualDeclarationResolver() {
        return this.getDeclarationResolverImp();
    }

    protected JPQLQueryContext getCurrentContext() {
        return this.currentContext;
    }

    public Expression getCurrentQuery() {
        return this.currentQuery;
    }

    protected DeclarationResolver getDeclarationResolver() {
        return this.currentContext.getDeclarationResolverImp();
    }

    protected DeclarationResolver getDeclarationResolver(Expression expression) {
        JPQLQueryContext context = this.contexts.get(expression = this.queryExpression(expression));
        if (context != null) {
            return context.getDeclarationResolverImp();
        }
        this.getDeclarationResolver(expression.getParent());
        this.newSubqueryContext(expression);
        return this.currentContext.getDeclarationResolverImp();
    }

    private DeclarationResolver getDeclarationResolverImp() {
        if (this.declarationResolver == null) {
            this.declarationResolver = this.buildDeclarationResolver();
        }
        if (!this.traversed) {
            this.traversed = true;
            this.declarationResolver.populate(this.currentQuery);
        }
        return this.declarationResolver;
    }

    public List<DeclarationResolver.Declaration> getDeclarations() {
        return this.getDeclarationResolver().getDeclarations();
    }

    public IType getEnumType(String enumTypeName) {
        return this.getTypeRepository().getEnumType(enumTypeName);
    }

    public Collection<JoinFetch> getJoinFetches(String variableName) {
        return this.getDeclarationResolver().getJoinFetches(variableName);
    }

    public JPQLExpression getJPQLExpression() {
        return this.jpqlExpression;
    }

    public String getJPQLQuery() {
        return this.query.getExpression();
    }

    public IMapping getMapping(Expression expression) {
        return this.getResolver(expression).getMapping();
    }

    public IType getParameterType(InputParameter inputParameter) {
        ParameterTypeVisitor visitor = this.parameterTypeVisitor();
        try {
            inputParameter.accept(visitor);
            IType iType = visitor.getType();
            return iType;
        }
        finally {
            visitor.dispose();
        }
    }

    public JPQLQueryContext getParent() {
        return this.parent;
    }

    public IManagedTypeProvider getProvider() {
        return this.query.getProvider();
    }

    public IQuery getQuery() {
        return this.query;
    }

    public Resolver getResolver(Expression expression) {
        ResolverBuilder visitor = this.resolverBuilder();
        try {
            expression.accept(visitor);
            Resolver resolver = visitor.resolver;
            return resolver;
        }
        finally {
            visitor.resolver = null;
        }
    }

    public Resolver getResolver(String variableName) {
        return this.getDeclarationResolver().getResolver(variableName);
    }

    public Set<String> getResultVariables() {
        return this.getDeclarationResolver().getResultVariables();
    }

    public IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    public IType getType(Expression expression) {
        return this.getResolver(expression).getType();
    }

    public IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    public ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.getResolver(expression).getTypeDeclaration();
    }

    public TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    public boolean hasJoins() {
        return this.getDeclarationResolver().hasJoins();
    }

    protected void initialize() {
        this.currentContext = this;
        this.contexts = new HashMap<Expression, JPQLQueryContext>();
    }

    private void initializeRoot() {
        if (this.jpqlExpression == null) {
            this.jpqlExpression = new JPQLExpression(this.query.getExpression(), IJPAVersion.DEFAULT_VERSION, true);
        }
        this.currentQuery = this.jpqlExpression;
        this.contexts.put(this.currentQuery, this);
    }

    private InputParameterVisitor inputParameterVisitor() {
        if (this.inputParameterVisitor == null) {
            this.inputParameterVisitor = new InputParameterVisitor();
        }
        return this.inputParameterVisitor;
    }

    public boolean isCollectionVariableName(String variableName) {
        return this.getDeclarationResolver().isCollectionIdentificationVariable(variableName);
    }

    public boolean isRangeIdentificationVariable(String variableName) {
        return this.getDeclarationResolver().isRangeIdentificationVariable(variableName);
    }

    public String literal(Expression expression, LiteralType type) {
        LiteralVisitor visitor = this.literalVisitor();
        try {
            visitor.setType(type);
            expression.accept(visitor);
            String string = visitor.literal;
            return string;
        }
        finally {
            visitor.literal = "";
        }
    }

    private LiteralVisitor literalVisitor() {
        if (this.literalVisitor == null) {
            this.literalVisitor = new LiteralVisitor();
        }
        return this.literalVisitor;
    }

    public void newSubqueryContext(Expression currentQuery) {
        JPQLQueryContext context = this.contexts.get(currentQuery);
        this.currentContext = context != null ? context : new JPQLQueryContext(this.currentContext, currentQuery);
    }

    private ParameterTypeVisitor parameterTypeVisitor() {
        if (this.parameterTypeVisitor == null) {
            this.parameterTypeVisitor = new ParameterTypeVisitor(this);
        }
        return this.parameterTypeVisitor;
    }

    private Expression queryExpression(Expression expression) {
        QueryExpressionVisitor visitor = this.queryExpressionVisitor();
        try {
            expression.accept(visitor);
            Expression expression2 = visitor.expression;
            return expression2;
        }
        finally {
            visitor.expression = null;
        }
    }

    private QueryExpressionVisitor queryExpressionVisitor() {
        if (this.queryExpressionVisitor == null) {
            this.queryExpressionVisitor = new QueryExpressionVisitor();
        }
        return this.queryExpressionVisitor;
    }

    private ResolverBuilder resolverBuilder() {
        if (this.resolverBuilder == null) {
            this.resolverBuilder = new ResolverBuilder(this);
        }
        return this.resolverBuilder;
    }

    public void setJPQLExpression(JPQLExpression jpqlExpression) {
        this.jpqlExpression = jpqlExpression;
    }

    public void setQuery(IQuery query) {
        this.query = query;
        this.initializeRoot();
    }

    protected void store(JPQLQueryContext parent, Expression currentQuery) {
        this.parent = parent;
        this.currentQuery = currentQuery;
        this.query = parent.query;
        this.contexts = parent.contexts;
        this.jpqlExpression = parent.jpqlExpression;
        this.literalVisitor = parent.literalVisitor;
        this.resolverBuilder = parent.resolverBuilder;
        this.parameterTypeVisitor = parent.parameterTypeVisitor;
        this.queryExpressionVisitor = parent.queryExpressionVisitor;
        this.contexts.put(currentQuery, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Current JPQL query=");
        sb.append(this.currentContext.currentQuery.toParsedText());
        return sb.toString();
    }

    private class InputParameterVisitor
    extends AbstractTraverseChildrenVisitor {
        Collection<InputParameter> inputParameters;
        String parameterName;

        private InputParameterVisitor() {
        }

        public void visit(InputParameter expression) {
            if (this.parameterName.equals(expression.getParameter())) {
                this.inputParameters.add(expression);
            }
        }

        public void visit(SimpleSelectStatement expression) {
            JPQLQueryContext.this.newSubqueryContext(expression);
            try {
                super.visit(expression);
            }
            finally {
                JPQLQueryContext.this.disposeSubqueryContext();
            }
        }
    }

    private static class QueryExpressionVisitor
    extends AbstractTraverseParentVisitor {
        Expression expression;

        private QueryExpressionVisitor() {
        }

        public void visit(JPQLExpression expression) {
            this.expression = expression;
        }

        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }
}

