/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.persistence.jpa.internal.jpql.AbsFunctionResolver;
import org.eclipse.persistence.jpa.internal.jpql.ClassNameResolver;
import org.eclipse.persistence.jpa.internal.jpql.ClassResolver;
import org.eclipse.persistence.jpa.internal.jpql.CollectionEquivalentResolver;
import org.eclipse.persistence.jpa.internal.jpql.CollectionValuedFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.EntityResolver;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.KeyResolver;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.NullResolver;
import org.eclipse.persistence.jpa.internal.jpql.NumericResolver;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.SingleValuedObjectFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.SumFunctionResolver;
import org.eclipse.persistence.jpa.internal.jpql.TreatResolver;
import org.eclipse.persistence.jpa.internal.jpql.ValueResolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResolverBuilder
implements ExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    private final JPQLQueryContext queryContext;
    Resolver resolver;
    private static Pattern DOUBLE_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?([dD]|([eE][-+]?[0-9]+))?$");
    private static Pattern FLOAT_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?[fF]$");
    private static Pattern INTEGER_REGEXP = Pattern.compile("^[-+]?[0-9]+$");
    private static Pattern LONG_REGEXP = Pattern.compile("^[-+]?[0-9]+[lL]?$");

    ResolverBuilder(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private Resolver buildClassNameResolver(String typeName) {
        return new ClassNameResolver(this.getDeclarationResolver(), typeName);
    }

    private Resolver buildClassResolver(Class<?> type) {
        return new ClassResolver(this.getDeclarationResolver(), type);
    }

    private Resolver buildCollectionValuedFieldResolver(String variableName, String collectionValuedField) {
        Resolver resolver = this.resolver.getChild(variableName);
        if (resolver == null) {
            resolver = new CollectionValuedFieldResolver(this.resolver, variableName, collectionValuedField);
        }
        return resolver;
    }

    private Resolver buildNullResolver() {
        return new NullResolver(this.getDeclarationResolver());
    }

    private Resolver buildSingleValuedObjectFieldResolver(String variableName) {
        Resolver resolver = this.resolver.getChild(variableName);
        if (resolver == null) {
            resolver = new SingleValuedObjectFieldResolver(this.resolver, variableName);
        }
        return resolver;
    }

    private Resolver buildStateFieldResolver(String variableName, String stateFieldPath) {
        Resolver resolver = this.resolver.getChild(variableName);
        if (resolver == null) {
            resolver = new StateFieldResolver(this.resolver, variableName, stateFieldPath);
        }
        return resolver;
    }

    private CollectionExpression collectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.collectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    private CollectionExpressionVisitor collectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = new CollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    private DeclarationResolver getDeclarationResolver() {
        return this.queryContext.getDeclarationResolver();
    }

    private DeclarationResolver getDeclarationResolver(Expression expression) {
        return this.queryContext.getDeclarationResolver(expression);
    }

    @Override
    public void visit(AbsExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new AbsFunctionResolver(this.resolver);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        String abstractSchemaName = expression.getText();
        if (ExpressionTools.stringIsNotEmpty(abstractSchemaName)) {
            DeclarationResolver parent = this.getDeclarationResolver(expression);
            this.resolver = new EntityResolver(parent, abstractSchemaName);
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(AndExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(AvgFunction expression) {
        this.resolver = this.buildClassResolver(Double.class);
    }

    @Override
    public void visit(BadExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(BetweenExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(CaseExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getWhenClauses(), expression.getElseExpression());
    }

    @Override
    public void visit(CoalesceExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getExpression(), null);
    }

    @Override
    public void visit(CollectionExpression expression) {
        expression.acceptChildren(this);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        expression.getCollectionValuedPathExpression().accept(this);
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        if (!expression.endsWithDot()) {
            expression.getIdentificationVariable().accept(this);
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = expression.pathSize();
            while (index < count) {
                this.resolver = index + 1 < count ? this.buildSingleValuedObjectFieldResolver(expression.getPath(index)) : this.buildCollectionValuedFieldResolver(expression.getPath(index), expression.toParsedText());
                ++index;
            }
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(ComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        String className = expression.getClassName();
        this.resolver = ExpressionTools.stringIsNotEmpty(className) ? this.buildClassNameResolver(className) : this.buildNullResolver();
    }

    @Override
    public void visit(CountFunction expression) {
        this.resolver = this.buildClassResolver(Long.class);
    }

    @Override
    public void visit(DateTime expression) {
        String text;
        this.resolver = expression.isCurrentDate() ? this.buildClassResolver(Date.class) : (expression.isCurrentTime() ? this.buildClassResolver(Time.class) : (expression.isCurrentTimestamp() ? this.buildClassResolver(Timestamp.class) : ((text = expression.getText()).startsWith("{d") ? this.buildClassResolver(Date.class) : (text.startsWith("{ts") ? this.buildClassResolver(Timestamp.class) : (text.startsWith("{t") ? this.buildClassResolver(Time.class) : this.buildNullResolver())))));
    }

    @Override
    public void visit(DeleteClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(DeleteStatement expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        String entityTypeName = expression.getEntityTypeName();
        if (ExpressionTools.stringIsNotEmpty(entityTypeName)) {
            DeclarationResolver parent = this.getDeclarationResolver(expression);
            this.resolver = new EntityResolver(parent, entityTypeName);
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(EntryExpression expression) {
        this.resolver = this.buildClassResolver(Map.Entry.class);
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(FromClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(FuncExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(GroupByClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(HavingClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = parent.getResolver(expression.getText());
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(IndexExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(InExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(InputParameter expression) {
        this.resolver = this.buildClassNameResolver("UNRESOLVABLE_TYPE");
    }

    @Override
    public void visit(Join expression) {
        expression.getJoinAssociationPath().accept(this);
        this.resolver.setNullAllowed(expression.isLeftJoin());
    }

    @Override
    public void visit(JoinFetch expression) {
        expression.getJoinAssociationPath().accept(this);
        this.resolver.setNullAllowed(expression.isLeftJoinFetch());
    }

    @Override
    public void visit(JPQLExpression expression) {
        expression.getQueryStatement().accept(this);
    }

    @Override
    public void visit(KeyExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new KeyResolver(this.resolver);
    }

    @Override
    public void visit(KeywordExpression expression) {
        String text = expression.getText();
        this.resolver = text == "FALSE" || text == "TRUE" ? this.buildClassResolver(Boolean.class) : this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(LengthExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(LikeExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(LowerExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(MaxFunction expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(MinFunction expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(ModExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(NullExpression expression) {
        this.resolver = this.buildClassNameResolver("UNRESOLVABLE_TYPE");
    }

    @Override
    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept(this);
    }

    @Override
    public void visit(NumericLiteral expression) {
        try {
            String text = expression.getText();
            if (LONG_REGEXP.matcher(text).matches() || INTEGER_REGEXP.matcher(text).matches()) {
                Long value = Long.parseLong(text);
                this.resolver = value <= Integer.MAX_VALUE ? this.buildClassResolver(Integer.class) : this.buildClassResolver(Long.class);
            } else if (FLOAT_REGEXP.matcher(text).matches()) {
                this.resolver = this.buildClassResolver(Float.class);
            } else if (DOUBLE_REGEXP.matcher(text).matches()) {
                this.resolver = this.buildClassResolver(Double.class);
            }
        }
        catch (Exception exception) {
            this.resolver = this.buildClassResolver(Object.class);
        }
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(OrderByClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(OrderByItem expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(OrExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SelectClause expression) {
        Expression selectExpression = expression.getSelectExpression();
        CollectionExpression collectionExpression = this.collectionExpression(selectExpression);
        if (collectionExpression != null) {
            this.resolver = this.buildClassResolver(Object[].class);
        } else {
            selectExpression.accept(this);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        expression.getSelectClause().accept(this);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        this.queryContext.newSubqueryContext(expression);
        try {
            expression.getSelectClause().accept(this);
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.resolver = this.buildClassResolver(Double.class);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        if (!expression.endsWithDot()) {
            expression.getIdentificationVariable().accept(this);
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = expression.pathSize();
            while (index < count) {
                this.resolver = index + 1 < count ? this.buildSingleValuedObjectFieldResolver(expression.getPath(index)) : this.buildStateFieldResolver(expression.getPath(index), expression.toParsedText());
                ++index;
            }
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(StringLiteral expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(SubExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        expression.getExpression().accept(this);
        this.resolver = new SumFunctionResolver(this.resolver);
    }

    @Override
    public void visit(TreatExpression expression) {
        expression.getCollectionValuedPathExpression().accept(this);
        String entityTypeName = this.queryContext.literal(expression.getEntityType(), LiteralType.ENTITY_TYPE);
        this.resolver = new TreatResolver(this.resolver, entityTypeName);
    }

    @Override
    public void visit(TrimExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(TypeExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(UnknownExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateItem expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateStatement expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(ValueExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new ValueResolver(this.resolver);
    }

    @Override
    public void visit(WhenClause expression) {
        expression.getThenExpression().accept(this);
    }

    @Override
    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept(this);
    }

    private void visitArithmeticExpression(ArithmeticExpression expression) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>(2);
        expression.getLeftExpression().accept(this);
        resolvers.add(this.resolver);
        expression.getRightExpression().accept(this);
        resolvers.add(this.resolver);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, resolvers);
    }

    private void visitCollectionEquivalentExpression(Expression expression, Expression extraExpression) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>();
        CollectionExpression collectionExpression = this.collectionExpression(expression);
        if (collectionExpression != null) {
            Expression[] expressionArray = collectionExpression.getChildren();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression child = expressionArray[n2];
                child.accept(this);
                resolvers.add(this.resolver);
                ++n2;
            }
        } else {
            expression.accept(this);
            resolvers.add(this.resolver);
        }
        if (extraExpression != null) {
            extraExpression.accept(this);
            resolvers.add(this.resolver);
        }
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new CollectionEquivalentResolver(parent, resolvers);
    }

    private static final class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        CollectionExpression expression;

        private CollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }
}

