/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

public final class WordParser {
    private int cursor;
    private final int length;
    private final CharSequence text;

    public WordParser(CharSequence query) {
        this.checkText(query);
        this.text = query;
        this.length = this.text.length();
        this.cursor = 0;
    }

    public char character() {
        return this.character(this.cursor);
    }

    public char character(int position) {
        return position >= this.length ? (char)'\u0000' : this.text.charAt(position);
    }

    private void checkText(CharSequence query) {
        if (query == null) {
            throw new NullPointerException("The query cannot be null");
        }
    }

    public boolean endsWith(int endPosition, String suffix) {
        return this.startsWith(suffix, endPosition - suffix.length());
    }

    public String entireWord() {
        return this.entireWord(this.cursor);
    }

    public String entireWord(int position) {
        int startPosition = this.partialWordStartPosition(position);
        int endPosition = this.wordEndPosition(position);
        return this.substring(startPosition, endPosition);
    }

    public boolean isArithmeticSymbol(char character) {
        return character == '>' || character == '<' || character == '/' || character == '*' || character == '-' || character == '+' || character == '=' || character == '{';
    }

    public boolean isDelimitor(char character) {
        return character == '(' || character == ')' || character == ',';
    }

    public boolean isDigit(char character) {
        return character == '.' || Character.isDigit(character);
    }

    public boolean isParsingComplete(char character) {
        return Character.isWhitespace(character) || this.isDelimitor(character) || character == '>' || character == '<' || character == '/' || character == '*' || character == '=';
    }

    public boolean isTail() {
        return this.cursor >= this.length;
    }

    public int length() {
        return this.length;
    }

    public void moveBackward(CharSequence word) {
        this.moveBackward(word.length());
    }

    public void moveBackward(int position) {
        this.cursor -= position;
    }

    public void moveForward(CharSequence word) {
        this.moveForward(word.length());
    }

    public void moveForward(int position) {
        this.cursor += position;
    }

    public String partialWord() {
        int startIndex = this.partialWordStartPosition(this.cursor);
        return this.substring(startIndex, this.cursor);
    }

    public String partialWord(int position) {
        int startIndex = this.partialWordStartPosition(position);
        return this.substring(startIndex, position);
    }

    public int partialWordStartPosition(int position) {
        int startIndex = position;
        int index = position;
        while (--index >= 0) {
            char character = this.text.charAt(index);
            if (Character.isWhitespace(character) || this.isDelimitor(character) || this.isArithmeticSymbol(character)) break;
            --startIndex;
        }
        return startIndex;
    }

    public int position() {
        return this.cursor;
    }

    public String potentialWord() {
        return this.substring(this.cursor, this.potentialWordEndPosition());
    }

    public int potentialWordEndPosition() {
        int endIndex = this.cursor;
        int index = this.cursor;
        while (index < this.length) {
            char character = this.text.charAt(index);
            if (this.isArithmeticSymbol(character)) {
                if (endIndex != this.cursor) break;
                ++endIndex;
                break;
            }
            if (Character.isWhitespace(character) || this.isDelimitor(character)) {
                index = this.length;
            } else {
                ++endIndex;
            }
            ++index;
        }
        return endIndex;
    }

    public String previousWord(int position) {
        while (--position >= 0) {
            char character = this.text.charAt(position);
            if (Character.isWhitespace(character)) break;
        }
        if (position <= 0) {
            return "";
        }
        return this.entireWord(position);
    }

    public void setPosition(int position) {
        this.cursor = position;
    }

    public int skipLeadingWhitespace() {
        int count = 0;
        while (this.cursor < this.length) {
            char character = this.text.charAt(this.cursor);
            if (!Character.isWhitespace(character)) break;
            ++this.cursor;
            ++count;
        }
        return count;
    }

    public boolean startsWith(char possibleCharacter) {
        return possibleCharacter == this.character();
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, this.cursor);
    }

    public boolean startsWith(CharSequence prefix, int startIndex) {
        int prefixLength = prefix.length();
        if (startIndex < 0 || startIndex > this.length - prefixLength) {
            return false;
        }
        int prefixIndex = 0;
        while (--prefixLength >= 0) {
            if (this.text.charAt(startIndex++) == prefix.charAt(prefixIndex++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithArithmeticOperator() {
        char character = this.text.charAt(this.cursor);
        return character == '+' || character == '/' || character == '-' || character == '*';
    }

    public Boolean startsWithDigit() {
        char character = this.character();
        if (character == '-' || character == '+') {
            if (this.cursor + 1 < this.length && this.isDigit(this.character(this.cursor + 1))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (character == '.') {
            return this.isDigit(this.character(this.cursor + 1));
        }
        if (this.isDigit(character)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean startsWithIdentifier(CharSequence prefix) {
        return this.startsWithIdentifier(prefix, this.cursor);
    }

    public boolean startsWithIdentifier(CharSequence prefix, int toffset) {
        if (this.startsWithIgnoreCase(prefix, toffset)) {
            int nextCharacterIndex = toffset + prefix.length();
            if (nextCharacterIndex == this.length) {
                return true;
            }
            char character = this.text.charAt(nextCharacterIndex);
            if (Character.isWhitespace(character) || this.isDelimitor(character)) {
                return true;
            }
        }
        return false;
    }

    public boolean startsWithIgnoreCase(char possibleCharacter) {
        char character = this.character();
        return possibleCharacter == character || possibleCharacter == Character.toUpperCase(character);
    }

    public boolean startsWithIgnoreCase(CharSequence prefix) {
        return this.startsWithIgnoreCase(prefix, this.cursor);
    }

    public boolean startsWithIgnoreCase(CharSequence prefix, int offset) {
        int pc = prefix.length();
        if (offset < 0 || offset > this.length - pc) {
            return false;
        }
        int po = 0;
        int to = offset;
        while (--pc >= 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = this.text.charAt(to++)) == (c2 = prefix.charAt(po++))) continue;
            char u1 = Character.toUpperCase(c1);
            if (u1 != (u2 = Character.toUpperCase(c2))) {
                return false;
            }
            if (Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public String substring() {
        return this.substring(this.cursor);
    }

    public String substring(int startIndex) {
        return this.substring(startIndex, this.length);
    }

    public String substring(int startIndex, int endIndex) {
        return this.text.subSequence(startIndex, endIndex).toString();
    }

    public String toString() {
        return this.isTail() ? "" : this.substring();
    }

    public int whitespaceCount() {
        return this.whitespaceCount(this.cursor);
    }

    public int whitespaceCount(int position) {
        int index = position;
        while (index < this.length) {
            char character = this.text.charAt(index);
            if (!Character.isWhitespace(character)) {
                return index - position;
            }
            ++index;
        }
        return 0;
    }

    public String word() {
        return this.substring(this.cursor, this.wordEndPosition());
    }

    public int wordEndPosition() {
        return this.wordEndPosition(this.cursor);
    }

    public int wordEndPosition(int position) {
        int endIndex = position;
        int index = position;
        while (index < this.length) {
            char character = this.text.charAt(index);
            if (this.isParsingComplete(character)) {
                index = this.length;
            } else {
                ++endIndex;
            }
            ++index;
        }
        return endIndex;
    }
}

