/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFromClause
extends AbstractExpression {
    private AbstractExpression declaration;
    private boolean hasSpace;

    AbstractFromClause(AbstractExpression parent) {
        super(parent, "FROM");
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDeclaration().accept(visitor);
    }

    @Override
    final void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDeclaration());
    }

    @Override
    final void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("FROM"));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.declaration != null) {
            children.add(this.declaration);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getDeclaration());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public abstract JPQLQueryBNF declarationBNF();

    public final Expression getDeclaration() {
        if (this.declaration == null) {
            this.declaration = this.buildNullExpression();
        }
        return this.declaration;
    }

    public final boolean hasDeclaration() {
        return this.declaration != null && !this.declaration.isNull();
    }

    public final boolean hasSpaceAfterFrom() {
        return this.hasSpace;
    }

    @Override
    final void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("FROM");
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.declaration = tolerant ? this.parse(wordParser, this.declarationBNF(), tolerant) : this.parseDeclaration(wordParser);
    }

    private AbstractExpression parseDeclaration(WordParser wordParser) {
        AbstractExpression declaration = null;
        ArrayList<AbstractExpression> children = null;
        boolean firstPass = true;
        String word = null;
        int count = 0;
        while (firstPass || !wordParser.isTail() && !this.isParsingComplete(wordParser, word, null)) {
            AbstractExpression expression;
            if (firstPass || !word.equalsIgnoreCase("IN")) {
                firstPass = false;
                expression = new IdentificationVariableDeclaration(this);
                ((IdentificationVariableDeclaration)expression).parse(wordParser, false);
                if (declaration == null && children == null) {
                    declaration = expression;
                } else {
                    if (children == null) {
                        children = new ArrayList();
                        children.add(declaration);
                        declaration = null;
                    }
                    children.add(expression);
                }
            } else {
                expression = new CollectionMemberDeclaration(this);
                ((CollectionMemberDeclaration)expression).parse(wordParser, false);
                if (children == null) {
                    children = new ArrayList<AbstractExpression>();
                    children.add(declaration);
                    declaration = null;
                }
                children.add(expression);
            }
            char character = wordParser.character();
            if (character == ',') {
                wordParser.moveForward(1);
            } else if (character == ')') {
                count = 0;
                break;
            }
            count = wordParser.skipLeadingWhitespace();
            word = wordParser.potentialWord();
        }
        if (children != null) {
            ArrayList<Boolean> spaces = new ArrayList<Boolean>(children.size());
            ArrayList<Boolean> commas = new ArrayList<Boolean>(children.size());
            int index = 0;
            int size = children.size() - 1;
            while (index < size) {
                spaces.add(Boolean.TRUE);
                commas.add(Boolean.TRUE);
                ++index;
            }
            spaces.add(Boolean.FALSE);
            commas.add(Boolean.FALSE);
            declaration = new CollectionExpression(this, children, commas, spaces);
        }
        if (count > 0) {
            wordParser.moveBackward(count);
        }
        return declaration;
    }

    public final void setIdentificationVariableDeclaration(String abstractSchemaName, String identificationVariable) {
        IdentificationVariableDeclaration declaration = new IdentificationVariableDeclaration(this);
        declaration.setRangeVariableDeclaration(abstractSchemaName, identificationVariable);
        this.declaration = declaration;
        this.hasSpace = true;
    }

    @Override
    boolean shouldParseWithFactoryFirst() {
        return false;
    }

    @Override
    final void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append("FROM");
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.declaration != null) {
            this.declaration.toParsedText(writer, includeVirtual);
        }
    }
}

