/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaNameBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaNameFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.AggregateExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactorBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticPrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticTermBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunctionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.BooleanExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.BooleanLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.BooleanPrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseOperandBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclarationFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConditionalExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConditionalFactorBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConditionalPrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConditionalTermBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunctionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTimeFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTimePrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTimeTimestampLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DatetimeExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClauseRangeVariableDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatementBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatementFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.DerivedCollectionMemberDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ElseExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityOrValueExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteralFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.EnumExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EnumLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.EnumPrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.FunctionsReturningDatetimeBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.FunctionsReturningNumericsBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.FunctionsReturningStringsBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.GeneralCaseExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.GeneralIdentificationVariableBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByItemFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclarationFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpressionExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.InItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameterBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalBetweenExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalCoalesceExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalConcatExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalCountBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalEntityTypeExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalFromClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalJoinBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalOrderByClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalOrderByItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalOrderByItemFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalSimpleFromClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalUpdateClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.InternalWhenClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.IsExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLStatementBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinAssociationPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetchBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.LiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.LiteralExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunctionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunctionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.NewValueBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItemFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.PatternValueBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.PreLiteralExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.PreLiteralExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.QualifiedIdentificationVariableBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclarationFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariableBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariableFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ScalarExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatementBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatementFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleArithmeticExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleCaseExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleConditionalExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleEntityExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleEntityOrValueExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatementFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.SingleValuedObjectPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SingleValuedPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteralBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteralFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringPrimaryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubQueryFromClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubSelectIdentificationVariableDeclarationBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunctionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItemBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItemFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItemStateFieldPathExpressionBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItemStateFieldPathExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatementBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatementFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClauseFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClauseBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClauseFactory;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExpressionRegistry {
    private Map<String, ExpressionFactory> expressionFactories;
    private Map<String, IdentifierRole> identifiers;
    private Map<String, IJPAVersion> identifiersVersions;
    private Map<String, JPQLQueryBNF> queryBNFs;

    ExpressionRegistry() {
        this.initialize();
    }

    ExpressionFactory expressionFactory(String expressionFactoryId) {
        return this.expressionFactories.get(expressionFactoryId);
    }

    ExpressionFactory expressionFactoryForIdentifier(String identifier) {
        if ("SELECT".equalsIgnoreCase(identifier = identifier.toUpperCase())) {
            return this.expressionFactory("simple-select");
        }
        for (ExpressionFactory expressionFactory : this.expressionFactories.values()) {
            boolean found;
            boolean bl = found = Arrays.binarySearch(expressionFactory.identifiers(), identifier) > -1;
            if (!found) continue;
            return expressionFactory;
        }
        return null;
    }

    IdentifierRole identifierRole(String identifier) {
        return this.identifiers.get(identifier.toUpperCase());
    }

    Collection<String> identifiers() {
        return this.identifiers.keySet();
    }

    Iterable<String> identifiers(String queryBNFId) {
        return ((JPQLQueryBNF)this.queryBNF(queryBNFId)).identifiers();
    }

    IJPAVersion identifierVersion(String identifier) {
        IJPAVersion version = this.identifiersVersions.get(identifier.toUpperCase());
        return version != null ? version : IJPAVersion.VERSION_1_0;
    }

    private void initialize() {
        this.queryBNFs = new HashMap<String, JPQLQueryBNF>();
        this.identifiers = new HashMap<String, IdentifierRole>();
        this.expressionFactories = new HashMap<String, ExpressionFactory>();
        this.identifiersVersions = new HashMap<String, IJPAVersion>();
        this.initializeIdentifiers();
        this.initializeExpressionFactories();
        this.initializeBNFs();
        this.identifiers = Collections.unmodifiableMap(this.identifiers);
    }

    private void initializeBNFs() {
        this.registerBNF(new AbstractSchemaNameBNF());
        this.registerBNF(new AggregateExpressionBNF());
        this.registerBNF(new AllOrAnyExpressionBNF());
        this.registerBNF(new ArithmeticExpressionBNF());
        this.registerBNF(new ArithmeticFactorBNF());
        this.registerBNF(new ArithmeticPrimaryBNF());
        this.registerBNF(new ArithmeticTermBNF());
        this.registerBNF(new BadExpressionBNF());
        this.registerBNF(new BetweenExpressionBNF());
        this.registerBNF(new BooleanExpressionBNF());
        this.registerBNF(new BooleanLiteralBNF());
        this.registerBNF(new BooleanPrimaryBNF());
        this.registerBNF(new CaseExpressionBNF());
        this.registerBNF(new CaseOperandBNF());
        this.registerBNF(new CoalesceExpressionBNF());
        this.registerBNF(new CollectionMemberDeclarationBNF());
        this.registerBNF(new CollectionMemberExpressionBNF());
        this.registerBNF(new CollectionValuedPathExpressionBNF());
        this.registerBNF(new ComparisonExpressionBNF());
        this.registerBNF(new ConditionalExpressionBNF());
        this.registerBNF(new ConditionalFactorBNF());
        this.registerBNF(new ConditionalPrimaryBNF());
        this.registerBNF(new ConditionalTermBNF());
        this.registerBNF(new ConstructorExpressionBNF());
        this.registerBNF(new ConstructorItemBNF());
        this.registerBNF(new DatetimeExpressionBNF());
        this.registerBNF(new DateTimePrimaryBNF());
        this.registerBNF(new DateTimeTimestampLiteralBNF());
        this.registerBNF(new DeleteClauseBNF());
        this.registerBNF(new DeleteClauseRangeVariableDeclarationBNF());
        this.registerBNF(new DeleteStatementBNF());
        this.registerBNF(new DerivedCollectionMemberDeclarationBNF());
        this.registerBNF(new ElseExpressionBNF());
        this.registerBNF(new EmptyCollectionComparisonExpressionBNF());
        this.registerBNF(new EntityExpressionBNF());
        this.registerBNF(new EntityOrValueExpressionBNF());
        this.registerBNF(new EntityTypeExpressionBNF());
        this.registerBNF(new EntityTypeLiteralBNF());
        this.registerBNF(new EnumExpressionBNF());
        this.registerBNF(new EnumLiteralBNF());
        this.registerBNF(new EnumPrimaryBNF());
        this.registerBNF(new ExistsExpressionBNF());
        this.registerBNF(new FromClauseBNF());
        this.registerBNF(new FunctionsReturningDatetimeBNF());
        this.registerBNF(new FunctionsReturningNumericsBNF());
        this.registerBNF(new FunctionsReturningStringsBNF());
        this.registerBNF(new GeneralCaseExpressionBNF());
        this.registerBNF(new GeneralIdentificationVariableBNF());
        this.registerBNF(new GroupByClauseBNF());
        this.registerBNF(new GroupByItemBNF());
        this.registerBNF(new HavingClauseBNF());
        this.registerBNF(new IdentificationVariableBNF());
        this.registerBNF(new IdentificationVariableDeclarationBNF());
        this.registerBNF(new InExpressionBNF());
        this.registerBNF(new InExpressionExpressionBNF());
        this.registerBNF(new InItemBNF());
        this.registerBNF(new InputParameterBNF());
        this.registerBNF(new InternalBetweenExpressionBNF());
        this.registerBNF(new InternalCoalesceExpressionBNF());
        this.registerBNF(new InternalConcatExpressionBNF());
        this.registerBNF(new InternalCountBNF());
        this.registerBNF(new InternalEntityTypeExpressionBNF());
        this.registerBNF(new InternalFromClauseBNF());
        this.registerBNF(new InternalJoinBNF());
        this.registerBNF(new InternalOrderByClauseBNF());
        this.registerBNF(new InternalOrderByItemBNF());
        this.registerBNF(new InternalSimpleFromClauseBNF());
        this.registerBNF(new InternalUpdateClauseBNF());
        this.registerBNF(new InternalWhenClauseBNF());
        this.registerBNF(new JoinAssociationPathExpressionBNF());
        this.registerBNF(new JoinBNF());
        this.registerBNF(new JoinFetchBNF());
        this.registerBNF(new JPQLStatementBNF());
        this.registerBNF(new LikeExpressionBNF());
        this.registerBNF(new LiteralBNF());
        this.registerBNF(new NewValueBNF());
        this.registerBNF(new NullComparisonExpressionBNF());
        this.registerBNF(new NullIfExpressionBNF());
        this.registerBNF(new NumericLiteralBNF());
        this.registerBNF(new ObjectExpressionBNF());
        this.registerBNF(new OrderByClauseBNF());
        this.registerBNF(new OrderByItemBNF());
        this.registerBNF(new PatternValueBNF());
        this.registerBNF(new PreLiteralExpressionBNF());
        this.registerBNF(new QualifiedIdentificationVariableBNF());
        this.registerBNF(new RangeVariableDeclarationBNF());
        this.registerBNF(new ResultVariableBNF());
        this.registerBNF(new ScalarExpressionBNF());
        this.registerBNF(new SelectClauseBNF());
        this.registerBNF(new SelectExpressionBNF());
        this.registerBNF(new SelectItemBNF());
        this.registerBNF(new SelectStatementBNF());
        this.registerBNF(new SimpleArithmeticExpressionBNF());
        this.registerBNF(new SimpleCaseExpressionBNF());
        this.registerBNF(new SimpleConditionalExpressionBNF());
        this.registerBNF(new SimpleEntityExpressionBNF());
        this.registerBNF(new SimpleEntityOrValueExpressionBNF());
        this.registerBNF(new SimpleSelectClauseBNF());
        this.registerBNF(new SimpleSelectExpressionBNF());
        this.registerBNF(new SingleValuedObjectPathExpressionBNF());
        this.registerBNF(new SingleValuedPathExpressionBNF());
        this.registerBNF(new StateFieldPathExpressionBNF());
        this.registerBNF(new StringExpressionBNF());
        this.registerBNF(new StringLiteralBNF());
        this.registerBNF(new StringPrimaryBNF());
        this.registerBNF(new SubQueryBNF());
        this.registerBNF(new SubQueryFromClauseBNF());
        this.registerBNF(new SubSelectIdentificationVariableDeclarationBNF());
        this.registerBNF(new TypeExpressionBNF());
        this.registerBNF(new UpdateClauseBNF());
        this.registerBNF(new UpdateItemBNF());
        this.registerBNF(new UpdateItemStateFieldPathExpressionBNF());
        this.registerBNF(new UpdateStatementBNF());
        this.registerBNF(new WhenClauseBNF());
        this.registerBNF(new WhereClauseBNF());
        this.registerBNF(new FuncExpressionBNF());
        this.registerBNF(new FuncItemBNF());
        this.registerBNF(new TreatExpressionBNF());
    }

    private void initializeExpressionFactories() {
        this.registerFactory(new AbsExpressionFactory());
        this.registerFactory(new AbstractSchemaNameFactory());
        this.registerFactory(new AllOrAnyExpressionFactory());
        this.registerFactory(new AndExpressionFactory());
        this.registerFactory(new ArithmeticExpressionFactory());
        this.registerFactory(new AvgFunctionFactory());
        this.registerFactory(new BadExpressionFactory());
        this.registerFactory(new BetweenExpressionFactory());
        this.registerFactory(new CollectionMemberDeclarationFactory());
        this.registerFactory(new CollectionMemberExpressionFactory());
        this.registerFactory(new CollectionValuedPathExpressionFactory());
        this.registerFactory(new ComparisonExpressionFactory());
        this.registerFactory(new ConcatExpressionFactory());
        this.registerFactory(new ConstructorExpressionFactory());
        this.registerFactory(new CountFunctionFactory());
        this.registerFactory(new DateTimeFactory());
        this.registerFactory(new DeleteClauseFactory());
        this.registerFactory(new DeleteStatementFactory());
        this.registerFactory(new EmptyCollectionComparisonExpressionFactory());
        this.registerFactory(new ExistsExpressionFactory());
        this.registerFactory(new FromClauseFactory());
        this.registerFactory(new GroupByClauseFactory());
        this.registerFactory(new GroupByItemFactory());
        this.registerFactory(new HavingClauseFactory());
        this.registerFactory(new IdentificationVariableDeclarationFactory());
        this.registerFactory(new IdentificationVariableFactory());
        this.registerFactory(new InExpressionFactory());
        this.registerFactory(new InternalOrderByItemFactory());
        this.registerFactory(new IsExpressionFactory());
        this.registerFactory(new JoinFactory());
        this.registerFactory(new KeywordExpressionFactory());
        this.registerFactory(new LengthExpressionFactory());
        this.registerFactory(new LikeExpressionFactory());
        this.registerFactory(new LiteralExpressionFactory());
        this.registerFactory(new LocateExpressionFactory());
        this.registerFactory(new LowerExpressionFactory());
        this.registerFactory(new MaxFunctionFactory());
        this.registerFactory(new MinFunctionFactory());
        this.registerFactory(new ModExpressionFactory());
        this.registerFactory(new NotExpressionFactory());
        this.registerFactory(new NullComparisonExpressionFactory());
        this.registerFactory(new ObjectExpressionFactory());
        this.registerFactory(new OrderByClauseFactory());
        this.registerFactory(new OrderByItemFactory());
        this.registerFactory(new OrExpressionFactory());
        this.registerFactory(new PreLiteralExpressionFactory());
        this.registerFactory(new RangeVariableDeclarationFactory());
        this.registerFactory(new SelectClauseFactory());
        this.registerFactory(new SelectStatementFactory());
        this.registerFactory(new SimpleSelectStatementFactory());
        this.registerFactory(new SizeExpressionFactory());
        this.registerFactory(new SqrtExpressionFactory());
        this.registerFactory(new StateFieldPathExpressionFactory());
        this.registerFactory(new StringLiteralFactory());
        this.registerFactory(new SubstringExpressionFactory());
        this.registerFactory(new SumFunctionFactory());
        this.registerFactory(new TrimExpressionFactory());
        this.registerFactory(new UnknownExpressionFactory());
        this.registerFactory(new UpdateClauseFactory());
        this.registerFactory(new UpdateItemFactory());
        this.registerFactory(new UpdateItemStateFieldPathExpressionFactory());
        this.registerFactory(new UpdateStatementFactory());
        this.registerFactory(new UpperExpressionFactory());
        this.registerFactory(new WhereClauseFactory());
        this.registerFactory(new CaseExpressionFactory());
        this.registerFactory(new CoalesceExpressionFactory());
        this.registerFactory(new EntityTypeLiteralFactory());
        this.registerFactory(new EntryExpressionFactory());
        this.registerFactory(new KeyExpressionFactory());
        this.registerFactory(new IndexExpressionFactory());
        this.registerFactory(new NullIfExpressionFactory());
        this.registerFactory(new ResultVariableFactory());
        this.registerFactory(new TypeExpressionFactory());
        this.registerFactory(new ValueExpressionFactory());
        this.registerFactory(new WhenClauseFactory());
        this.registerFactory(new FuncExpressionFactory());
        this.registerFactory(new TreatExpressionFactory());
    }

    private void initializeIdentifiers() {
        this.identifiers.put("ABS", IdentifierRole.FUNCTION);
        this.identifiers.put("ALL", IdentifierRole.FUNCTION);
        this.identifiers.put("AND", IdentifierRole.AGGREGATE);
        this.identifiers.put("ANY", IdentifierRole.FUNCTION);
        this.identifiers.put("AS", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("ASC", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("AVG", IdentifierRole.FUNCTION);
        this.identifiers.put("BETWEEN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("BIT_LENGTH", IdentifierRole.UNUSED);
        this.identifiers.put("BOTH", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("CHAR_LENGTH", IdentifierRole.UNUSED);
        this.identifiers.put("CHARACTER_LENGTH", IdentifierRole.UNUSED);
        this.identifiers.put("CLASS", IdentifierRole.UNUSED);
        this.identifiers.put("CONCAT", IdentifierRole.FUNCTION);
        this.identifiers.put("COUNT", IdentifierRole.FUNCTION);
        this.identifiers.put("CURRENT_DATE", IdentifierRole.FUNCTION);
        this.identifiers.put("CURRENT_TIME", IdentifierRole.FUNCTION);
        this.identifiers.put("CURRENT_TIMESTAMP", IdentifierRole.FUNCTION);
        this.identifiers.put("DELETE", IdentifierRole.CLAUSE);
        this.identifiers.put("DELETE FROM", IdentifierRole.CLAUSE);
        this.identifiers.put("DESC", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("DISTINCT", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("EMPTY", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("ESCAPE", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("EXISTS", IdentifierRole.FUNCTION);
        this.identifiers.put("FALSE", IdentifierRole.FUNCTION);
        this.identifiers.put("FETCH", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("FROM", IdentifierRole.CLAUSE);
        this.identifiers.put("HAVING", IdentifierRole.CLAUSE);
        this.identifiers.put("IN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("INNER", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("IS", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("JOIN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("LEADING", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("LEFT", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("LENGTH", IdentifierRole.FUNCTION);
        this.identifiers.put("LIKE", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("LOCATE", IdentifierRole.FUNCTION);
        this.identifiers.put("LOWER", IdentifierRole.FUNCTION);
        this.identifiers.put("MAX", IdentifierRole.FUNCTION);
        this.identifiers.put("MEMBER", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("MIN", IdentifierRole.FUNCTION);
        this.identifiers.put("MOD", IdentifierRole.FUNCTION);
        this.identifiers.put("NEW", IdentifierRole.FUNCTION);
        this.identifiers.put("NOT", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("NULL", IdentifierRole.FUNCTION);
        this.identifiers.put("OBJECT", IdentifierRole.FUNCTION);
        this.identifiers.put("OF", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("OR", IdentifierRole.AGGREGATE);
        this.identifiers.put("OUTER", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("POSITION", IdentifierRole.UNUSED);
        this.identifiers.put("SELECT", IdentifierRole.CLAUSE);
        this.identifiers.put("SET", IdentifierRole.CLAUSE);
        this.identifiers.put("SIZE", IdentifierRole.FUNCTION);
        this.identifiers.put("SOME", IdentifierRole.FUNCTION);
        this.identifiers.put("SQRT", IdentifierRole.FUNCTION);
        this.identifiers.put("SUBSTRING", IdentifierRole.FUNCTION);
        this.identifiers.put("SUM", IdentifierRole.FUNCTION);
        this.identifiers.put("TRAILING", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("TRIM", IdentifierRole.FUNCTION);
        this.identifiers.put("TRUE", IdentifierRole.FUNCTION);
        this.identifiers.put("UNKNOWN", IdentifierRole.UNUSED);
        this.identifiers.put("UPDATE", IdentifierRole.CLAUSE);
        this.identifiers.put("UPPER", IdentifierRole.FUNCTION);
        this.identifiers.put("WHERE", IdentifierRole.CLAUSE);
        this.identifiers.put("+", IdentifierRole.AGGREGATE);
        this.identifiers.put("-", IdentifierRole.AGGREGATE);
        this.identifiers.put("*", IdentifierRole.AGGREGATE);
        this.identifiers.put("/", IdentifierRole.AGGREGATE);
        this.identifiers.put("<", IdentifierRole.AGGREGATE);
        this.identifiers.put("<=", IdentifierRole.AGGREGATE);
        this.identifiers.put(">", IdentifierRole.AGGREGATE);
        this.identifiers.put(">=", IdentifierRole.AGGREGATE);
        this.identifiers.put("<>", IdentifierRole.AGGREGATE);
        this.identifiers.put("=", IdentifierRole.AGGREGATE);
        this.identifiers.put("GROUP BY", IdentifierRole.CLAUSE);
        this.identifiers.put("LEFT JOIN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("LEFT JOIN FETCH", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("LEFT OUTER JOIN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("LEFT OUTER JOIN FETCH", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("INNER JOIN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("INNER JOIN FETCH", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("IS EMPTY", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("IS NOT EMPTY", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("IS NOT NULL", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("IS NULL", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("JOIN FETCH", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("MEMBER OF", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("NOT BETWEEN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("NOT EXISTS", IdentifierRole.FUNCTION);
        this.identifiers.put("NOT IN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("NOT LIKE", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("NOT MEMBER", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("NOT MEMBER OF", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("ORDER BY", IdentifierRole.CLAUSE);
        this.identifiers.put("BY", IdentifierRole.CLAUSE);
        this.identifiers.put("DELETE", IdentifierRole.CLAUSE);
        this.identifiers.put("GROUP", IdentifierRole.CLAUSE);
        this.identifiers.put("ORDER", IdentifierRole.CLAUSE);
        this.identifiers.put("CASE", IdentifierRole.FUNCTION);
        this.identifiers.put("COALESCE", IdentifierRole.FUNCTION);
        this.identifiers.put("ELSE", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("END", IdentifierRole.COMPLETEMENT);
        this.identifiers.put("ENTRY", IdentifierRole.FUNCTION);
        this.identifiers.put("INDEX", IdentifierRole.FUNCTION);
        this.identifiers.put("KEY", IdentifierRole.FUNCTION);
        this.identifiers.put("NULLIF", IdentifierRole.FUNCTION);
        this.identifiers.put("THEN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiers.put("TYPE", IdentifierRole.FUNCTION);
        this.identifiers.put("VALUE", IdentifierRole.FUNCTION);
        this.identifiers.put("WHEN", IdentifierRole.COMPOUND_FUNCTION);
        this.identifiersVersions.put("CASE", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("COALESCE", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("ELSE", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("END", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("ENTRY", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("INDEX", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("KEY", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("NULLIF", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("THEN", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("TYPE", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("VALUE", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("WHEN", IJPAVersion.VERSION_2_0);
        this.identifiers.put("FUNC", IdentifierRole.FUNCTION);
        this.identifiers.put("TREAT", IdentifierRole.FUNCTION);
        this.identifiersVersions.put("FUNC", IJPAVersion.VERSION_2_0);
        this.identifiersVersions.put("TREAT", IJPAVersion.VERSION_2_0);
    }

    boolean isIdentifier(String word) {
        return this.identifiers.containsKey(word.toUpperCase());
    }

    <T extends JPQLQueryBNF> T queryBNF(String queryBNFID) {
        return (T)this.queryBNFs.get(queryBNFID);
    }

    private void registerBNF(JPQLQueryBNF queryBNF) {
        String id = queryBNF.getId();
        if ((queryBNF = this.queryBNFs.put(id, queryBNF)) != null) {
            throw new IllegalArgumentException("A JPQLQueryBNF is already registered with the id " + id);
        }
    }

    private void registerFactory(ExpressionFactory expressionFactory) {
        String id = expressionFactory.getId();
        if ((expressionFactory = this.expressionFactories.put(id, expressionFactory)) != null) {
            throw new IllegalArgumentException("An ExpressionFactory is already registered with the id " + id);
        }
    }
}

