/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQueryImpl<X>
implements JpaQuery<X> {
    private static final int UNDEFINED = -1;
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map<String, Object> parameterValues = new HashMap<String, Object>();
    protected Map<String, Parameter<?>> parameters;
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected LockModeType lockMode = null;
    protected boolean isShared;

    protected EJBQueryImpl(EntityManagerImpl entityManager) {
        this.entityManager = entityManager;
        this.isShared = true;
    }

    public EJBQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        this(entityManager);
        this.databaseQuery = query;
    }

    public EJBQueryImpl(String jpql, EntityManagerImpl entityManager) {
        this(jpql, entityManager, false);
    }

    public EJBQueryImpl(String queryDescription, EntityManagerImpl entityManager, boolean isNamedQuery) {
        this(entityManager);
        if (isNamedQuery) {
            this.queryName = queryDescription;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(queryDescription, (Session)this.entityManager.getDatabaseSession());
        }
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQueryInternal().isDataReadQuery()) {
            DataModifyQuery query = new DataModifyQuery();
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.copyFromQuery(this.databaseQuery);
            query.setDatasourceCall((Call)this.databaseQuery.getDatasourceCall().clone());
            this.databaseQuery = query;
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQueryInternal().isDataModifyQuery()) {
            DataReadQuery query = new DataReadQuery();
            query.setResultType(4);
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.copyFromQuery(this.databaseQuery);
            this.databaseQuery = query;
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String jpql, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, jpql, session, null, null, session.getDatasourcePlatform().getConversionManager().getLoader());
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String queryName, String jpql, Session session, Enum lockMode, Map<String, Object> hints, ClassLoader classLoader) {
        boolean isCacheable = queryName == null && hints == null;
        DatabaseQuery databaseQuery = null;
        if (isCacheable) {
            databaseQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get((Object)jpql);
        }
        if (databaseQuery == null || !databaseQuery.isPrepared()) {
            ReadAllQuery readQuery;
            ReadAllQuery readAllQuery;
            JPQLParseTree parseTree = JPQLParser.buildParseTree((String)queryName, (String)jpql);
            parseTree.setClassLoader(classLoader);
            databaseQuery = parseTree.createDatabaseQuery();
            databaseQuery.setJPQLString(jpql);
            parseTree.populateQuery(databaseQuery, (AbstractSession)session);
            if (databaseQuery.isReadAllQuery() && (readAllQuery = (ReadAllQuery)databaseQuery).hasJoining() && readAllQuery.getDistinctState() == 2) {
                readAllQuery.setShouldFilterDuplicates(false);
            }
            parseTree.addParametersToQuery(databaseQuery);
            ((JPQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            if (lockMode != null && !lockMode.name().equals("NONE")) {
                if (databaseQuery.isObjectLevelReadQuery()) {
                    if (((ObjectLevelReadQuery)databaseQuery).setLockModeType(lockMode.name(), (AbstractSession)session)) {
                        throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
                    }
                } else {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_lock_query", null));
                }
            }
            if ((databaseQuery = EJBQueryImpl.applyHints(hints, databaseQuery, classLoader, (AbstractSession)session)).isReadAllQuery() && !databaseQuery.isReportQuery() && ((ReadAllQuery)databaseQuery).shouldCheckCache() && (readQuery = (ReadAllQuery)databaseQuery).getContainerPolicy().getContainerClass() == ContainerPolicy.getDefaultContainerClass() && !readQuery.hasHierarchicalExpressions()) {
                databaseQuery.checkDescriptor((AbstractSession)session);
                Expression selectionCriteria = databaseQuery.getSelectionCriteria();
                if (selectionCriteria != null && databaseQuery.getDescriptor().getObjectBuilder().isPrimaryKeyExpression(true, selectionCriteria, (AbstractSession)session)) {
                    ReadObjectQuery newQuery = new ReadObjectQuery();
                    newQuery.copyFromQuery(databaseQuery);
                    databaseQuery = newQuery;
                }
            }
            if (isCacheable) {
                databaseQuery.prepareCall(session, (Record)new DatabaseRecord());
                session.getProject().getJPQLParseCache().put((Object)jpql, (Object)databaseQuery);
            }
        }
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(resultClass, sqlString, null, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlResultSetMappingName, sqlString, null, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class resultClass, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setCall((Call)call);
        query.setIsUserDefined(true);
        query = EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
        EJBQueryImpl.applyArguments(call, (DatabaseQuery)query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setCall((Call)call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
        EJBQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall((Call)call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
        EJBQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlString, new HashMap<String, Object>(), classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, (DatabaseQuery)query, classLoader, session);
    }

    protected Object executeReadQuery() {
        List<Object> parameterValues = this.processParameters();
        boolean shouldResetConformResultsInUnitOfWork = false;
        DatabaseQuery query = this.getDatabaseQueryInternal();
        boolean isObjectLevelReadQuery = query.isObjectLevelReadQuery();
        if (!(!this.isFlushModeAUTO() || isObjectLevelReadQuery && ((ObjectLevelReadQuery)query).isReadOnly())) {
            this.performPreQueryFlush();
            if (isObjectLevelReadQuery && ((ObjectLevelReadQuery)query).shouldConformResultsInUnitOfWork()) {
                this.cloneSharedQuery();
                query = this.getDatabaseQueryInternal();
                ((ObjectLevelReadQuery)query).setCacheUsage(-1);
                shouldResetConformResultsInUnitOfWork = true;
            }
        }
        if (this.lockMode != null) {
            this.entityManager.checkForTransaction(true);
            this.cloneSharedQuery();
            query = this.getDatabaseQueryInternal();
            if (((ObjectLevelReadQuery)query).setLockModeType(this.lockMode.name(), (AbstractSession)this.getActiveSession())) {
                throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
            }
        }
        Session session = this.getActiveSession();
        try {
            if (query.isUserDefined() && this.entityManager.checkForTransaction(false) != null && session.isUnitOfWork() && !((UnitOfWorkImpl)session).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)session).beginEarlyTransaction();
            }
            Object object = session.executeQuery(query, parameterValues);
            return object;
        }
        catch (DatabaseException e) {
            if (this.lockMode != null && this.lockMode.name().contains("PESSIMISTIC_")) {
                if (session.getPlatform().isLockTimeoutException(e)) {
                    throw new LockTimeoutException((Throwable)e);
                }
                throw new PessimisticLockException((Throwable)e);
            }
            this.setRollbackOnly();
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            this.lockMode = null;
            if (shouldResetConformResultsInUnitOfWork) {
                ((ObjectLevelReadQuery)query).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQueryInternal() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            List<Object> parameterValues = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer changedRows = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, parameterValues);
            return changedRows;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public DatabaseQuery getDatabaseQuery() {
        this.cloneSharedQuery();
        return this.getDatabaseQueryInternal();
    }

    public DatabaseQuery getDatabaseQueryInternal() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.entityManager.getDatabaseSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.prepareCall((Session)this.entityManager.getDatabaseSession(), (Record)new DatabaseRecord());
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unable_to_find_named_query", (Object[])new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    @Override
    public JpaEntityManager getEntityManager() {
        return this.entityManager;
    }

    protected Map<String, Parameter<?>> getInternalParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
            DatabaseQuery query = this.getDatabaseQueryInternal();
            int count = 0;
            if (query.getArguments() != null && !query.getArguments().isEmpty()) {
                for (String argName : query.getArguments()) {
                    ParameterExpressionImpl param = new ParameterExpressionImpl(null, (Class)query.getArgumentTypes().get(count), argName);
                    this.parameters.put(argName, (Parameter<?>)param);
                    ++count;
                }
            }
        }
        return this.parameters;
    }

    public LockModeType getLockMode() {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_lock_query", null));
            }
            return this.lockMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Cursor getResultCursor() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQueryInternal() instanceof ReadAllQuery) {
            if (!((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().isCursorPolicy()) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().getContainerClass();
                throw QueryException.invalidContainerClass((Class)containerClass, Cursor.class);
            }
        } else {
            if (this.getDatabaseQueryInternal() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound((DatabaseQuery)this.getDatabaseQueryInternal(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQueryInternal() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"incorrect_query_for_get_result_collection"));
            }
        }
        try {
            Object result = this.executeReadQuery();
            return (Cursor)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Collection getResultCollection() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (query.isReadAllQuery()) {
            Class containerClass = ((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface((Class)containerClass, (Class)ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass((Class)containerClass, (Class)ClassConstants.Collection_Class);
            }
        } else {
            if (query.isReadObjectQuery()) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                Object result = this.executeReadQuery();
                if (result != null) {
                    resultList.add(this.executeReadQuery());
                }
                return resultList;
            }
            if (!query.isReadQuery()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"incorrect_query_for_get_result_collection"));
            }
        }
        try {
            return (Collection)this.executeReadQuery();
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public List getResultList() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            DatabaseQuery query = this.getDatabaseQueryInternal();
            if (query.isReadAllQuery()) {
                Class containerClass = ((ReadAllQuery)query).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface((Class)containerClass, (Class)ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass((Class)containerClass, (Class)ClassConstants.List_Class);
                }
            } else {
                if (query.isReadObjectQuery()) {
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    Object result = this.executeReadQuery();
                    if (result != null) {
                        resultList.add(result);
                    }
                    return resultList;
                }
                if (!query.isReadQuery()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"incorrect_query_for_get_result_list"));
                }
            }
            return (List)this.executeReadQuery();
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public X getSingleResult() {
        boolean rollbackOnException = true;
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"incorrect_query_for_get_single_result"));
            }
            Object result = this.executeReadQuery();
            if (result instanceof List) {
                List results = (List)result;
                if (results.isEmpty()) {
                    rollbackOnException = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_single_result", null));
                } else if (results.size() > 1) {
                    rollbackOnException = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage((String)"too_many_results_for_get_single_result", null));
                }
                return (X)results.get(0);
            }
            if (result == null) {
                rollbackOnException = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_single_result", null));
            }
            return (X)result;
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            if (rollbackOnException) {
                this.setRollbackOnly();
            }
            throw exception;
        }
    }

    protected List<Object> processParameters() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        ArrayList<String> arguments = query.getArguments();
        if (arguments.isEmpty()) {
            arguments = new ArrayList<String>(this.parameterValues.keySet());
            query.setArguments(arguments);
        }
        int size = arguments.size();
        ArrayList<Object> parameterValues = new ArrayList<Object>(size);
        int index = 0;
        while (index < size) {
            String name = (String)arguments.get(index);
            Object parameter = this.parameterValues.get(name);
            if (parameter != null || this.parameterValues.containsKey(name)) {
                parameterValues.add(parameter);
            } else if (query.hasNullableArguments() && query.getNullableArguments().contains(new DatabaseField(name))) {
                parameterValues.add(null);
            } else {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"missing_parameter_value", (Object[])new Object[]{name}));
            }
            ++index;
        }
        return parameterValues;
    }

    @Override
    public void setDatabaseQuery(DatabaseQuery query) {
        this.databaseQuery = query;
    }

    public TypedQuery setFirstResult(int startPosition) {
        try {
            this.entityManager.verifyOpen();
            this.setFirstResultInternal(startPosition);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getFirstResult() {
        if (this.firstResultIndex == -1) {
            return 0;
        }
        return this.firstResultIndex;
    }

    protected void setFirstResultInternal(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"negative_start_position", null));
        }
        this.firstResultIndex = startPosition == 0 ? -1 : startPosition;
    }

    public TypedQuery setFlushMode(FlushModeType flushMode) {
        try {
            this.entityManager.verifyOpen();
            if (flushMode == null) {
                this.getDatabaseQueryInternal().setFlushOnExecute(null);
            } else {
                this.cloneSharedQuery();
                this.getDatabaseQueryInternal().setFlushOnExecute(Boolean.valueOf(flushMode == FlushModeType.AUTO));
            }
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected static void applyArguments(StoredProcedureCall call, DatabaseQuery query) {
        if (call instanceof PLSQLStoredProcedureCall) {
            PLSQLStoredProcedureCall plsqlCall = (PLSQLStoredProcedureCall)call;
            int index = 0;
            while (index < plsqlCall.getArguments().size()) {
                PLSQLargument argument = (PLSQLargument)plsqlCall.getArguments().get(index);
                int type = argument.direction;
                if (type == StoredProcedureCall.IN || type == StoredProcedureCall.INOUT) {
                    if (call.hasOptionalArguments()) {
                        query.addArgument(argument.name, Object.class, call.getOptionalArguments().contains(new DatabaseField(argument.name)));
                    } else {
                        query.addArgument(argument.name);
                    }
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < call.getParameters().size()) {
                Object value = call.getParameters().get(index);
                DatabaseField parameter = null;
                parameter = value instanceof Object[] ? (DatabaseField)((Object[])value)[0] : (DatabaseField)call.getParameters().get(index);
                int type = (Integer)call.getParameterTypes().get(index);
                if (type == StoredProcedureCall.IN || type == StoredProcedureCall.INOUT) {
                    if (call.hasOptionalArguments()) {
                        query.addArgument(parameter.getName(), Object.class, call.getOptionalArguments().contains(parameter));
                    } else {
                        query.addArgument(parameter.getName());
                    }
                }
                ++index;
            }
        }
    }

    protected static DatabaseQuery applyHints(Map<String, Object> hints, DatabaseQuery query, ClassLoader classLoader, AbstractSession session) {
        return QueryHintsHandler.apply(hints, query, classLoader, session);
    }

    public boolean isBound(Parameter<?> param) {
        if (param == null) {
            return false;
        }
        return this.parameterValues.containsKey(param.getName());
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQueryInternal().getFlushOnExecute() != null) {
            return this.getDatabaseQueryInternal().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    public TypedQuery setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setHintInternal(String hintName, Object value) {
        this.cloneSharedQuery();
        ClassLoader loader = this.getEntityManager().getDatabaseSession().getLoader();
        DatabaseQuery hintQuery = QueryHintsHandler.apply(hintName, value, this.getDatabaseQueryInternal(), loader, (AbstractSession)this.getActiveSession());
        if (hintQuery != null) {
            this.setDatabaseQuery(hintQuery);
        }
    }

    public TypedQuery setLockMode(LockModeType lockMode) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_lock_query", null));
            }
            this.lockMode = lockMode;
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void cloneSharedQuery() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (this.isShared) {
            query = (DatabaseQuery)this.databaseQuery.clone();
            this.setDatabaseQuery(query);
            this.isShared = false;
        }
    }

    protected Object convertTemporalType(Object value, TemporalType type) {
        ConversionManager conversionManager = ((AbstractSession)this.getEntityManager().getActiveSession()).getDatasourcePlatform().getConversionManager();
        if (type == TemporalType.TIME) {
            return conversionManager.convertObject(value, ClassConstants.TIME);
        }
        if (type == TemporalType.TIMESTAMP) {
            return conversionManager.convertObject(value, ClassConstants.TIMESTAMP);
        }
        if (type == TemporalType.DATE) {
            return conversionManager.convertObject(value, ClassConstants.SQLDATE);
        }
        return value;
    }

    public TypedQuery setMaxResults(int maxResult) {
        try {
            this.entityManager.verifyOpen();
            this.setMaxResultsInternal(maxResult);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getMaxResults() {
        if (this.maxResults == -1) {
            return Integer.MAX_VALUE;
        }
        return this.maxResults;
    }

    public void setMaxResultsInternal(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"negative_max_result", null));
        }
        this.maxResults = maxResult == Integer.MAX_VALUE ? -1 : maxResult;
    }

    public TypedQuery setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value, false);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public TypedQuery setParameter(String name, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public TypedQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public TypedQuery setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public TypedQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    public TypedQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQueryInternal();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQueryInternal();
                int maxRows = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(maxRows);
            }
            if (this.firstResultIndex > -1) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQueryInternal();
                readQuery.setFirstResult(this.firstResultIndex);
            }
        }
    }

    protected void setParameterInternal(String name, Object value, boolean isIndex) {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (query.getQueryMechanism().isJPQLCallQueryMechanism()) {
            int index = query.getArguments().indexOf(name);
            if (index == -1) {
                if (isIndex) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-argument-index", (Object[])new Object[]{name, query.getEJBQLString()}));
                }
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-argument-name", (Object[])new Object[]{name, query.getEJBQLString()}));
            }
            Class type = (Class)query.getArgumentTypes().get(index);
            if (!this.isValidActualParameter(value, type)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-incorrect-parameter-type", (Object[])new Object[]{name, value.getClass(), query.getArgumentTypes().get(index), query.getEJBQLString()}));
            }
        } else if (isIndex && name.equals("0")) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-argument-index", (Object[])new Object[]{name, query.getSQLString()}));
        }
        this.parameterValues.put(name, value);
    }

    protected void setParameterInternal(int position, Object value) {
        this.setParameterInternal(String.valueOf(position), value, true);
    }

    protected boolean isValidActualParameter(Object value, Class parameterType) {
        if (value == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom((Object)parameterType, value.getClass());
    }

    protected Session getActiveSession() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)query).isReadOnly()) {
            return this.entityManager.getReadOnlySession();
        }
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }

    protected void throwNoResultException(String message) {
        throw new NoResultException(message);
    }

    protected void throwNonUniqueResultException(String message) {
        throw new NonUniqueResultException(message);
    }

    public FlushModeType getFlushMode() {
        try {
            this.entityManager.verifyOpen();
            if (this.getDatabaseQueryInternal().getFlushOnExecute().booleanValue()) {
                return FlushModeType.AUTO;
            }
            return FlushModeType.COMMIT;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Map<String, Object> getHints() {
        return (Map)this.getDatabaseQueryInternal().getProperty((Object)"eclipselink.query.hints");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NO_PARAMETER_WITH_NAME", (Object[])new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NO_PARAMETER_WITH_INDEX", (Object[])new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(String name) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NO_PARAMETER_WITH_NAME", (Object[])new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(int position) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NO_PARAMETER_WITH_INDEX", (Object[])new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PARAMETER_NILL_NOT_FOUND"));
        }
        return (T)this.getParameterValue(param.getName());
    }

    public Object getParameterValue(String name) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getInternalParameters().containsKey(name)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NO_PARAMETER_WITH_NAME", (Object[])new Object[]{name, this.databaseQuery}));
            }
            if (!this.parameterValues.containsKey(name)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"NO_VALUE_BOUND", (Object[])new Object[]{name}));
            }
            return this.parameterValues.get(name);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getParameterValue(int position) {
        String param = String.valueOf(position);
        if (!this.parameterValues.containsKey(param)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"position_param_not_found", (Object[])new Object[]{position}));
        }
        return this.parameterValues.get(param);
    }

    public Set<Parameter<?>> getParameters() {
        return new HashSet(this.getInternalParameters().values());
    }

    public Set<String> getSupportedHints() {
        return QueryHintsHandler.getSupportedHints();
    }

    public <T> TypedQuery setParameter(Parameter<T> param, T value) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value);
    }

    public TypedQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    public TypedQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (cls.isAssignableFrom(this.getDatabaseQueryInternal().getClass())) {
            return (T)this.getDatabaseQueryInternal();
        }
        throw new PersistenceException("Could not unwrap query to: " + cls);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + String.valueOf(this.databaseQuery) + ")";
    }
}

