/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ClassInstanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.SerializedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingAccessor
extends MetadataAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    protected static final String KEY_DOT_NOTATION = "key.";
    protected static final String VALUE_DOT_NOTATION = "value.";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private ClassAccessor m_classAccessor;
    private DatabaseMapping m_mapping;
    private DatabaseMapping m_overrideMapping;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();
    private String m_attributeType;

    protected MappingAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
        this.initAccess();
    }

    protected MappingAccessor(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof MappingAccessor) {
            MappingAccessor mappingAccessor = (MappingAccessor)objectToCompare;
            return this.valuesMatch(this.getAttributeType(), mappingAccessor.getAttributeType());
        }
        return false;
    }

    public boolean derivesId() {
        return false;
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor aggregatesAccessor) {
        DatabaseMapping aggregatesMapping = aggregatesAccessor.getMapping();
        DatabaseField aggregatesMappingField = aggregatesMapping.getField();
        if (aggregatesAccessor.isId()) {
            this.updatePrimaryKeyField(aggregatesAccessor, overrideField);
        }
        if (overrideName.indexOf(".") > -1) {
            embeddableMapping.addNestedFieldTranslation(overrideName, overrideField, aggregatesMappingField.getName());
        } else {
            embeddableMapping.addFieldTranslation(overrideField, aggregatesMappingField.getName());
        }
    }

    @Override
    protected MetadataAnnotation getAnnotation(String annotation) {
        return this.getAccessibleObject().getAnnotation(annotation, this.getClassAccessor());
    }

    protected Map<String, AssociationOverrideMetadata> getAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        String name;
        HashMap<String, AssociationOverrideMetadata> associationOverridesMap = new HashMap<String, AssociationOverrideMetadata>();
        for (AssociationOverrideMetadata associationOverride : associationOverrides) {
            name = associationOverride.getName();
            String dotNotationName = String.valueOf(this.getAttributeName()) + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAssociationOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_association_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                associationOverridesMap.put(name, this.getDescriptor().getAssociationOverrideFor(dotNotationName));
                continue;
            }
            associationOverridesMap.put(name, associationOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AssociationOverrideMetadata associationOverride : this.getDescriptor().getAssociationOverrides()) {
                String attributeName = name = associationOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || associationOverridesMap.containsKey(attributeName)) continue;
                associationOverridesMap.put(overrideName, associationOverride);
            }
        }
        return associationOverridesMap;
    }

    @Override
    public String getAttributeName() {
        if (this.hasAccessMethods()) {
            return this.getName();
        }
        return this.getAccessibleObject().getAttributeName();
    }

    protected AttributeOverrideMetadata getAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().getAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return this.getDescriptor().getAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName());
        }
        return this.getDescriptor().getAttributeOverrideFor(this.getAttributeName());
    }

    protected Map<String, AttributeOverrideMetadata> getAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        String name;
        HashMap<String, AttributeOverrideMetadata> attributeOverridesMap = new HashMap<String, AttributeOverrideMetadata>();
        for (AttributeOverrideMetadata attributeOverride : attributeOverrides) {
            name = attributeOverride.getName();
            String dotNotationName = String.valueOf(this.getAttributeName()) + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAttributeOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_attribute_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                attributeOverridesMap.put(name, this.getDescriptor().getAttributeOverrideFor(dotNotationName));
                continue;
            }
            attributeOverridesMap.put(name, attributeOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AttributeOverrideMetadata attributeOverride : this.getDescriptor().getAttributeOverrides()) {
                String attributeName = name = attributeOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || attributeOverridesMap.containsKey(attributeName)) continue;
                attributeOverridesMap.put(overrideName, attributeOverride);
            }
        }
        return attributeOverridesMap;
    }

    public String getAttributeType() {
        return this.m_attributeType;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return new ColumnMetadata(this);
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        ColumnMetadata column = this.hasAttributeOverride(loggingCtx) ? this.getAttributeOverride(loggingCtx).getColumn() : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        if (!field.hasTableName()) {
            field.setTable(defaultTable);
        }
        if (this.getProject().useDelimitedIdentifier()) {
            field.getTable().setUseDelimiters(true);
        }
        String defaultName = this.getDefaultAttributeName();
        if (loggingCtx.equals("metadata_default_key_column")) {
            defaultName = String.valueOf(defaultName) + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        this.setFieldName(field, defaultName, loggingCtx);
        this.getDescriptor().addField(field);
        return field;
    }

    protected String getDefaultFetchType() {
        return FetchType.EAGER.name();
    }

    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getReferenceDescriptor().getPrimaryTable();
    }

    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return null;
    }

    public String getGetMethodName() {
        return this.hasAccessMethods() ? this.getAccessMethods().getGetMethodName() : this.getAccessibleObjectName();
    }

    protected List<JoinColumnMetadata> getJoinColumns(List<JoinColumnMetadata> potentialJoinColumns, MetadataDescriptor descriptor) {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.getJoinColumnsAndValidate(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), descriptor);
        }
        return this.getJoinColumnsAndValidate(potentialJoinColumns, descriptor);
    }

    protected List<JoinColumnMetadata> getJoinColumnsAndValidate(List<JoinColumnMetadata> joinColumns, MetadataDescriptor descriptor) {
        if (joinColumns.isEmpty()) {
            if (descriptor.hasCompositePrimaryKey()) {
                for (DatabaseField primaryKeyField : descriptor.getPrimaryKeyFields()) {
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField.getName());
                    joinColumn.setName(primaryKeyField.getName());
                    joinColumn.setProject(descriptor.getProject());
                    joinColumns.add(joinColumn);
                }
            } else {
                JoinColumnMetadata jcm = new JoinColumnMetadata();
                jcm.setProject(descriptor.getProject());
                joinColumns.add(jcm);
            }
        } else {
            for (JoinColumnMetadata joinColumn : joinColumns) {
                String referencedColumnName = joinColumn.getReferencedColumnName();
                if (referencedColumnName == null || this.isVariableOneToOne()) continue;
                DatabaseField referencedField = new DatabaseField();
                this.setFieldName(referencedField, referencedColumnName);
                joinColumn.setReferencedColumnName(descriptor.getPrimaryKeyJoinColumnAssociation(referencedField).getName());
            }
        }
        if (descriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Object)this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumn : joinColumns) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Object)this.getJavaClass());
            }
        }
        return joinColumns;
    }

    public LobMetadata getLob(boolean isForMapKey) {
        return null;
    }

    public DatabaseMapping getMapping() {
        return this.m_overrideMapping == null ? this.m_mapping : this.m_overrideMapping;
    }

    public MetadataDescriptor getOwningDescriptor() {
        return this.getClassAccessor().getOwningDescriptor();
    }

    public List<MetadataDescriptor> getOwningDescriptors() {
        return this.getClassAccessor().getOwningDescriptors();
    }

    public MapKeyMetadata getMapKey() {
        return null;
    }

    public MetadataClass getMapKeyReferenceClass() {
        MetadataClass mapKeyClass;
        if (this.isMappedKeyMapAccessor() && (mapKeyClass = ((MappedKeyMapAccessor)((Object)this)).getMapKeyClass()) != null && !mapKeyClass.equals(Void.TYPE)) {
            return mapKeyClass;
        }
        if (this.isMapAccessor()) {
            MetadataClass referenceClass = this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
            if (referenceClass == null) {
                throw ValidationException.unableToDetermineMapKeyClass((String)this.getAttributeName(), (Object)this.getJavaClass());
            }
            if (this.getClassAccessor().isMappedSuperclass()) {
                try {
                    MetadataHelper.getClassForName(referenceClass.getName(), this.getMetadataFactory().getLoader());
                }
                catch (ValidationException validationException) {
                    return this.getMetadataClass(Void.class);
                }
            }
            return referenceClass;
        }
        return this.getMetadataClass(Void.TYPE);
    }

    public String getMapKeyReferenceClassName() {
        return this.getMapKeyReferenceClass().getName();
    }

    public MetadataClass getRawClass() {
        if (this.hasAttributeType()) {
            return this.getMetadataClass(this.getAttributeType());
        }
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Collection<MappingAccessor> getReferenceAccessors() {
        return this.getReferenceDescriptor().getMappingAccessors();
    }

    public MetadataClass getReferenceClass() {
        return this.getRawClass();
    }

    public MetadataClass getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.getReferenceDescriptor().getPrimaryKeyTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (accessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit((String)this.getReferenceClassName());
        }
        return accessor.getDescriptor();
    }

    public String getSetMethodName() {
        return this.hasAccessMethods() ? this.getAccessMethods().getSetMethodName() : ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return null;
    }

    protected boolean hasAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().hasAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return true;
        }
        return this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName());
    }

    public boolean hasAttributeType() {
        return this.m_attributeType != null;
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert(boolean isForMapKey) {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasEnumerated(boolean isForMapKey) {
        return false;
    }

    protected boolean hasLob(boolean isForMapKey) {
        return false;
    }

    public boolean hasMapKey() {
        return false;
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public boolean hasTemporal(boolean isForMapKey) {
        return false;
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.setEntityMappings(classAccessor.getEntityMappings());
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation, this.getClassAccessor());
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isBasicMap() {
        return false;
    }

    public boolean isDerivedIdClass() {
        return false;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public boolean isDirectEmbeddableCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    protected boolean isEnumerated(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasEnumerated(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasEnumerated(isForMapKey) || EnumeratedMetadata.isValidEnumeratedType(referenceClass);
    }

    public boolean isId() {
        return false;
    }

    protected boolean isLob(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasLob(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasLob(isForMapKey);
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMapAccessor() {
        return this.getAccessibleObject().isSupportedMapClass(this.getRawClass());
    }

    public boolean isMappedKeyMapAccessor() {
        return MappedKeyMapAccessor.class.isAssignableFrom(this.getClass()) && this.isMapAccessor() && !this.hasMapKey();
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    protected boolean isPrimitiveWrapperClass(MetadataClass cls) {
        return cls.extendsClass(Number.class) || cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(String.class) || cls.extendsClass(BigInteger.class) || cls.extendsClass(BigDecimal.class) || cls.extendsClass(Date.class) || cls.extendsClass(Calendar.class);
    }

    @Override
    public boolean isProcessed() {
        return this.m_mapping != null;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isSerialized(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_serialized", this.getJavaClass(), (Object)this.getAnnotatedElement());
            return false;
        }
        return this.isValidSerializedType(referenceClass);
    }

    protected boolean isTemporal(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasTemporal(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasTemporal(isForMapKey) || TemporalMetadata.isValidTemporalType(referenceClass);
    }

    public boolean isTransient() {
        return false;
    }

    protected boolean isValidSerializedType(MetadataClass cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (LobMetadata.isValidLobType(cls)) {
            return false;
        }
        return !TemporalMetadata.isValidTemporalType(cls);
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        throw ValidationException.invalidEmbeddableAttributeForAssociationOverride((Object)this.getJavaClass(), (String)this.getAttributeName(), (String)associationOverride.getName(), (Object)associationOverride.getLocation());
    }

    protected void processAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides, EmbeddableMapping embeddableMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AssociationOverrideMetadata> mergedAssociationOverrides = this.getAssociationOverrides(associationOverrides);
        for (String attributeName : mergedAssociationOverrides.keySet()) {
            AssociationOverrideMetadata associationOverride = mergedAssociationOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getMappingAccessor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAssociationOverrideNotFound((Object)embeddableDescriptor.getJavaClass(), (String)attributeName, (Object)this.getJavaClass(), (String)this.getAttributeName());
            }
            mappingAccessor.processAssociationOverride(associationOverride, embeddableMapping, this.getOwningDescriptor());
        }
    }

    protected void processAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides, AggregateObjectMapping aggregateObjectMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AttributeOverrideMetadata> mergedAttributeOverrides = this.getAttributeOverrides(attributeOverrides);
        for (String attributeName : mergedAttributeOverrides.keySet()) {
            AttributeOverrideMetadata attributeOverride = mergedAttributeOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getMappingAccessor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAttributeOverrideNotFound((Object)embeddableDescriptor.getJavaClass(), (String)attributeName, (Object)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (!mappingAccessor.isBasic()) {
                throw ValidationException.invalidEmbeddableAttributeForAttributeOverride((Object)embeddableDescriptor.getJavaClass(), (String)attributeName, (Object)this.getJavaClass(), (String)this.getAttributeName());
            }
            boolean useDelimitedIdentifier = embeddableDescriptor.getProject() != null ? embeddableDescriptor.getProject().useDelimitedIdentifier() : false;
            DatabaseField overrideField = attributeOverride.getColumn().getDatabaseField();
            if (useDelimitedIdentifier) {
                overrideField.setUseDelimiters(useDelimitedIdentifier);
            } else if (embeddableDescriptor.getProject().getShouldForceFieldNamesToUpperCase() && !overrideField.shouldUseDelimiters()) {
                overrideField.useUpperCaseForComparisons(true);
            }
            this.addFieldNameTranslation((EmbeddableMapping)aggregateObjectMapping, attributeName, overrideField, mappingAccessor);
        }
    }

    protected void processBatchFetch(String batchFetch, ForeignReferenceMapping mapping) {
        if (batchFetch != null) {
            mapping.setBatchFetchType(BatchFetchType.valueOf((String)batchFetch));
        }
    }

    protected void processContainerPolicyAndIndirection(CollectionMapping mapping) {
        if (this.isMappedKeyMapAccessor()) {
            this.processMapKeyClass(mapping, (MappedKeyMapAccessor)((Object)this));
        } else if (this.isMapAccessor()) {
            MapKeyMetadata mapKey = this.getMapKey();
            if (mapKey == null) {
                this.setIndirectionPolicy(mapping, new MapKeyMetadata().process(mapping, this), this.usesIndirection());
            } else {
                this.setIndirectionPolicy(mapping, mapKey.process(mapping, this), this.usesIndirection());
            }
        } else {
            this.setIndirectionPolicy(mapping, null, this.usesIndirection());
        }
    }

    protected void processConvert(DatabaseMapping mapping, String converterName, MetadataClass referenceClass, boolean isForMapKey) {
        if (!converterName.equals(CONVERT_NONE)) {
            if (converterName.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(mapping, referenceClass, isForMapKey);
            } else if (converterName.equals(CONVERT_CLASS_INSTANCE)) {
                new ClassInstanceMetadata().process(mapping, this, referenceClass, isForMapKey);
            } else {
                AbstractConverterMetadata converter = this.getProject().getConverter(converterName);
                if (converter == null) {
                    throw ValidationException.converterNotFound((Object)this.getJavaClass(), (String)converterName, (Object)this.getAnnotatedElement());
                }
                converter.process(mapping, this, referenceClass, isForMapKey);
            }
        }
    }

    protected DirectToFieldMapping processDirectMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        DatabaseField mapKeyField = this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column");
        keyMapping.setField(mapKeyField);
        keyMapping.setIsReadOnly(mapKeyField.isReadOnly());
        keyMapping.setAttributeClassificationName(mappedKeyMapAccessor.getMapKeyClass().getName());
        keyMapping.setDescriptor((ClassDescriptor)this.getDescriptor().getClassDescriptor());
        this.processMappingKeyConverter((DatabaseMapping)keyMapping, mappedKeyMapAccessor.getMapKeyConvert(), mappedKeyMapAccessor.getMapKeyClass());
        return keyMapping;
    }

    protected AggregateObjectMapping processEmbeddableMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        keyMapping.setReferenceClassName(mapKeyClass.getName());
        EmbeddableAccessor mapKeyAccessor = this.getProject().getEmbeddableAccessor(mapKeyClass);
        mapKeyAccessor.getDescriptor().setIsEmbeddable();
        this.processAttributeOverrides(mappedKeyMapAccessor.getMapKeyAttributeOverrides(), keyMapping, mapKeyAccessor.getDescriptor());
        this.processAssociationOverrides(mappedKeyMapAccessor.getMapKeyAssociationOverrides(), (EmbeddableMapping)keyMapping, mapKeyAccessor.getDescriptor());
        keyMapping.setDescriptor((ClassDescriptor)this.getDescriptor().getClassDescriptor());
        return keyMapping;
    }

    protected OneToOneMapping processEntityMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        String mapKeyClassName = mappedKeyMapAccessor.getMapKeyClass().getName();
        OneToOneMapping keyMapping = new OneToOneMapping();
        keyMapping.setReferenceClassName(mapKeyClassName);
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor((ClassDescriptor)this.getDescriptor().getClassDescriptor());
        EntityAccessor mapKeyAccessor = this.getProject().getEntityAccessor(mapKeyClassName);
        MetadataDescriptor mapKeyClassDescriptor = mapKeyAccessor.getDescriptor();
        String defaultFKFieldName = String.valueOf(this.getAttributeName()) + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        this.processOneToOneForeignKeyRelationship(keyMapping, this.getJoinColumns(mappedKeyMapAccessor.getMapKeyJoinColumns(), mapKeyClassDescriptor), mapKeyClassDescriptor, defaultFKFieldName, this.getDefaultTableForEntityMapKey());
        return keyMapping;
    }

    protected void processEnumerated(EnumeratedMetadata enumerated, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (enumerated == null) {
            enumerated = new EnumeratedMetadata(this);
        }
        enumerated.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processJoinFetch(String joinFetch, ForeignReferenceMapping mapping) {
        if (joinFetch == null) {
            mapping.setJoinFetch(0);
        } else if (joinFetch.equals(JoinFetchType.INNER.name())) {
            mapping.setJoinFetch(1);
        } else {
            mapping.setJoinFetch(2);
        }
    }

    protected void processJPAConverters(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isEnumerated(referenceClass, isForMapKey)) {
            this.processEnumerated(this.getEnumerated(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isLob(referenceClass, isForMapKey)) {
            this.processLob(this.getLob(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isTemporal(referenceClass, isForMapKey)) {
            this.processTemporal(this.getTemporal(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isSerialized(referenceClass, isForMapKey)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        }
    }

    protected void processLob(LobMetadata lob, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        lob.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processMapKeyClass(CollectionMapping mapping, MappedKeyMapAccessor mappedKeyMapAccessor) {
        Class<Hashtable> containerClass;
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        Object keyMapping = this.getProject().hasEntity(mapKeyClass) ? this.processEntityMapKeyClass(mappedKeyMapAccessor) : (this.getProject().hasEmbeddable(mapKeyClass) ? this.processEmbeddableMapKeyClass(mappedKeyMapAccessor) : this.processDirectMapKeyClass(mappedKeyMapAccessor));
        if (this.usesIndirection()) {
            containerClass = ClassConstants.IndirectMap_Class;
            mapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else {
            containerClass = Hashtable.class;
            mapping.dontUseIndirection();
        }
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(containerClass);
        policy.setKeyMapping((MapKeyMapping)keyMapping);
        policy.setValueMapping((MapComponentMapping)mapping);
        mapping.setContainerPolicy((ContainerPolicy)policy);
    }

    protected void processMappingConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass, boolean isForMapKey) {
        if (convertValue != null && !convertValue.equals(CONVERT_NONE)) {
            this.processConvert(mapping, convertValue, referenceClass, isForMapKey);
        }
        this.processJPAConverters(mapping, referenceClass, isForMapKey);
    }

    protected void processMappingKeyConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass) {
        this.processMappingConverter(mapping, convertValue, referenceClass, true);
    }

    protected void processMappingValueConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass) {
        this.processMappingConverter(mapping, convertValue, referenceClass, false);
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping, List<JoinColumnMetadata> joinColumns, MetadataDescriptor referenceDescriptor, String defaultFKFieldName, DatabaseTable defaultFKTable) {
        DatabaseField pkField;
        boolean allReadOnly = true;
        HashMap<DatabaseField, DatabaseField> fields = new HashMap<DatabaseField, DatabaseField>();
        for (JoinColumnMetadata joinColumn : joinColumns) {
            pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), referenceDescriptor, "metadata_default_pk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, defaultFKFieldName, "metadata_default_fk_column");
            if (!fkField.hasTableName()) {
                fkField.setTable(defaultFKTable);
            }
            fields.put(fkField, pkField);
            boolean bl = allReadOnly = allReadOnly && fkField.isReadOnly();
        }
        for (DatabaseField fkField : fields.keySet()) {
            pkField = (DatabaseField)fields.get(fkField);
            if (allReadOnly || !fkField.isReadOnly()) {
                mapping.addForeignKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetForeignKeyField(pkField, fkField);
        }
        mapping.setIsReadOnly(allReadOnly);
    }

    protected void processProperties(DatabaseMapping mapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata property : this.getProperties()) {
                this.processProperty(mapping, property);
            }
        } else {
            Object property;
            MetadataAnnotation properties = this.getAnnotation(Properties.class);
            if (properties != null) {
                Object[] objectArray = (Object[])properties.getAttribute("value");
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    property = objectArray[n2];
                    this.processProperty(mapping, new PropertyMetadata((MetadataAnnotation)property, this));
                    ++n2;
                }
            }
            if ((property = this.getAnnotation(Property.class)) != null) {
                this.processProperty(mapping, new PropertyMetadata((MetadataAnnotation)property, this));
            }
        }
    }

    protected void processProperty(DatabaseMapping mapping, PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            mapping.getProperties().put(property.getName(), property.getConvertedValue());
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        new SerializedMetadata(this).process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, MetadataClass classification, boolean isForMapKey) {
        new SerializedMetadata(this).process(mapping, this, referenceClass, classification, isForMapKey);
    }

    protected void processTemporal(TemporalMetadata temporal, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (temporal == null) {
            throw ValidationException.noTemporalTypeSpecified((String)this.getAttributeName(), (Object)this.getJavaClass());
        }
        temporal.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.usesPropertyAccess() || this.usesVirtualAccess()) {
            if (this.usesVirtualAccess()) {
                mapping.setAttributeAccessor((AttributeAccessor)new VirtualAttributeAccessor());
            }
            mapping.setGetMethodName(this.getGetMethodName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setAttributeType(String attributeType) {
        this.m_attributeType = attributeType;
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    protected void setIndirectionPolicy(CollectionMapping mapping, String mapKey, boolean usesIndirection) {
        MetadataClass rawClass = this.getRawClass();
        if (usesIndirection) {
            if (rawClass.equals(Map.class)) {
                if (mapping.isDirectMapMapping()) {
                    ((DirectMapMapping)mapping).useTransparentMap();
                } else {
                    mapping.useTransparentMap(mapKey);
                }
            } else if (rawClass.equals(List.class)) {
                mapping.useTransparentList();
            } else if (rawClass.equals(Collection.class)) {
                mapping.useTransparentCollection();
            } else if (rawClass.equals(Set.class)) {
                mapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), rawClass);
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass.equals(Map.class)) {
                if (mapping.isDirectMapMapping()) {
                    ((DirectMapMapping)mapping).useMapClass(Hashtable.class);
                } else {
                    mapping.useMapClass(Hashtable.class, mapKey);
                }
            } else if (rawClass.equals(Set.class)) {
                mapping.useCollectionClass(HashSet.class);
            } else if (rawClass.equals(List.class)) {
                mapping.useCollectionClass(Vector.class);
            } else if (rawClass.equals(Collection.class)) {
                mapping.setContainerPolicy((ContainerPolicy)new CollectionContainerPolicy(Vector.class));
            } else if (mapKey == null || mapKey.equals("")) {
                if (rawClass.isList()) {
                    mapping.useListClassName(rawClass.getName());
                } else {
                    mapping.useCollectionClassName(rawClass.getName());
                }
            } else {
                mapping.useMapClassName(rawClass.getName(), mapKey);
            }
        }
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.processProperties(mapping);
        this.getDescriptor().getClassDescriptor().addMapping(mapping);
        this.m_mapping = mapping;
    }

    protected void setOverrideMapping(DatabaseMapping mapping) {
        this.m_overrideMapping = mapping;
    }

    public String toString() {
        return this.getAnnotatedElementName();
    }

    protected void updatePrimaryKeyField(MappingAccessor idAccessor, DatabaseField overrideField) {
        this.getOwningDescriptor().removePrimaryKeyField(idAccessor.getMapping().getField());
        this.getOwningDescriptor().addPrimaryKeyField(overrideField, idAccessor);
    }

    protected boolean usesIndirection() {
        return false;
    }

    public boolean usesPropertyAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("PROPERTY");
        }
        return this.hasAccessMethods() ? !this.usesVirtualAccess() : this.m_classAccessor.usesPropertyAccess();
    }

    public boolean usesVirtualAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("VIRTUAL");
        }
        return this.m_classAccessor.usesVirtualAccess();
    }

    public boolean usesFieldAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("FIELD");
        }
        return this.m_classAccessor.usesFieldAccess();
    }
}

