/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.TableStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWSequencingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWTableGenerationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public final class MWRelationalProject
extends MWProject {
    private MWDatabase tableRepository;
    private MWSequencingPolicy sequencingPolicy;
    private volatile String tableCreatorSourceClassName;
    public static final String TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY = "tableCreatorSourceClassName";
    private volatile String tableCreatorSourceDirectoryName;
    public static final String TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY = "tableCreatorSourceDirectoryName";
    private MWTableGenerationPolicy tableGenerationPolicy;
    private volatile boolean generateDeprecatedDirectMappings;
    public static final String GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY = "generateDeprecatedDirectMappings";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalProject.class);
        descriptor.getInheritancePolicy().setParentClass(MWProject.class);
        XMLCompositeObjectMapping databaseMapping = new XMLCompositeObjectMapping();
        databaseMapping.setAttributeName("tableRepository");
        databaseMapping.setReferenceClass(MWDatabase.class);
        databaseMapping.setXPath("table-repository");
        descriptor.addMapping((DatabaseMapping)databaseMapping);
        XMLCompositeObjectMapping sequencingPolicyMapping = new XMLCompositeObjectMapping();
        sequencingPolicyMapping.setAttributeName("sequencingPolicy");
        sequencingPolicyMapping.setReferenceClass(MWSequencingPolicy.class);
        sequencingPolicyMapping.setXPath("sequencing");
        descriptor.addMapping((DatabaseMapping)sequencingPolicyMapping);
        XMLDirectMapping tableCreatorSourceClassNameMapping = new XMLDirectMapping();
        tableCreatorSourceClassNameMapping.setAttributeName(TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY);
        tableCreatorSourceClassNameMapping.setXPath("table-creator/class/text()");
        tableCreatorSourceClassNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)tableCreatorSourceClassNameMapping);
        XMLDirectMapping tableCreatorSourceDirectoryNameMapping = new XMLDirectMapping();
        tableCreatorSourceDirectoryNameMapping.setAttributeName(TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY);
        tableCreatorSourceDirectoryNameMapping.setSetMethodName("setTableCreatorSourceDirectoryNameForTopLink");
        tableCreatorSourceDirectoryNameMapping.setGetMethodName("getTableCreatorSourceDirectoryNameForTopLink");
        tableCreatorSourceDirectoryNameMapping.setXPath("table-creator/directory/text()");
        tableCreatorSourceDirectoryNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)tableCreatorSourceDirectoryNameMapping);
        XMLCompositeObjectMapping tableGenerationPolicyMapping = new XMLCompositeObjectMapping();
        tableGenerationPolicyMapping.setAttributeName("tableGenerationPolicy");
        tableGenerationPolicyMapping.setReferenceClass(MWTableGenerationPolicy.class);
        tableGenerationPolicyMapping.setXPath("table-generation");
        descriptor.addMapping((DatabaseMapping)tableGenerationPolicyMapping);
        XMLDirectMapping generateDeprecatedDirectMappingsMapping = new XMLDirectMapping();
        generateDeprecatedDirectMappingsMapping.setAttributeName(GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY);
        generateDeprecatedDirectMappingsMapping.setXPath("generate-deprecated-direct-mappings/text()");
        generateDeprecatedDirectMappingsMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)generateDeprecatedDirectMappingsMapping);
        return descriptor;
    }

    private MWRelationalProject() {
    }

    public MWRelationalProject(String name, SPIManager spiManager, DatabasePlatform databasePlatform) {
        super(name, spiManager);
        this.tableRepository = new MWDatabase(this, databasePlatform);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.sequencingPolicy = new MWSequencingPolicy(this);
        this.tableCreatorSourceClassName = "";
        this.tableCreatorSourceDirectoryName = "";
        this.tableGenerationPolicy = new MWTableGenerationPolicy(this);
        this.generateDeprecatedDirectMappings = false;
    }

    protected MWProjectDefaultsPolicy buildDefaultsPolicy() {
        return new MWRelationalProjectDefaultsPolicy(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.tableRepository);
        children.add(this.sequencingPolicy);
        children.add(this.tableGenerationPolicy);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        Iterator descriptors = this.descriptors();
        while (descriptors.hasNext()) {
            ((MWRelationalDescriptor)descriptors.next()).notifyExpressionsToRecalculateQueryables();
        }
    }

    public MWModel getMetaDataRepository() {
        return this.getTableRepository();
    }

    public MWDatabase getTableRepository() {
        return this.tableRepository;
    }

    public MWSequencingPolicy getSequencingPolicy() {
        return this.sequencingPolicy;
    }

    public MWTableGenerationPolicy getTableGenerationPolicy() {
        return this.tableGenerationPolicy;
    }

    public String getTableCreatorSourceClassName() {
        return this.tableCreatorSourceClassName;
    }

    public void setTableCreatorSourceClassName(String tableCreatorSourceClassName) {
        String old = this.tableCreatorSourceClassName;
        this.tableCreatorSourceClassName = tableCreatorSourceClassName;
        this.firePropertyChanged(TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY, old, tableCreatorSourceClassName);
    }

    public String getTableCreatorSourceDirectoryName() {
        return this.tableCreatorSourceDirectoryName;
    }

    public void setTableCreatorSourceDirectoryName(String tableCreatorSourceDirectoryName) {
        if (tableCreatorSourceDirectoryName == null) {
            throw new NullPointerException();
        }
        String old = this.tableCreatorSourceDirectoryName;
        this.tableCreatorSourceDirectoryName = tableCreatorSourceDirectoryName;
        this.firePropertyChanged(TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY, old, tableCreatorSourceDirectoryName);
    }

    protected MWDescriptor createDescriptorForType(MWClass type) throws InterfaceDescriptorCreationException {
        if (type.isInterface()) {
            return new MWInterfaceDescriptor(this, type, type.fullName());
        }
        return new MWTableDescriptor(this, type, type.fullName());
    }

    public MWAggregateDescriptor addAggregateDescriptorForType(MWClass type) {
        MWAggregateDescriptor descriptor = new MWAggregateDescriptor(this, type, type.fullName());
        this.addDescriptor(descriptor);
        return descriptor;
    }

    public Iterator descriptorsThatImplement(final MWRelationalDescriptor descriptor) {
        return new FilteringIterator(this.tableDescriptors()){

            protected boolean accept(Object next) {
                return ((MWDescriptor)next).getMWClass().allInterfacesContains(descriptor.getMWClass());
            }
        };
    }

    public Iterator tableDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object next) {
                return ((MWRelationalDescriptor)next).isTableDescriptor();
            }
        };
    }

    public Iterator aggregateDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object next) {
                return ((MWRelationalDescriptor)next).isAggregateDescriptor();
            }
        };
    }

    public Iterator interfaceDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object next) {
                return ((MWRelationalDescriptor)next).isInterfaceDescriptor();
            }
        };
    }

    public Iterator allWriteableManyToManyMappings() {
        return new FilteringIterator(this.allWriteableMappings()){

            protected boolean accept(Object next) {
                return (MWMapping)next instanceof MWManyToManyMapping;
            }
        };
    }

    public Iterator interfaceDescriptorsThatImplement(final MWMappingDescriptor descriptor) {
        return new FilteringIterator(this.interfaceDescriptors()){

            protected boolean accept(Object next) {
                return ((MWInterfaceDescriptor)next).hasImplementor(descriptor);
            }
        };
    }

    public boolean canAutomapDescriptors() {
        return this.getDatabase().tablesSize() > 0;
    }

    protected void matchClassesAndMetaData(Collection automapDescriptors) {
        super.matchClassesAndMetaData(automapDescriptors);
        StringHolder[] descriptorHolders = this.buildMetaDataDescriptorStringHolders(automapDescriptors);
        StringHolder[] tableHolders = this.buildTableStringHolders();
        PartialStringComparatorEngine.StringHolderPair[] pairs = CLASS_META_DATA_NAME_COMPARATOR_ENGINE.match(descriptorHolders, tableHolders);
        int i = pairs.length;
        while (i-- > 0) {
            PartialStringComparatorEngine.StringHolderPair pair = pairs[i];
            DescriptorStringHolder descriptorHolder = (DescriptorStringHolder)pair.getStringHolder1();
            TableStringHolder tableHolder = (TableStringHolder)pair.getStringHolder2();
            if (descriptorHolder == null || tableHolder == null || !(pair.getScore() > 0.45)) continue;
            ((MWTableDescriptor)descriptorHolder.getDescriptor()).setPrimaryTable(tableHolder.getTable());
        }
    }

    private TableStringHolder[] buildTableStringHolders() {
        ArrayList unassignedTables = new ArrayList(this.getDatabase().tablesSize());
        CollectionTools.addAll(unassignedTables, this.getDatabase().tables());
        unassignedTables.removeAll(this.assignedTables());
        return TableStringHolder.buildHolders(unassignedTables);
    }

    private Set assignedTables() {
        HashSet<MWTable> tables = new HashSet<MWTable>(this.descriptorsSize());
        Iterator stream = this.tableDescriptors();
        while (stream.hasNext()) {
            tables.add(((MWTableDescriptor)stream.next()).getPrimaryTable());
        }
        return tables;
    }

    public void exportTableCreatorSource() {
        File tableCreatorSourceFile = this.tableCreatorSourceFile();
        tableCreatorSourceFile.getParentFile().mkdirs();
        TableCreator tableCreator = new TableCreator((List)CollectionTools.vector(this.getDatabase().runtimeTableDefinitions()));
        tableCreator.setName(this.getName());
        TableCreatorClassGenerator generator = new TableCreatorClassGenerator(tableCreator);
        generator.setClassName(this.tableCreatorSourceClassName);
        generator.setPackageName(this.tableCreatorSourcePackageName());
        generator.setOutputFileName(tableCreatorSourceFile.getAbsolutePath());
        generator.generate();
    }

    public File tableCreatorSourceFile() {
        return new File(this.absoluteTableCreatorSourceDirectory(), Classpath.convertToJavaFileName(this.tableCreatorSourceClassName));
    }

    public File absoluteTableCreatorSourceDirectory() {
        File dir = new File(this.tableCreatorSourceDirectoryName);
        if (!dir.isAbsolute()) {
            dir = new File(this.getSaveDirectory(), this.tableCreatorSourceDirectoryName);
        }
        return dir;
    }

    public String tableCreatorSourcePackageName() {
        return ClassTools.packageNameForClassNamed(this.tableCreatorSourceClassName);
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor descriptor) {
        this.recalculateAggregatePathsToColumn(descriptor, null);
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor descriptor, MWAggregateMapping currentMapping) {
        Iterator stream = this.aggregateMappingsWithReferenceDescriptor(descriptor);
        while (stream.hasNext()) {
            MWAggregateMapping mapping = (MWAggregateMapping)stream.next();
            if (mapping == currentMapping) continue;
            mapping.updatePathsToFields();
            this.recalculateAggregatePathsToColumn(mapping.getParentDescriptor(), mapping);
        }
    }

    private Iterator aggregateMappingsWithReferenceDescriptor(final MWMappingDescriptor descriptor) {
        return new FilteringIterator(this.allAggregateMappings()){

            protected boolean accept(Object next) {
                return ((MWAggregateMapping)next).getReferenceDescriptor() == descriptor;
            }
        };
    }

    private Iterator allAggregateMappings() {
        return new FilteringIterator(this.allMappings()){

            protected boolean accept(Object next) {
                return next instanceof MWAggregateMapping;
            }
        };
    }

    public boolean isGenerateDeprecatedDirectMappings() {
        return this.generateDeprecatedDirectMappings;
    }

    public void setGenerateDeprecatedDirectMappings(boolean newValue) {
        boolean oldValue = this.generateDeprecatedDirectMappings;
        this.generateDeprecatedDirectMappings = newValue;
        this.firePropertyChanged(GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY, oldValue, newValue);
    }

    protected DatasourceLogin buildRuntimeLogin() {
        DatabaseLogin login = this.getDatabase().buildDeploymentRuntimeDatabaseLogin();
        this.getSequencingPolicy().adjustRuntimeLogin(login);
        return login;
    }

    private String getTableCreatorSourceDirectoryNameForTopLink() {
        return this.tableCreatorSourceDirectoryName.replace('\\', '/');
    }

    private void setTableCreatorSourceDirectoryNameForTopLink(String dirName) {
        this.tableCreatorSourceDirectoryName = new File(dirName).getPath();
    }
}

