/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Content;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.EmptyContent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitComplexTypeDefinition
extends ExplicitSchemaTypeDefinition
implements MWComplexTypeDefinition {
    private volatile ReferencedSchemaTypeDefinition baseType;
    private volatile String derivationMethod;
    private volatile boolean abstractFlag;
    private Map attributes;
    private volatile Content content;

    protected ExplicitComplexTypeDefinition() {
    }

    ExplicitComplexTypeDefinition(MWModel parent, String name) {
        super(parent, name);
    }

    ExplicitComplexTypeDefinition(MWModel parent, String name, String namespace) {
        super(parent, name, namespace);
    }

    ExplicitComplexTypeDefinition(MWModel parent, String name, String namespace, boolean builtIn) {
        super(parent, name, namespace, builtIn);
    }

    protected void initialize() {
        super.initialize();
        this.attributes = new Hashtable();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.baseType = ReferencedSchemaTypeDefinition.urType(this);
        this.content = new EmptyContent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.baseType);
        Map map = this.attributes;
        synchronized (map) {
            children.addAll(this.attributes.values());
        }
        if (this.content != null) {
            children.add(this.content);
        }
    }

    public MWAttributeDeclaration attribute(String namespaceUrl, String name) {
        Iterator stream = this.attributes();
        while (stream.hasNext()) {
            MWAttributeDeclaration attribute = (MWAttributeDeclaration)stream.next();
            if (!namespaceUrl.equals(attribute.getNamespaceUrl()) || !name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    Iterator attributes() {
        return this.attributes.values().iterator();
    }

    private Iterator attributeNames() {
        return this.attributes.keySet().iterator();
    }

    private void addAttribute(String attributeName, MWAttributeDeclaration attribute) {
        this.attributes.put(attributeName, attribute);
    }

    private ReferencedAttributeDeclaration addReferencedAttribute(String attributeName, String attributeNamespace) {
        ReferencedAttributeDeclaration attributeRef = new ReferencedAttributeDeclaration(this, attributeName, attributeNamespace);
        this.addAttribute(attributeName, attributeRef);
        return attributeRef;
    }

    private ExplicitAttributeDeclaration addExplicitAttribute(String attributeName) {
        ExplicitAttributeDeclaration attributeDef = new ExplicitAttributeDeclaration(this, attributeName);
        this.addAttribute(attributeName, attributeDef);
        return attributeDef;
    }

    private void removeAttribute(String attributeName) {
        MWAttributeDeclaration attribute = (MWAttributeDeclaration)this.attributes.remove(attributeName);
        this.getProject().nodeRemoved(attribute);
    }

    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public int totalElementCount() {
        return this.content.totalElementCount();
    }

    public int attributeCount() {
        return this.attributes.size();
    }

    public MWSchemaTypeDefinition getBaseType() {
        return this.baseType;
    }

    public boolean isComplex() {
        return true;
    }

    public Iterator baseBuiltInTypes() {
        if (this.builtIn) {
            return NullIterator.instance();
        }
        return this.baseType.baseBuiltInTypes();
    }

    public boolean containsText() {
        return this.content.hasTextContent();
    }

    public boolean containsWildcard() {
        return this.content.containsWildcard();
    }

    public int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        if (element1.isDescendantOf(this.baseType)) {
            if (element2.isDescendantOf(this.baseType)) {
                return this.baseType.compareSchemaOrder(element1, element2);
            }
            return -1;
        }
        if (element2.isDescendantOf(this.baseType)) {
            return 1;
        }
        return this.content.compareSchemaOrder(element1, element2);
    }

    public String componentTypeName() {
        return "complexType";
    }

    public void addDirectlyOwnedComponentsTo(Collection directlyOwnedComponents) {
        directlyOwnedComponents.addAll(this.attributes.values());
        this.content.addDirectlyOwnedComponentsTo(directlyOwnedComponents);
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(this.content.structuralComponents(), this.attributes());
    }

    public Iterator descriptorContextComponents() {
        return this.content.descriptorContextComponents();
    }

    public Iterator xpathComponents() {
        return new CompositeIterator(this.attributes(), this.content.xpathComponents());
    }

    public MWAttributeDeclaration nestedAttribute(String namespaceUrl, String attributeName) {
        return this.attribute(namespaceUrl, attributeName);
    }

    public MWElementDeclaration nestedElement(String namespaceUrl, String elementName) {
        return this.content.nestedElement(namespaceUrl, elementName);
    }

    protected void reloadInternal(XSObject xsObject) {
        super.reloadInternal(xsObject);
        XSComplexTypeDecl complexTypeDecl = (XSComplexTypeDecl)xsObject;
        this.reloadBaseType(complexTypeDecl.getBaseType());
        this.abstractFlag = complexTypeDecl.getAbstract();
        this.derivationMethod = complexTypeDecl.getDerivationMethod() == 2 ? "restriction" : "extension";
        this.reloadContent(complexTypeDecl);
        this.reloadAttributes(complexTypeDecl.getAttributeUses());
    }

    private void reloadBaseType(XSTypeDefinition complexTypeDecl) {
        ReferencedSchemaTypeDefinition oldBaseType = this.baseType;
        String baseTypeName = null;
        String baseTypeNamespace = null;
        baseTypeName = complexTypeDecl.getName();
        baseTypeNamespace = complexTypeDecl.getNamespace();
        this.baseType = ReferencedSchemaTypeDefinition.reloadedReferencedType(this, oldBaseType, baseTypeName, baseTypeNamespace, complexTypeDecl);
        if (oldBaseType != this.baseType && oldBaseType != null) {
            this.getProject().nodeRemoved(oldBaseType);
        }
    }

    private void reloadContent(XSComplexTypeDecl complexTypeDecl) {
        Content oldContent = this.content;
        this.content = Content.reloadedContent(this, this.content, complexTypeDecl);
        if (oldContent != this.content && oldContent != null) {
            this.getProject().nodeRemoved(oldContent);
        }
    }

    private void reloadAttributes(XSObjectList complexTypeAttributes) {
        Collection removedAttributeNames = CollectionTools.collection(this.attributeNames());
        for (int i = complexTypeAttributes.getLength() - 1; i >= 0; --i) {
            MWAttributeDeclaration attribute = this.reloadAttribute((XSAttributeUseImpl)complexTypeAttributes.item(i));
            removedAttributeNames.remove(attribute.getName());
        }
        Iterator stream = removedAttributeNames.iterator();
        while (stream.hasNext()) {
            this.removeAttribute((String)stream.next());
        }
    }

    private MWAttributeDeclaration reloadAttribute(XSAttributeUseImpl attributeUse) {
        String attributeName = attributeUse.getAttrDeclaration().getName();
        MWAttributeDeclaration attribute = (MWAttributeDeclaration)this.attributes.get(attributeName);
        if (attributeUse.getAttrDeclaration().getScope() == 1) {
            if (attribute == null || !attribute.isReference()) {
                attribute = this.addReferencedAttribute(attributeName, attributeUse.getAttrDeclaration().getNamespace());
            }
        } else if (attribute == null || attribute.isReference()) {
            attribute = this.addExplicitAttribute(attributeName);
        }
        if (attribute.isReference()) {
            attribute.reload((XSObject)attributeUse.getAttrDeclaration());
        } else {
            attribute.reload((XSObject)attributeUse);
        }
        return attribute;
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.baseType.resolveReferences();
        this.content.resolveReferences();
        Iterator stream = this.attributes.values().iterator();
        while (stream.hasNext()) {
            ((MWAttributeDeclaration)stream.next()).resolveReferences();
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ExplicitComplexTypeDefinition.class);
        descriptor.getInheritancePolicy().setParentClass(ExplicitSchemaTypeDefinition.class);
        descriptor.addDirectMapping("abstractFlag", "abstract/text()");
        ObjectTypeConverter derivationMethodConverter = new ObjectTypeConverter();
        derivationMethodConverter.addConversionValue((Object)"restriction", (Object)"restriction");
        derivationMethodConverter.addConversionValue((Object)"extension", (Object)"extension");
        XMLDirectMapping derivationMethodMapping = new XMLDirectMapping();
        derivationMethodMapping.setAttributeName("derivationMethod");
        derivationMethodMapping.setXPath("derivation-method/text()");
        derivationMethodMapping.setConverter((Converter)derivationMethodConverter);
        descriptor.addMapping((DatabaseMapping)derivationMethodMapping);
        XMLCompositeObjectMapping baseTypeMapping = new XMLCompositeObjectMapping();
        baseTypeMapping.setAttributeName("baseType");
        baseTypeMapping.setReferenceClass(ReferencedSchemaTypeDefinition.class);
        baseTypeMapping.setXPath("base-type");
        descriptor.addMapping((DatabaseMapping)baseTypeMapping);
        XMLCompositeCollectionMapping attributeDeclarationsMapping = new XMLCompositeCollectionMapping();
        attributeDeclarationsMapping.setAttributeName("attributes");
        attributeDeclarationsMapping.setGetMethodName("getAttributesForToplink");
        attributeDeclarationsMapping.setSetMethodName("setAttributesForToplink");
        attributeDeclarationsMapping.setXPath("attributes/attribute");
        attributeDeclarationsMapping.setReferenceClass(AbstractNamedSchemaComponent.class);
        attributeDeclarationsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)attributeDeclarationsMapping);
        XMLCompositeObjectMapping contentMapping = new XMLCompositeObjectMapping();
        contentMapping.setAttributeName("content");
        contentMapping.setXPath("content");
        contentMapping.setReferenceClass(Content.class);
        descriptor.addMapping((DatabaseMapping)contentMapping);
        return descriptor;
    }

    private Map getAttributesForToplink() {
        return new TreeMap(this.attributes);
    }

    private void setAttributesForToplink(Map map) {
        HashMap<String, AbstractNamedSchemaComponent> elementMap = new HashMap<String, AbstractNamedSchemaComponent>();
        for (AbstractNamedSchemaComponent element : map.values()) {
            elementMap.put(element.getName(), element);
        }
        this.attributes = elementMap;
    }
}

