/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class ListValueModelWrapper
extends AbstractModel
implements ListValueModel {
    protected ListValueModel listHolder;
    protected ListChangeListener listChangeListener;

    protected ListValueModelWrapper(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
    }

    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListValueModelWrapper.this.listChanged(e);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public synchronized void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListChangeListeners("value")) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "value" && this.hasNoListChangeListeners("value")) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "value" && this.hasNoListChangeListeners("value")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.listHolder);
    }

    protected abstract void itemsAdded(ListChangeEvent var1);

    protected abstract void itemsRemoved(ListChangeEvent var1);

    protected abstract void itemsReplaced(ListChangeEvent var1);

    protected abstract void listChanged(ListChangeEvent var1);
}

