/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeDirectMapping
extends AbstractDirectMapping
implements MapKeyMapping {
    protected transient Class attributeClassification;
    protected transient String attributeClassificationName;
    protected transient Class attributeObjectClassification;
    protected Converter converter;
    protected String converterClassName;
    protected DatabaseTable keyTableForMapKey = null;
    protected boolean isInsertable = true;
    protected boolean isUpdatable = true;
    protected Boolean isMutable;
    protected transient Object nullValue;
    protected String fieldClassificationClassName = null;

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        if (!this.isReadOnly() && this.isUpdatable()) {
            joinRow.put(this.getField(), (Object)null);
        }
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        if (selectionQuery.isObjectLevelReadQuery()) {
            ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(this.getField()));
        } else if (selectionQuery.isDataReadQuery()) {
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getField(this.getField()));
        }
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, Map deletedObjects) {
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        this.buildClone(clone, null, backup, unitOfWork);
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession) {
        this.buildCloneValue(original, clone, cloningSession);
    }

    protected Object buildCloneValue(Object attributeValue, AbstractSession session) {
        Object newAttributeValue = attributeValue;
        if (this.isMutable() && attributeValue != null) {
            if (attributeValue instanceof byte[]) {
                int length = ((byte[])attributeValue).length;
                byte[] arrayCopy = new byte[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof Byte[]) {
                int length = ((Byte[])attributeValue).length;
                Byte[] arrayCopy = new Byte[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof char[]) {
                int length = ((char[])attributeValue).length;
                char[] arrayCopy = new char[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof Character[]) {
                int length = ((Character[])attributeValue).length;
                Character[] arrayCopy = new Character[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else {
                newAttributeValue = attributeValue instanceof Date ? ((Date)attributeValue).clone() : (attributeValue instanceof Calendar ? ((Calendar)attributeValue).clone() : this.getAttributeValue(this.getFieldValue(attributeValue, session), session));
            }
        }
        return newAttributeValue;
    }

    public void buildCloneValue(Object original, Object clone, AbstractSession session) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        attributeValue = this.buildCloneValue(attributeValue, session);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), null, owner);
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        this.buildCloneValue(original, copy, group.getSession());
    }

    @Override
    public Object buildElementClone(Object attributeValue, Object parent, CacheKey cacheKey, AbstractSession cloningSession, boolean isExisting) {
        return this.buildCloneValue(attributeValue, cloningSession);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        DataReadQuery query = new DataReadQuery();
        query.setSQLStatement(new SQLSelectStatement());
        query.setContainerPolicy(containerPolicy);
        return query;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, boolean getAttributeValueFromObject, Set cascadeErrors) {
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        if (owner.isNew()) {
            return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), null, owner);
        }
        if (!this.compareObjects(backUp, clone, session)) {
            Object oldValue = null;
            if (backUp != null && clone != backUp) {
                oldValue = this.getAttributeValueFromObject(backUp);
            }
            return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), oldValue, owner);
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstValue = this.getAttributeValueFromObject(firstObject);
        Object secondValue = this.getAttributeValueFromObject(secondObject);
        return this.compareObjectValues(firstValue, secondValue, session);
    }

    protected boolean compareObjectValues(Object firstValue, Object secondValue, AbstractSession session) {
        if (firstValue == secondValue) {
            return true;
        }
        if (firstValue != null && secondValue != null && firstValue.equals(secondValue)) {
            return true;
        }
        if ((firstValue = this.getFieldValue(firstValue, session)) == (secondValue = this.getFieldValue(secondValue, session))) {
            return true;
        }
        if (firstValue == null || secondValue == null) {
            return false;
        }
        if (firstValue.equals(secondValue)) {
            return true;
        }
        return Helper.comparePotentialArrays(firstValue, secondValue);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getAttributeClassificationName() != null) {
            Class attributeClass;
            block26: {
                attributeClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getAttributeClassificationName(), true, classLoader));
                            break block26;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAttributeClassificationName(), exception.getException());
                        }
                    }
                    attributeClass = PrivilegedAccessHelper.getClassForName(this.getAttributeClassificationName(), true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAttributeClassificationName(), exc);
                }
            }
            this.setAttributeClassification(attributeClass);
        }
        if (this.converter != null) {
            if (this.converter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.converter).convertClassNamesToClasses(classLoader);
            } else if (this.converter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.converter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.converterClassName != null) {
            Converter converter;
            block27: {
                try {
                    Class converterClass;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            converterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.converterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(converterClass));
                            break block27;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception.getException());
                        }
                    }
                    converterClass = PrivilegedAccessHelper.getClassForName(this.converterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(converterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, e);
                }
            }
            this.setConverter(converter);
        }
        if (this.fieldClassificationClassName != null) {
            Class fieldClassification;
            block28: {
                fieldClassification = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            fieldClassification = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationClassName, true, classLoader));
                            break block28;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception.getException());
                        }
                    }
                    fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationClassName, e);
                }
            }
            this.setFieldClassification(fieldClassification);
        }
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord dbRow, JoinedAttributeManager joinManger, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.createMapComponentFromRow(dbRow, query, parentCacheKey, session, isTargetProtected);
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        Object key = dbRow.get(this.getField());
        key = this.getAttributeValue(key, session);
        return key;
    }

    @Override
    public List<Object> createMapComponentsFromSerializableKeyInfo(Object[] keyInfo, AbstractSession session) {
        return Arrays.asList(keyInfo);
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        DirectQueryKey queryKey = new DirectQueryKey();
        queryKey.setField(this.field);
        return queryKey;
    }

    @Override
    public Object createSerializableMapKeyInfo(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public Object createStubbedMapComponentFromSerializableKeyInfo(Object keyInfo, AbstractSession session) {
        return keyInfo;
    }

    @Override
    public void deleteMapKey(Object objectDeleted, AbstractSession session) {
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession session) {
        HashMap<DatabaseField, Object> fields = new HashMap<DatabaseField, Object>();
        Object key = object;
        if (this.hasConverter()) {
            key = this.getConverter().convertObjectValueToDataValue(key, session);
        }
        fields.put(this.getField(), key);
        return fields;
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return null;
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(1);
        tables.add(this.getField().getTable());
        return tables;
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.add(this.getField());
        return fields;
    }

    @Override
    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    @Override
    public String getAttributeClassificationName() {
        if (this.attributeClassificationName == null && this.attributeClassification != null) {
            this.attributeClassificationName = this.attributeClassification.getName();
        }
        return this.attributeClassificationName;
    }

    @Override
    public Object getAttributeValue(Object fieldValue, Session session) {
        return this.getObjectValue(fieldValue, session);
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        if (fieldToClassify.type != null) {
            return fieldToClassify.type;
        }
        if (this.converter != null) {
            return null;
        }
        return Helper.getObjectClass(this.attributeClassification);
    }

    @Override
    public Object getFieldValue(Object attributeValue, AbstractSession session) {
        Object fieldValue = attributeValue;
        if (this.nullValue != null && this.nullValue.equals(fieldValue)) {
            return null;
        }
        if (this.converter != null) {
            fieldValue = this.converter.convertObjectValueToDataValue(fieldValue, session);
        }
        Class fieldClassification = this.getFieldClassification(this.field);
        if (fieldValue == null || fieldClassification != fieldValue.getClass()) {
            try {
                fieldValue = session.getPlatform(this.descriptor.getJavaClass()).convertObject(fieldValue, fieldClassification);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
        }
        return fieldValue;
    }

    @Override
    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return null;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.getAllFieldsForMapKey();
    }

    @Override
    public Class getMapKeyTargetType() {
        Class aClass = this.getAttributeAccessor().getAttributeClass();
        if (aClass == null) {
            aClass = this.getAttributeClassification();
        }
        if (aClass == null) {
            aClass = this.getField().getType();
        }
        return aClass;
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        return null;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public Object getObjectValue(Object fieldValue, Session session) {
        Object attributeValue = fieldValue;
        if (fieldValue == null && this.nullValue != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            attributeValue = this.converter.convertDataValueToObjectValue(attributeValue, session);
        } else if (attributeValue == null || attributeValue.getClass() != this.attributeObjectClassification) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(attributeValue, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, Object parent, MergeManager mergeManager, AbstractSession targetSession) {
        return object;
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        this.setAttributeValueInObject(target, this.buildCloneValue(((DirectToFieldChangeRecord)changeRecord).getNewValue(), mergeManager.getSession()));
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Object targetAttribute;
            Object attributeValue = this.getAttributeValueFromObject(source);
            if (!this.compareObjectValues(attributeValue, targetAttribute = this.getAttributeValueFromObject(target), mergeManager.getSession())) {
                this.setAttributeValueInObject(target, this.buildCloneValue(attributeValue, mergeManager.getSession()));
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), targetAttribute, attributeValue);
            }
        } else {
            this.setAttributeValueInObject(target, this.buildCloneValue(this.getAttributeValueFromObject(source), mergeManager.getSession()));
        }
    }

    @Override
    public void postInitializeMapKey(MappedKeyMapContainerPolicy policy) {
        if (this.getField().getType() == null) {
            this.getField().setType(this.getFieldClassification(this.getField()));
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        if (this.attributeClassification == null) {
            this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        }
        this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        if (this.isMutable == null) {
            if (this.getConverter() != null) {
                this.setIsMutable(this.getConverter().isMutable());
            } else {
                this.setIsMutable(false);
            }
            if (this.getAttributeClassification() != null && (ClassConstants.UTILDATE.isAssignableFrom(this.getAttributeClassification()) || ClassConstants.CALENDAR.isAssignableFrom(this.getAttributeClassification()))) {
                this.setIsMutable(session.getProject().getDefaultTemporalMutable());
            }
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable table) throws DescriptorException {
        this.keyTableForMapKey = table;
    }

    @Override
    public boolean hasConverter() {
        return this.getConverter() != null;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.fieldNameNotSetInMapping(this));
        }
        this.isInsertable = this.getField().isInsertable();
        this.isUpdatable = this.getField().isUpdatable();
        if (this.keyTableForMapKey == null) {
            this.setField(this.getDescriptor().buildField(this.getField()));
        } else {
            this.setField(this.getDescriptor().buildField(this.getField(), this.keyTableForMapKey));
        }
        this.setFields(this.collectFields());
        if (this.hasConverter()) {
            this.getConverter().initialize(this, session);
        }
        if (this.getField().getSqlType() == 2002) {
            this.getDescriptor().setIsNativeConnectionRequired(true);
        }
    }

    public ChangeRecord internalBuildChangeRecord(Object newValue, Object oldValue, ObjectChangeSet owner) {
        DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setNewValue(newValue);
        changeRecord.setOldValue(oldValue);
        return changeRecord;
    }

    @Override
    public boolean isAbstractAttributeDirectMapping() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    @Override
    public boolean isDirectToFieldMapping() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isMutable() {
        if (this.isMutable == null) {
            return false;
        }
        return this.isMutable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        if (iterator.shouldIterateOnPrimitives()) {
            iterator.iteratePrimitiveForMapping(element, this);
        }
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        if (!this.isRemotelyInitialized()) {
            super.remoteInitialization(session);
            if (this.attributeClassification == null) {
                this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
            }
            this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        }
    }

    @Override
    public boolean requiresDataModificationEventsForMapKey() {
        return !this.isReadOnly() && this.isUpdatable();
    }

    @Override
    public void setAttributeClassification(Class attributeClassification) {
        this.attributeClassification = attributeClassification;
    }

    @Override
    public void setAttributeClassificationName(String attributeClassificationName) {
        this.attributeClassificationName = attributeClassificationName;
    }

    @Override
    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setConverterClassName(String converterClassName) {
        this.converterClassName = converterClassName;
    }

    public void setFieldClassificationClassName(String className) {
        this.fieldClassificationClassName = className;
    }

    @Override
    public void setIsMutable(boolean isMutable) {
        this.isMutable = isMutable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectToFieldChangeRecord changeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            objectChangeSet.addChange(this.internalBuildChangeRecord(newValue, oldValue, objectChangeSet));
        } else {
            changeRecord.setNewValue(newValue);
        }
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) throws DescriptorException {
        return this.getFieldValue(this.getAttributeValueFromObject(object), session);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) {
        Object cached;
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && this.isCacheable && isTargetProtected && cacheKey != null && (cached = cacheKey.getObject()) != null) {
            if (wasCacheUsed != null) {
                wasCacheUsed[0] = Boolean.TRUE;
            }
            Object attributeValue = this.getAttributeValueFromObject(cached);
            return this.buildCloneValue(attributeValue, executionSession);
        }
        Object fieldValue = row.get(this.field);
        Object attributeValue = this.getAttributeValue(fieldValue, executionSession);
        return attributeValue;
    }

    @Override
    public Object valueFromResultSet(ResultSet resultSet, ObjectBuildingQuery query, AbstractSession session, DatabaseAccessor accessor, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform) throws SQLException {
        if (this.attributeObjectClassification == ClassConstants.STRING) {
            return resultSet.getString(columnNumber);
        }
        if (this.attributeObjectClassification == ClassConstants.LONG) {
            return resultSet.getLong(columnNumber);
        }
        if (this.attributeObjectClassification == ClassConstants.INTEGER) {
            return resultSet.getInt(columnNumber);
        }
        return accessor.getObject(resultSet, this.field, metaData, columnNumber, platform, true, session);
    }

    @Override
    public Object wrapKey(Object key, AbstractSession session) {
        return key;
    }
}

