/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import javax.activation.DataHandler;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Element;

public class XMLBinaryDataMapping
extends XMLDirectMapping {
    private boolean shouldInlineBinaryData;
    private MimeTypePolicy mimeTypePolicy;
    private boolean isSwaRef;
    private static final String include = ":Include/@href";

    public boolean shouldInlineBinaryData() {
        return this.shouldInlineBinaryData;
    }

    public void setShouldInlineBinaryData(boolean b) {
        this.shouldInlineBinaryData = b;
    }

    public String getMimeType(Object anObject) {
        if (this.mimeTypePolicy == null) {
            return null;
        }
        return this.mimeTypePolicy.getMimeType(anObject);
    }

    public String getMimeType() {
        if (this.mimeTypePolicy == null) {
            return null;
        }
        return this.mimeTypePolicy.getMimeType(null);
    }

    public MimeTypePolicy getMimeTypePolicy() {
        return this.mimeTypePolicy;
    }

    public void setMimeTypePolicy(MimeTypePolicy aPolicy) {
        this.mimeTypePolicy = aPolicy;
    }

    public void setMimeType(String mimeTypeString) {
        this.mimeTypePolicy = new FixedMimeTypePolicy(mimeTypeString);
    }

    public boolean isSwaRef() {
        return this.isSwaRef;
    }

    public void setSwaRef(boolean swaRef) {
        this.isSwaRef = swaRef;
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            return;
        }
        this.writeSingleValue(attributeValue, object, (XMLRecord)row, session);
    }

    public void writeSingleValue(Object attributeValue, Object parent, XMLRecord record, AbstractSession session) {
        XMLField field;
        XMLMarshaller marshaller = record.getMarshaller();
        if (this.getConverter() != null) {
            Converter converter = this.getConverter();
            attributeValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(attributeValue, session, record.getMarshaller()) : converter.convertObjectValueToDataValue(attributeValue, session);
        }
        if ((field = (XMLField)this.getField()).getLastXPathFragment().isAttribute()) {
            if (this.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
                try {
                    String value = null;
                    if (this.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                        value = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)attributeValue);
                    } else {
                        XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, marshaller, this.getMimeType(parent));
                        byte[] bytes = data.getData();
                        value = marshaller.getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
                    }
                    record.put(field, (Object)value);
                }
                catch (ClassCastException classCastException) {
                    throw XMLMarshalException.invalidSwaRefAttribute(this.getAttributeClassification().getName());
                }
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, record.getMarshaller(), this.getMimeType(parent));
                String base64Value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).buildBase64StringFromBytes(data.getData());
                record.put(field, (Object)base64Value);
            }
            return;
        }
        if (record.isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
            XMLBinaryDataHelper.EncodedData data;
            DOMRecord domRecord;
            String c_id = "";
            byte[] bytes = null;
            String elementName = field.getLastXPathFragment().getLocalName();
            String namespaceUri = field.getLastXPathFragment().getNamespaceURI();
            if (field.getLastXPathFragment().isSelfFragment() && (domRecord = (DOMRecord)record).getDOM().getNodeType() == 1) {
                elementName = domRecord.getDOM().getLocalName();
                namespaceUri = domRecord.getDOM().getNamespaceURI();
            }
            if (this.getAttributeClassification() == ClassConstants.ABYTE || this.getAttributeClassification() == ClassConstants.APBYTE) {
                if (this.getAttributeClassification() == ClassConstants.ABYTE) {
                    attributeValue = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(attributeValue, ClassConstants.APBYTE);
                }
                bytes = (byte[])attributeValue;
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, this.getMimeType(parent), elementName, namespaceUri);
            } else if (this.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment((DataHandler)attributeValue, elementName, namespaceUri);
                if (c_id == null) {
                    data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, marshaller, this.getMimeType(parent));
                    bytes = data.getData();
                }
            } else {
                data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, marshaller, this.getMimeType(parent));
                bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), elementName, namespaceUri);
            }
            if (c_id == null) {
                XMLField textField = null;
                textField = field.isSelfField() ? new XMLField("text()") : new XMLField(String.valueOf(field.getXPath()) + '/' + "text()");
                textField.setNamespaceResolver(field.getNamespaceResolver());
                textField.setSchemaType(field.getSchemaType());
                record.put(textField, (Object)bytes);
            } else {
                String xpath = this.getXPath();
                String prefix = null;
                boolean prefixAlreadyDefined = false;
                NamespaceResolver resolver = field.getNamespaceResolver();
                if (resolver != null) {
                    prefix = resolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
                }
                if (prefix == null) {
                    prefix = "xop";
                    resolver = new NamespaceResolver();
                    resolver.put(prefix, "http://www.w3.org/2004/08/xop/include");
                } else {
                    prefixAlreadyDefined = true;
                }
                String incxpath = null;
                if (field.isSelfField()) {
                    incxpath = String.valueOf(prefix) + ":Include";
                    xpath = String.valueOf(prefix) + include;
                } else {
                    incxpath = String.valueOf(xpath) + '/' + prefix + ":Include";
                    xpath = String.valueOf(xpath) + '/' + prefix + include;
                }
                XMLField xpathField = new XMLField(xpath);
                xpathField.setNamespaceResolver(resolver);
                record.put(xpathField, (Object)c_id);
                XMLField incField = new XMLField(incxpath);
                incField.setNamespaceResolver(resolver);
                Object obj = record.getIndicatingNoEntry(incField);
                if (!prefixAlreadyDefined && obj != null && obj instanceof DOMRecord && ((DOMRecord)obj).getDOM().getNodeType() == 1) {
                    ((Element)((DOMRecord)obj).getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "http://www.w3.org/2004/08/xop/include");
                }
            }
        } else if (this.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
            try {
                String c_id = null;
                if (this.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                    c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)attributeValue);
                } else {
                    XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, marshaller, this.getMimeType(parent));
                    byte[] bytes = data.getData();
                    c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
                }
                XMLField textField = new XMLField(String.valueOf(field.getXPath()) + '/' + "text()");
                textField.setNamespaceResolver(field.getNamespaceResolver());
                textField.setSchemaType(field.getSchemaType());
                record.put(textField, (Object)c_id);
            }
            catch (Exception exception) {}
        } else {
            XMLField textField = null;
            textField = field.isSelfField() ? new XMLField("text()") : new XMLField(String.valueOf(field.getXPath()) + '/' + "text()");
            textField.setNamespaceResolver(field.getNamespaceResolver());
            textField.setSchemaType(field.getSchemaType());
            if (this.getAttributeClassification() == ClassConstants.ABYTE || this.getAttributeClassification() == ClassConstants.APBYTE) {
                record.put(textField, attributeValue);
            } else {
                byte[] bytes = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(attributeValue, marshaller, this.getMimeType(parent)).getData();
                record.put(textField, (Object)bytes);
            }
        }
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) {
        Object value = row.get(this.field);
        if (value == null) {
            return value;
        }
        Object fieldValue = null;
        XMLUnmarshaller unmarshaller = ((XMLRecord)row).getUnmarshaller();
        if (value instanceof String) {
            if (this.isSwaRef() && unmarshaller.getAttachmentUnmarshaller() != null) {
                fieldValue = this.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler((String)value) : (Object)unmarshaller.getAttachmentUnmarshaller().getAttachmentAsByteArray((String)value);
            } else if (!this.isSwaRef()) {
                byte[] bytes = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(value);
                fieldValue = bytes;
            }
        } else if (value instanceof byte[] || value instanceof Byte[]) {
            fieldValue = value;
        } else {
            XMLRecord record = (XMLRecord)value;
            record.setSession(executionSession);
            if (unmarshaller.getAttachmentUnmarshaller() != null && unmarshaller.getAttachmentUnmarshaller().isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
                String xpath = "";
                String prefix = null;
                NamespaceResolver descriptorResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
                if (descriptorResolver != null) {
                    prefix = descriptorResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
                }
                if (prefix == null) {
                    prefix = "xop";
                }
                NamespaceResolver tempResolver = new NamespaceResolver();
                tempResolver.put(prefix, "http://www.w3.org/2004/08/xop/include");
                xpath = String.valueOf(prefix) + include;
                XMLField field = new XMLField(xpath);
                field.setNamespaceResolver(tempResolver);
                String includeValue = (String)record.get(field);
                if (includeValue != null) {
                    fieldValue = this.getAttributeClassification() == ClassConstants.ABYTE || this.getAttributeClassification() == ClassConstants.APBYTE ? (Object)unmarshaller.getAttachmentUnmarshaller().getAttachmentAsByteArray(includeValue) : unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler(includeValue);
                } else {
                    fieldValue = record.get("text()");
                    fieldValue = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(fieldValue);
                }
            } else if (unmarshaller.getAttachmentUnmarshaller() != null && this.isSwaRef()) {
                String refValue = (String)record.get("text()");
                if (refValue != null) {
                    fieldValue = unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler(refValue);
                }
            } else {
                fieldValue = record.get("text()");
                fieldValue = fieldValue != null ? (Object)((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(fieldValue) : (Object)new byte[0];
            }
        }
        Object attributeValue = fieldValue;
        if (this.getConverter() != null) {
            attributeValue = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(fieldValue, executionSession, unmarshaller) : this.getConverter().convertDataValueToObjectValue(fieldValue, executionSession);
        }
        attributeValue = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(attributeValue, this.getAttributeClassification(), executionSession);
        return attributeValue;
    }

    public boolean isAbstractDirectMapping() {
        return false;
    }

    public boolean isAbstractAttributeDirectMapping() {
        return false;
    }
}

