/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import org.eclipse.persistence.jpa.jpql.model.AbstractJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.query.EclipseLinkStateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.FuncExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.TreatExpressionStateObject;

public class EclipseLinkJPQLQueryFormatter
extends AbstractJPQLQueryFormatter
implements EclipseLinkStateObjectVisitor {
    public EclipseLinkJPQLQueryFormatter(IJPQLQueryFormatter.IdentifierStyle style) {
        super(style);
    }

    public String formatIdentifier(String identifier) {
        return identifier;
    }

    public void visit(FuncExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            stateObject.getDecorator().accept(this);
        } else {
            this.writer.append(this.formatIdentifier("FUNC"));
            this.writer.append(this.formatIdentifier("("));
            if (stateObject.hasFunctionName()) {
                this.writer.append(stateObject.getFunctionName());
                if (stateObject.hasItems()) {
                    this.writer.append(", ");
                }
            }
            this.toStringChildren(stateObject, true);
            this.writer.append(this.formatIdentifier(")"));
        }
    }

    public void visit(TreatExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            stateObject.getDecorator().accept(this);
        } else {
            this.writer.append(this.formatIdentifier("TREAT"));
            this.writer.append(this.formatIdentifier("("));
            stateObject.getJoinAssociationPathStateObject().toText(this.writer);
            this.writer.append(" ");
            if (stateObject.hasAs()) {
                this.writer.append("AS");
                this.writer.append(" ");
            }
            this.writer.append(stateObject.getEntityTypeName());
            this.writer.append(this.formatIdentifier(")"));
        }
    }
}

