/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.StringLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikeExpressionStateObject
extends AbstractStateObject {
    private StringLiteralStateObject escapeCharacter;
    private boolean not;
    private StateObject patternValue;
    private StateObject stringStateObject;
    public static final String ESCAPE_CHARACTER_PROPERTY = "escapeCharacter";
    public static String NOT_PROPERTY = "not";
    public static final String PATTERN_VALUE_PROPERTY = "patternValue";
    public static final String STRING_STATE_OBJECT_PROPERTY = "stringStateObject";

    public LikeExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public LikeExpressionStateObject(StateObject parent, StateObject stringStateObject) {
        this(parent, stringStateObject, false, null, null);
    }

    public LikeExpressionStateObject(StateObject parent, StateObject stringStateObject, boolean not, StateObject patternValue, String escapeCharacter) {
        super(parent);
        this.stringStateObject = this.parent(stringStateObject);
        this.not = not;
        this.patternValue = this.parent(patternValue);
        this.escapeCharacter.setTextInternally(escapeCharacter);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stringStateObject != null) {
            children.add(this.stringStateObject);
        }
        if (this.patternValue != null) {
            children.add(this.patternValue);
        }
    }

    public LikeExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter.getText();
    }

    @Override
    public LikeExpression getExpression() {
        return (LikeExpression)super.getExpression();
    }

    public StateObject getPatternValue() {
        return this.patternValue;
    }

    public StateObject getStringStateObject() {
        return this.stringStateObject;
    }

    public boolean hasEscapeCharacter() {
        return this.escapeCharacter.hasText();
    }

    public boolean hasNot() {
        return this.not;
    }

    public boolean hasPatternValue() {
        return this.patternValue != null;
    }

    public boolean hasStringStateObject() {
        return this.stringStateObject != null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.escapeCharacter = new StringLiteralStateObject(this);
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void setEscapeCharacter(String escapeCharacter) {
        String oldEscapeCharacter = this.getEscapeCharacter();
        this.escapeCharacter.setText(escapeCharacter);
        this.firePropertyChanged(ESCAPE_CHARACTER_PROPERTY, oldEscapeCharacter, escapeCharacter);
    }

    public void setExpression(LikeExpression expression) {
        super.setExpression(expression);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    public void setPatternValue(StateObject patternValue) {
        StateObject oldPatternValue = this.patternValue;
        this.patternValue = this.parent(patternValue);
        this.firePropertyChanged(PATTERN_VALUE_PROPERTY, oldPatternValue, patternValue);
    }

    public void setStringStateObject(StateObject stringStateObject) {
        StateObject oldStringStateObject = this.stringStateObject;
        this.stringStateObject = this.parent(stringStateObject);
        this.firePropertyChanged(STRING_STATE_OBJECT_PROPERTY, oldStringStateObject, stringStateObject);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stringStateObject != null) {
            this.stringStateObject.toString(writer);
            writer.append(' ');
        }
        writer.append(this.not ? "NOT LIKE" : "LIKE");
        if (this.patternValue != null) {
            writer.append(' ');
            this.patternValue.toString(writer);
        }
        if (this.escapeCharacter != null) {
            writer.append(' ');
            writer.append("ESCAPE");
            writer.append(' ');
            this.escapeCharacter.toTextInternal(writer);
        }
    }
}

