/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinFetch
extends AbstractExpression {
    private boolean hasSpaceAfterFetch;
    private String identifier;
    private AbstractExpression joinAssociationPath;

    public JoinFetch(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getJoinAssociationPath().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getJoinAssociationPath());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        String space;
        String joinType = this.getIdentifier().toString();
        if (joinType.indexOf(space = " ") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(joinType, space, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                children.add(this.buildStringExpression(token));
            }
        } else {
            children.add(this.buildStringExpression(joinType));
        }
        if (this.hasSpaceAfterFetch) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joinAssociationPath != null) {
            children.add(this.joinAssociationPath);
        }
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public String getIdentifier() {
        return this.getText();
    }

    public Expression getJoinAssociationPath() {
        if (this.joinAssociationPath == null) {
            this.joinAssociationPath = this.buildNullExpression();
        }
        return this.joinAssociationPath;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("fetch_join");
    }

    public boolean hasJoinAssociationPath() {
        return this.joinAssociationPath != null && !this.joinAssociationPath.isNull();
    }

    public boolean hasSpaceAfterFetch() {
        return this.hasSpaceAfterFetch;
    }

    public boolean isLeftJoinFetch() {
        String identifier = this.getIdentifier();
        return identifier == "LEFT JOIN FETCH" || identifier == "LEFT OUTER JOIN FETCH";
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward(this.getText());
        this.hasSpaceAfterFetch = wordParser.skipLeadingWhitespace() > 0;
        this.joinAssociationPath = this.parse(wordParser, this.getQueryBNF("join_association_path_expression*"), tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getIdentifier());
        if (this.hasSpaceAfterFetch) {
            writer.append(' ');
        }
        if (this.joinAssociationPath != null) {
            this.joinAssociationPath.toParsedText(writer, actual);
        }
    }
}

