/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeywordExpression
extends AbstractExpression {
    private String identifier;

    public KeywordExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("boolean_literal");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        String word = this.parseIdentifier(wordParser);
        this.setText(word);
        this.identifier = wordParser.moveForward(word);
    }

    private String parseIdentifier(WordParser wordParser) {
        switch (wordParser.character()) {
            case 'T': 
            case 't': {
                return "TRUE";
            }
            case 'F': 
            case 'f': {
                return "FALSE";
            }
        }
        return "NULL";
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
    }
}

