/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTable
implements Cloneable,
Serializable {
    protected String name;
    protected String tableQualifier;
    protected String qualifiedName;
    protected Map<String, List<List<String>>> uniqueConstraints;
    protected List<IndexDefinition> indexes;
    protected boolean useDelimiters = false;
    protected String creationSuffix;

    public DatabaseTable() {
        this.name = "";
        this.tableQualifier = "";
    }

    public DatabaseTable(String possiblyQualifiedName) {
        this(possiblyQualifiedName, null, null);
    }

    public DatabaseTable(String possiblyQualifiedName, String startDelimiter, String endDelimiter) {
        this.setPossiblyQualifiedName(possiblyQualifiedName, startDelimiter, endDelimiter);
    }

    public DatabaseTable(String tableName, String qualifier) {
        this(tableName, qualifier, false, null, null);
    }

    public DatabaseTable(String tableName, String qualifier, boolean useDelimiters, String startDelimiter, String endDelimiter) {
        this.setName(tableName, startDelimiter, endDelimiter);
        this.tableQualifier = qualifier;
        this.useDelimiters = useDelimiters;
    }

    public void addUniqueConstraints(String name, List<String> columnNames) {
        if (this.getUniqueConstraints().containsKey(name)) {
            this.getUniqueConstraints().get(name).add(columnNames);
        } else {
            ArrayList<List<String>> value = new ArrayList<List<String>>();
            value.add(columnNames);
            this.getUniqueConstraints().put(name, value);
        }
    }

    public DatabaseTable clone() {
        try {
            return (DatabaseTable)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseTable) {
            return this.equals((DatabaseTable)object);
        }
        return false;
    }

    public boolean equals(DatabaseTable table) {
        if (this == table) {
            return true;
        }
        return DatabasePlatform.shouldIgnoreCaseOnFieldComparisons() ? this.getName().equalsIgnoreCase(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equalsIgnoreCase(table.getTableQualifier())) : this.getName().equals(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equals(table.getTableQualifier()));
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public String getName() {
        return this.name;
    }

    public String getNameDelimited(DatasourcePlatform platform) {
        if (this.useDelimiters) {
            return String.valueOf(platform.getStartDelimiter()) + this.name + platform.getEndDelimiter();
        }
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.tableQualifier.equals("") ? this.getName() : String.valueOf(this.getTableQualifier()) + "." + this.getName();
        }
        return this.qualifiedName;
    }

    public String getQualifiedNameDelimited(DatasourcePlatform platform) {
        if (this.tableQualifier.equals("")) {
            if (this.useDelimiters) {
                return String.valueOf(platform.getStartDelimiter()) + this.getName() + platform.getEndDelimiter();
            }
            return this.getName();
        }
        if (this.useDelimiters) {
            return String.valueOf(platform.getStartDelimiter()) + this.getTableQualifier() + platform.getEndDelimiter() + "." + platform.getStartDelimiter() + this.getName() + platform.getEndDelimiter();
        }
        return String.valueOf(this.getTableQualifier()) + "." + this.getName();
    }

    public void printSQL(ExpressionSQLPrinter printer) throws IOException {
        printer.getWriter().write(this.getQualifiedNameDelimited(printer.getPlatform()));
    }

    public String getTableQualifierDelimited(DatasourcePlatform platform) {
        if (this.useDelimiters && this.tableQualifier != null && !this.tableQualifier.equals("")) {
            return String.valueOf(platform.getStartDelimiter()) + this.tableQualifier + platform.getEndDelimiter();
        }
        return this.tableQualifier;
    }

    public String getTableQualifier() {
        return this.tableQualifier;
    }

    public boolean hasUniqueConstraints() {
        return this.uniqueConstraints != null && !this.uniqueConstraints.isEmpty();
    }

    public boolean hasIndexes() {
        return this.indexes != null && !this.indexes.isEmpty();
    }

    public List<IndexDefinition> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexDefinition>();
        }
        return this.indexes;
    }

    public Map<String, List<List<String>>> getUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = new HashMap<String, List<List<String>>>();
        }
        return this.uniqueConstraints;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasName() {
        return this.getName().length() != 0 || this.getTableQualifier().length() != 0;
    }

    public boolean isDecorated() {
        return false;
    }

    protected void resetQualifiedName() {
        this.qualifiedName = null;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    public void setName(String name) {
        this.setName(name, null, null);
    }

    public void setName(String name, String startDelimiter, String endDelimiter) {
        if (name != null && startDelimiter != null && endDelimiter != null && !startDelimiter.equals("") && !endDelimiter.equals("") && name.startsWith(startDelimiter) && name.endsWith(endDelimiter)) {
            this.name = name.substring(startDelimiter.length(), name.length() - endDelimiter.length());
            this.useDelimiters = true;
        } else {
            this.name = name;
        }
        this.resetQualifiedName();
    }

    public void setPossiblyQualifiedName(String possiblyQualifiedName) {
        this.setPossiblyQualifiedName(possiblyQualifiedName, null, null);
    }

    public void setPossiblyQualifiedName(String possiblyQualifiedName, String startDelimiter, String endDelimiter) {
        this.resetQualifiedName();
        int index = possiblyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.setName(possiblyQualifiedName, startDelimiter, endDelimiter);
            this.tableQualifier = "";
        } else {
            this.setName(possiblyQualifiedName.substring(index + 1, possiblyQualifiedName.length()), startDelimiter, endDelimiter);
            this.setTableQualifier(possiblyQualifiedName.substring(0, index), startDelimiter, endDelimiter);
            if (startDelimiter != null && possiblyQualifiedName.startsWith(startDelimiter) && endDelimiter != null && possiblyQualifiedName.endsWith(endDelimiter) && !this.useDelimiters) {
                this.setName(possiblyQualifiedName);
                this.tableQualifier = "";
            }
        }
    }

    public void setTableQualifier(String qualifier) {
        this.setTableQualifier(qualifier, null, null);
    }

    public void setTableQualifier(String qualifier, String startDelimiter, String endDelimiter) {
        if (startDelimiter != null && endDelimiter != null && !startDelimiter.equals("") && !endDelimiter.equals("") && qualifier.startsWith(startDelimiter) && qualifier.endsWith(endDelimiter)) {
            this.tableQualifier = qualifier.substring(startDelimiter.length(), qualifier.length() - endDelimiter.length());
            this.useDelimiters = true;
        } else {
            this.tableQualifier = qualifier;
        }
        this.resetQualifiedName();
    }

    public String toString() {
        return "DatabaseTable(" + this.getQualifiedName() + ")";
    }

    public void setUseDelimiters(boolean useDelimiters) {
        this.useDelimiters = useDelimiters;
    }

    public boolean shouldUseDelimiters() {
        return this.useDelimiters;
    }
}

