/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Map;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLFragmentMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLFragmentMappingNodeValue
extends MappingNodeValue
implements NullCapableValue {
    private XMLFragmentMapping xmlFragmentMapping;
    private boolean selfMapping;

    public XMLFragmentMappingNodeValue(XMLFragmentMapping xmlFragmentMapping) {
        this.xmlFragmentMapping = xmlFragmentMapping;
        this.selfMapping = ".".equals(xmlFragmentMapping.getXPath());
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.getNextFragment() == null;
    }

    public void setNullValue(Object object, Session session) {
        Object value = this.xmlFragmentMapping.getAttributeValue(null, session);
        this.xmlFragmentMapping.setAttributeValueInObject(object, value);
    }

    public boolean isNullCapableValue() {
        return true;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlFragmentMapping.isReadOnly()) {
            return false;
        }
        Object attributeValue = marshalContext.getAttributeValue(object, this.xmlFragmentMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, attributeValue, session, namespaceResolver, marshalContext);
    }

    public boolean marshalSelfAttributes(XPathFragment pathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller) {
        block5: {
            Node node = (Node)this.xmlFragmentMapping.getAttributeValueFromObject(object);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null) break block5;
            int x = 0;
            int attributesLength = attributes.getLength();
            while (x < attributesLength) {
                block7: {
                    String prefix;
                    String localName;
                    Node attribute;
                    block6: {
                        attribute = attributes.item(x);
                        if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) break block6;
                        String nsResolverPrefix = namespaceResolver.resolveNamespaceURI(attribute.getNodeValue());
                        if (attribute.getLocalName().equals(nsResolverPrefix)) break block7;
                    }
                    String namespaceURI = attribute.getNamespaceURI();
                    String qualifiedName = localName = attribute.getLocalName();
                    if (namespaceResolver != null && (prefix = namespaceResolver.resolveNamespaceURI(namespaceURI)) != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(prefix);
                        stringBuilder.append(':');
                        stringBuilder.append(qualifiedName);
                        qualifiedName = String.valueOf(prefix) + ':' + qualifiedName;
                    }
                    marshalRecord.attribute(namespaceURI, localName, qualifiedName, attribute.getNodeValue());
                }
                ++x;
            }
        }
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object attributeValue, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        marshalRecord.openStartGroupingElements(namespaceResolver);
        if (!(attributeValue instanceof Node)) {
            return false;
        }
        Node nodeValue = (Node)attributeValue;
        if (this.selfMapping) {
            NodeList childNodes = nodeValue.getChildNodes();
            int x = 0;
            int childNodesLength = childNodes.getLength();
            while (x < childNodesLength) {
                childNodes.item(x);
                marshalRecord.node(childNodes.item(x), namespaceResolver);
                ++x;
            }
        } else {
            marshalRecord.node((Node)attributeValue, namespaceResolver);
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        unmarshalRecord.removeNullCapableValue(this);
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        builder.setOwningRecord(unmarshalRecord);
        try {
            String namespaceURI = "";
            if (xPathFragment.getNamespaceURI() != null) {
                namespaceURI = xPathFragment.getNamespaceURI();
            }
            String qName = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qName = String.valueOf(xPathFragment.getPrefix()) + ':' + qName;
            }
            if (!unmarshalRecord.getPrefixesForFragment().isEmpty()) {
                for (Map.Entry<String, String> next : unmarshalRecord.getPrefixesForFragment().entrySet()) {
                    builder.startPrefixMapping(next.getKey(), next.getValue());
                }
            }
            builder.startElement(namespaceURI, xPathFragment.getLocalName(), qName, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(builder);
            xmlReader.setLexicalHandler(null);
        }
        catch (SAXException sAXException) {}
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this);
        XPathFragment lastFrag = ((XMLField)this.xmlFragmentMapping.getField()).getLastXPathFragment();
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        if (lastFrag.nameIsText()) {
            Text attributeValue = builder.buildTextNode(unmarshalRecord.getCharacters().toString());
            unmarshalRecord.resetStringBuffer();
            this.xmlFragmentMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), attributeValue);
        } else if (!lastFrag.isAttribute()) {
            Node value = builder.getNodes().remove(builder.getNodes().size() - 1);
            unmarshalRecord.setAttributeValue(value, this.xmlFragmentMapping);
        }
    }

    public void endSelfNodeValue(UnmarshalRecord unmarshalRecord, UnmarshalRecord selfRecord, Attributes atts) {
        this.endElement(XPathFragment.SELF_FRAGMENT, unmarshalRecord);
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        unmarshalRecord.removeNullCapableValue(this);
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        Attr attributeValue = builder.buildAttributeNode(namespaceURI, localName, value);
        this.xmlFragmentMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), attributeValue);
    }

    public XMLFragmentMapping getMapping() {
        return this.xmlFragmentMapping;
    }
}

