/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.CollectionValuedFieldResolver;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryBuilder;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSchemaNameStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ConstructorExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.EntityTypeLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.JPQLQueryStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefactoringTool {
    private CharSequence jpqlFragment;
    private String jpqlQueryBNFId;
    private IJPQLQueryBuilder jpqlQueryBuilder;
    private IJPQLQueryFormatter jpqlQueryFormatter;
    private IManagedTypeProvider managedTypeProvider;
    private JPQLQueryStateObject stateObject;

    protected RefactoringTool(IManagedTypeProvider managedTypeProvider, IJPQLQueryBuilder jpqlQueryBuilder, CharSequence jpqlQuery) {
        this(managedTypeProvider, jpqlQueryBuilder, jpqlQuery, "ql_statement");
    }

    protected RefactoringTool(IManagedTypeProvider managedTypeProvider, IJPQLQueryBuilder jpqlQueryBuilder, CharSequence jpqlFragment, String jpqlQueryBNFId) {
        this.jpqlFragment = jpqlFragment;
        this.jpqlQueryBNFId = jpqlQueryBNFId;
        this.jpqlQueryBuilder = jpqlQueryBuilder;
        this.managedTypeProvider = managedTypeProvider;
    }

    protected ClassNameRenamer buildClassNameRenamer(String oldClassName, String newClassName) {
        return new ClassNameRenamer(oldClassName, newClassName);
    }

    protected EntityNameRenamer buildEntityNameRenamer(String oldEntityName, String newEntityName) {
        return new EntityNameRenamer(oldEntityName, newEntityName);
    }

    protected EnumConstantRenamer buildEnumConstantRenamer(String oldClassName, String newClassName) {
        return new EnumConstantRenamer(oldClassName, newClassName);
    }

    protected FieldNameRenamer buildFieldNameRenamer(String typeName, String oldFieldName, String newFieldName) {
        return new FieldNameRenamer(typeName, oldFieldName, newFieldName);
    }

    protected abstract IJPQLQueryFormatter buildFormatter();

    protected abstract JPQLQueryContext buildJPQLQueryContext();

    protected JPQLQueryStateObject buildStateObject() {
        return this.jpqlQueryBuilder.buildStateObject(this.managedTypeProvider, this.jpqlFragment, this.jpqlQueryBNFId, this.isTolerant());
    }

    protected VariableNameRenamer buildVariableNameRenamer(String oldVariableName, String newVariableName) {
        return new VariableNameRenamer(oldVariableName, newVariableName);
    }

    public IJPQLQueryFormatter getFormatter() {
        if (this.jpqlQueryFormatter == null) {
            this.jpqlQueryFormatter = this.buildFormatter();
        }
        return this.jpqlQueryFormatter;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlQueryBuilder.getGrammar();
    }

    public CharSequence getJPQLFragment() {
        return this.jpqlFragment;
    }

    public String getJPQLQueryBNFId() {
        return this.jpqlQueryBNFId;
    }

    public IJPQLQueryBuilder getJPQLQueryBuilder() {
        return this.jpqlQueryBuilder;
    }

    public IManagedTypeProvider getManagedTypeProvider() {
        return this.managedTypeProvider;
    }

    public JPQLQueryStateObject getStateObject() {
        if (this.stateObject == null) {
            this.stateObject = this.buildStateObject();
        }
        return this.stateObject;
    }

    protected boolean isTolerant() {
        return true;
    }

    public void renameClassName(String oldClassName, String newClassName) {
        ClassNameRenamer renamer = this.buildClassNameRenamer(oldClassName, newClassName);
        this.getStateObject().accept(renamer);
    }

    public void renameEntityName(String oldEntityName, String newEntityName) {
        EntityNameRenamer renamer = this.buildEntityNameRenamer(oldEntityName, newEntityName);
        this.getStateObject().accept(renamer);
    }

    public void renameEnumConstant(String oldEnumConstant, String newEnumConstant) {
        EnumConstantRenamer renamer = this.buildEnumConstantRenamer(oldEnumConstant, newEnumConstant);
        this.getStateObject().accept(renamer);
    }

    public void renameField(Class<?> type, String oldFieldName, String newFieldName) {
        this.renameField(type.getName(), oldFieldName, newFieldName);
    }

    public void renameField(IType type, String oldFieldName, String newFieldName) {
        this.renameField(type.getName(), oldFieldName, newFieldName);
    }

    public void renameField(String typeName, String oldFieldName, String newFieldName) {
        FieldNameRenamer renamer = this.buildFieldNameRenamer(typeName, oldFieldName, newFieldName);
        this.getStateObject().accept(renamer);
    }

    public void renameVariable(String oldVariableName, String newVariableName) {
        VariableNameRenamer renamer = this.buildVariableNameRenamer(oldVariableName, newVariableName);
        this.getStateObject().accept(renamer);
    }

    public void setFormatter(IJPQLQueryFormatter jpqlQueryFormatter) {
        this.jpqlQueryFormatter = jpqlQueryFormatter;
    }

    public String toActualText() {
        return this.getFormatter().toString(this.getStateObject());
    }

    protected class ClassNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newClassName;
        protected final String oldClassName;

        public ClassNameRenamer(String oldClassName, String newClassName) {
            this.oldClassName = oldClassName;
            this.newClassName = newClassName;
        }

        public void visit(ConstructorExpressionStateObject stateObject) {
            if (this.oldClassName.equals(stateObject.getClassName())) {
                stateObject.setClassName(this.newClassName);
            }
        }
    }

    protected class EntityNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newEntityName;
        protected final String oldEntityName;

        public EntityNameRenamer(String oldEntityName, String newEntityName) {
            this.oldEntityName = oldEntityName;
            this.newEntityName = newEntityName;
        }

        public void visit(AbstractSchemaNameStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }

        public void visit(EntityTypeLiteralStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }

        public void visit(IdentificationVariableStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }
    }

    protected class EnumConstantRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newEnumConstant;
        protected final String oldEnumConstant;

        public EnumConstantRenamer(String oldEnumConstant, String newEnumConstant) {
            this.oldEnumConstant = oldEnumConstant;
            this.newEnumConstant = newEnumConstant;
        }

        protected void renameEnumConstant(AbstractPathExpressionStateObject stateObject) {
            IType type;
            String path = stateObject.toString();
            if (path.equals(this.oldEnumConstant) && (type = RefactoringTool.this.getManagedTypeProvider().getTypeRepository().getEnumType(path)) != null) {
                stateObject.setPath(this.newEnumConstant);
            }
        }

        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            this.renameEnumConstant(stateObject);
        }

        public void visit(StateFieldPathExpressionStateObject stateObject) {
            this.renameEnumConstant(stateObject);
        }
    }

    protected class FieldNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newFieldName;
        protected final String oldFieldName;
        protected final String typeName;

        public FieldNameRenamer(String typeName, String oldFieldName, String newFieldName) {
            this.typeName = typeName;
            this.oldFieldName = oldFieldName;
            this.newFieldName = newFieldName;
        }

        protected void rename(AbstractPathExpressionStateObject stateObject, boolean collectionValuedPath) {
            JPQLQueryContext context = RefactoringTool.this.buildJPQLQueryContext();
            context.setJPQLExpression(stateObject.getRoot().getExpression());
            context.setQuery(new JavaQuery(RefactoringTool.this.getManagedTypeProvider(), RefactoringTool.this.getJPQLFragment()));
            Resolver resolver = context.getResolver(stateObject.getExpression().getIdentificationVariable());
            if (resolver != null) {
                int index = 1;
                int count = stateObject.itemsSize();
                while (index < count) {
                    IMapping mapping;
                    String path = stateObject.getItem(index);
                    Resolver childResolver = resolver.getChild(path);
                    if (childResolver == null) {
                        childResolver = index + 1 == count && collectionValuedPath ? new CollectionValuedFieldResolver(resolver, path) : new StateFieldResolver(resolver, path);
                        resolver.addChild(path, childResolver);
                        resolver = childResolver;
                    }
                    if ((mapping = resolver.getMapping()) == null) break;
                    if (mapping.getName().equals(this.oldFieldName)) {
                        stateObject.setPath(index, this.newFieldName);
                        break;
                    }
                    ++index;
                }
            }
        }

        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            this.rename(stateObject, true);
        }

        public void visit(StateFieldPathExpressionStateObject stateObject) {
            this.rename(stateObject, false);
        }
    }

    protected class VariableNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newVariableName;
        protected final String oldVariableName;

        public VariableNameRenamer(String oldVariableName, String newVariableName) {
            this.oldVariableName = oldVariableName;
            this.newVariableName = newVariableName;
        }

        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            stateObject.getIdentificationVariable();
            super.visit(stateObject);
        }

        public void visit(IdentificationVariableStateObject stateObject) {
            if (this.oldVariableName.equalsIgnoreCase(stateObject.getText())) {
                stateObject.setText(this.newVariableName);
            }
        }

        public void visit(StateFieldPathExpressionStateObject stateObject) {
            stateObject.getIdentificationVariable();
            super.visit(stateObject);
        }
    }
}

