/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Arrays;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionFactory
implements Comparable<ExpressionFactory> {
    private ExpressionRegistry expressionRegistry;
    private String id;
    private String[] identifiers;

    protected ExpressionFactory(String id, String ... identifiers) {
        this.initialize(id, identifiers);
    }

    protected abstract AbstractExpression buildExpression(AbstractExpression var1, WordParser var2, String var3, JPQLQueryBNF var4, AbstractExpression var5, boolean var6);

    @Override
    public final int compareTo(ExpressionFactory expressionFactory) {
        return this.id.compareTo(expressionFactory.getId());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        ExpressionFactory factory = (ExpressionFactory)object;
        return this.id.equals(factory.id);
    }

    public final ExpressionRegistry getExpressionRegistry() {
        return this.expressionRegistry;
    }

    public final String getId() {
        return this.id;
    }

    public JPAVersion getVersion() {
        return JPAVersion.VERSION_1_0;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String[] identifiers() {
        return this.identifiers;
    }

    private void initialize(String id, String ... identifiers) {
        if (id == null) {
            throw new NullPointerException("The unique identifier of this ExpressionFactory cannot be null");
        }
        if (identifiers == null) {
            throw new NullPointerException("The list of supported JPQL identifiers cannot be null");
        }
        this.id = id;
        this.identifiers = identifiers;
    }

    final void setExpressionRegistry(ExpressionRegistry expressionRegistry) {
        this.expressionRegistry = expressionRegistry;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(id=");
        sb.append(this.id);
        sb.append(", identifiers=");
        sb.append(Arrays.toString(this.identifiers));
        sb.append(")");
        return sb.toString();
    }
}

