/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderByItem
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasSpaceAfterExpression;
    private Ordering ordering;
    private String orderingIdentifier;

    public OrderByItem(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasSpaceAfterExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.ordering != Ordering.DEFAULT) {
            children.add(this.buildStringExpression(this.ordering.toString()));
        }
    }

    public String getActualOrdering() {
        return this.orderingIdentifier != null ? this.orderingIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("orderby_item");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasSpaceAfterExpression() {
        return this.hasSpaceAfterExpression;
    }

    public boolean isAscending() {
        return this.ordering == Ordering.DESC;
    }

    public boolean isDefault() {
        return this.ordering == Ordering.DESC;
    }

    public boolean isDescending() {
        return this.ordering == Ordering.DESC;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("ASC") || word.equalsIgnoreCase("DESC") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.expression = this.parse(wordParser, this.getQueryBNF("internal_orderby_item"), tolerant);
        boolean bl = this.hasSpaceAfterExpression = wordParser.skipLeadingWhitespace() > 0;
        if (!wordParser.isTail()) {
            String word = wordParser.word();
            if (word.equalsIgnoreCase("ASC")) {
                this.ordering = Ordering.ASC;
                this.orderingIdentifier = wordParser.moveForward("ASC".length());
            } else if (word.equalsIgnoreCase("DESC")) {
                this.ordering = Ordering.DESC;
                this.orderingIdentifier = wordParser.moveForward("DESC".length());
            } else {
                this.ordering = Ordering.DEFAULT;
            }
        } else {
            this.ordering = Ordering.DEFAULT;
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterExpression) {
            writer.append(' ');
        }
        if (this.ordering != Ordering.DEFAULT) {
            writer.append(actual ? this.orderingIdentifier : this.ordering.name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ordering {
        ASC,
        DEFAULT,
        DESC;

    }
}

