/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectMapping
extends DatabaseMapping {
    protected DatabaseField field;

    public AbstractDirectMapping() {
        this.setWeight(WEIGHT_DIRECT);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isInsertable() {
        return true;
    }

    public boolean isUpdatable() {
        return true;
    }

    public void setIsMutable(boolean isMutable) {
    }

    public void setNullValue(Object nullValue) {
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        String attributeName = this.getAttributeName();
        Object attributeValue = this.getAttributeValueFromObject(queryObject);
        if (!policy.shouldIncludeInQuery(queryObject.getClass(), attributeName, attributeValue)) {
            return null;
        }
        Expression expression = expressionBuilder.get(attributeName);
        expression = attributeValue == null ? policy.completeExpressionForNull(expression) : policy.completeExpression(expression, attributeValue, attributeValue.getClass());
        return expression;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        AbstractDirectMapping clone = (AbstractDirectMapping)super.clone();
        clone.setField(this.getField().clone());
        return clone;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> databaseField = new Vector<DatabaseField>(1);
        databaseField.addElement(this.getField());
        return databaseField;
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
    }

    public Converter getConverter() {
        return null;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public boolean isAbstractDirectMapping() {
        return true;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public Class getFieldClassification() {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getType();
    }

    public void setFieldClassification(Class fieldType) {
        this.getField().setType(fieldType);
    }

    public void setFieldType(int jdbcType) {
        this.getField().setSqlType(jdbcType);
    }

    public String getFieldName() {
        return this.getField().getQualifiedName();
    }

    public abstract Object getFieldValue(Object var1, AbstractSession var2);

    @Deprecated
    public String getAttributeClassificationName() {
        return null;
    }

    @Deprecated
    public Object getAttributeValue(Object fieldValue, Session session) {
        return this.getObjectValue(fieldValue, session);
    }

    public Object getNullValue() {
        return null;
    }

    public abstract Object getObjectValue(Object var1, Session var2);

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasConverter() {
        return false;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        if (iterator.shouldIterateOnPrimitives()) {
            iterator.iteratePrimitiveForMapping(this.getAttributeValueFromObject(iterator.getVisitedParent()), this);
        }
    }

    @Deprecated
    public abstract void setAttributeClassification(Class var1);

    @Deprecated
    public void setAttributeClassificationName(String attributeClassificationName) {
    }

    public void setConverter(Converter converter) {
    }

    public void setField(DatabaseField theField) {
        this.field = theField;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    @Override
    public boolean isCloningRequired() {
        return this.isMutable() || this.getDescriptor().getCopyPolicy().buildsNewInstance();
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.getFieldName() == null || this.getFieldName().length() == 0) {
            session.getIntegrityChecker().handleError(DescriptorException.noFieldNameForMapping(this));
        }
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, sharedCacheKey, executionSession, true, null);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        this.readFromRowIntoObject(databaseRow, null, original, null, query, executionSession, true);
    }

    protected abstract void writeValueIntoRow(AbstractRecord var1, DatabaseField var2, Object var3);

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly() || writeType.equals((Object)DatabaseMapping.WriteType.INSERT) && !this.isInsertable() || writeType.equals((Object)DatabaseMapping.WriteType.UPDATE) && !this.isUpdatable()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        Object fieldValue = this.getFieldValue(attributeValue, session);
        if (fieldValue == null) {
            row.setNullValueInFields(true);
        }
        this.writeValueIntoRow(row, this.getField(), fieldValue);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) {
        if (query.getSession().isUnitOfWork() && this.compareObjects(query.getBackupClone(), query.getObject(), query.getSession())) {
            return;
        }
        super.writeFromObjectIntoRowForUpdate(query, databaseRow);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly() || writeType.equals((Object)DatabaseMapping.WriteType.INSERT) && !this.isInsertable() || writeType.equals((Object)DatabaseMapping.WriteType.UPDATE) && !this.isUpdatable()) {
            return;
        }
        if (this.isPrimaryKeyMapping() && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object attributeValue = ((DirectToFieldChangeRecord)changeRecord).getNewValue();
        Object fieldValue = this.getFieldValue(attributeValue, session);
        if (fieldValue == null) {
            row.setNullValueInFields(true);
        }
        row.add(this.getField(), fieldValue);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isInsertable() && !this.isReadOnly()) {
            databaseRow.add(this.getField(), null);
        }
    }

    @Override
    public void writeUpdateFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isUpdatable() && !this.isReadOnly()) {
            databaseRow.add(this.getField(), null);
        }
    }
}

