/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.accessor.OrmAttributeAccessor;
import org.eclipse.persistence.internal.oxm.documentpreservation.DescriptorLevelDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLValidator;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContext {
    private volatile XMLContextState xmlContextState;

    XMLContext(XMLContextState xmlContextState) {
        this.xmlContextState = xmlContextState;
    }

    public XMLContext(String sessionNames) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class));
    }

    public XMLContext(String sessionNames, ClassLoader classLoader) {
        this(sessionNames, classLoader, null);
    }

    public XMLContext(String sessionNames, String xmlResource) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class), xmlResource);
    }

    public XMLContext(String sessionNames, ClassLoader classLoader, String xmlResource) {
        this.xmlContextState = new XMLContextState(this, sessionNames, classLoader, xmlResource);
    }

    public XMLContext(Project project) {
        this(project, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Project project, ClassLoader classLoader) {
        this(project, classLoader, null);
    }

    public XMLContext(Project project, ClassLoader classLoader, SessionEventListener sessionEventListener) {
        this.xmlContextState = new XMLContextState(this, project, classLoader, sessionEventListener);
    }

    public XMLContext(Collection projects) {
        this(projects, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Collection projects, ClassLoader classLoader) {
        this.xmlContextState = new XMLContextState(this, projects, classLoader);
    }

    public XMLContextState getXMLContextState() {
        return this.xmlContextState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXMLContextState(XMLContextState xcs) {
        XMLContext xMLContext = this;
        synchronized (xMLContext) {
            this.xmlContextState = xcs;
        }
    }

    public void addSession(DatabaseSession sessionToAdd) {
        this.xmlContextState.addSession(sessionToAdd);
    }

    public XMLUnmarshaller createUnmarshaller() {
        return new XMLUnmarshaller(this);
    }

    public XMLUnmarshaller createUnmarshaller(Map<String, Boolean> parserFeatures) {
        return new XMLUnmarshaller(this, parserFeatures);
    }

    public XMLBinder createBinder() {
        return new XMLBinder(this);
    }

    public XMLMarshaller createMarshaller() {
        return new XMLMarshaller(this);
    }

    public XMLValidator createValidator() {
        return new XMLValidator(this);
    }

    public AbstractSession getReadSession(Object object) {
        return this.xmlContextState.getReadSession(object);
    }

    public AbstractSession getReadSession(Class clazz) {
        return this.xmlContextState.getReadSession(clazz);
    }

    public AbstractSession getReadSession(XMLDescriptor xmlDescriptor) {
        return this.xmlContextState.getReadSession(xmlDescriptor);
    }

    public List getSessions() {
        return this.xmlContextState.getSessions();
    }

    public DatabaseSession getSession(int index) {
        return this.xmlContextState.getSession(index);
    }

    public AbstractSession getSession(Object object) {
        return this.xmlContextState.getSession(object);
    }

    public AbstractSession getSession(Class clazz) {
        return this.xmlContextState.getSession(clazz);
    }

    public AbstractSession getSession(XMLDescriptor xmlDescriptor) {
        return this.xmlContextState.getSession(xmlDescriptor);
    }

    public void storeXMLDescriptorByQName(XMLDescriptor xmlDescriptor) {
        this.xmlContextState.storeXMLDescriptorByQName(xmlDescriptor);
    }

    public XMLDescriptor getDescriptor(QName qName) {
        XPathQName xpathQName = new XPathQName(qName, true);
        return this.xmlContextState.getDescriptor(xpathQName);
    }

    public XMLDescriptor getDescriptor(XPathQName xpathQName) {
        return this.xmlContextState.getDescriptor(xpathQName);
    }

    public void addDescriptorByQName(QName qName, XMLDescriptor descriptor) {
        this.xmlContextState.addDescriptorByQName(qName, descriptor);
    }

    public XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return this.xmlContextState.getDescriptorByGlobalType(xPathFragment);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy(AbstractSession session) {
        if (session == null) {
            return null;
        }
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        return login.getDocumentPreservationPolicy();
    }

    public void setupDocumentPreservationPolicy(DatabaseSession session) {
        this.xmlContextState.setupDocumentPreservationPolicy(session);
    }

    public boolean hasDocumentPreservation() {
        return this.xmlContextState.hasDocumentPreservation();
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        for (ClassDescriptor ormDescriptor : ormSession.getDescriptors().values()) {
            Class javaClass = ormDescriptor.getJavaClass();
            AbstractSession oxmSession = null;
            try {
                oxmSession = this.getSession(javaClass);
            }
            catch (XMLMarshalException xMLMarshalException) {}
            if (oxmSession == null) continue;
            ClassDescriptor oxmDescriptor = oxmSession.getDescriptor(javaClass);
            for (DatabaseMapping ormMapping : ormDescriptor.getMappings()) {
                DatabaseMapping ormContainerMapping;
                ClassDescriptor containerDescriptor;
                DatabaseMapping oxmMapping = oxmDescriptor.getMappingForAttributeName(ormMapping.getAttributeName());
                if (oxmMapping == null) continue;
                AttributeAccessor oxmAccessor = oxmMapping.getAttributeAccessor();
                OrmAttributeAccessor newAccessor = new OrmAttributeAccessor(ormMapping.getAttributeAccessor(), oxmAccessor);
                if (ormMapping.isOneToOneMapping() && ((OneToOneMapping)ormMapping).usesIndirection()) {
                    newAccessor.setValueHolderProperty(true);
                }
                newAccessor.setChangeTracking(ormDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                oxmMapping.setAttributeAccessor(newAccessor);
                AttributeAccessor containerAccessor = null;
                Class containerClass = null;
                if (oxmMapping instanceof XMLCompositeObjectMapping) {
                    containerAccessor = ((XMLCompositeObjectMapping)oxmMapping).getInverseReferenceMapping().getAttributeAccessor();
                    containerClass = ((XMLCompositeObjectMapping)oxmMapping).getReferenceClass();
                } else if (oxmMapping instanceof XMLCompositeCollectionMapping) {
                    containerAccessor = ((XMLCompositeCollectionMapping)oxmMapping).getInverseReferenceMapping().getAttributeAccessor();
                    containerClass = ((XMLCompositeCollectionMapping)oxmMapping).getReferenceClass();
                }
                if (containerAccessor == null || (containerDescriptor = ormSession.getDescriptor(containerClass)) == null || (ormContainerMapping = containerDescriptor.getMappingForAttributeName(containerAccessor.getAttributeName())) == null) continue;
                OrmAttributeAccessor ormAccessor = new OrmAttributeAccessor(ormContainerMapping.getAttributeAccessor(), containerAccessor);
                ormAccessor.setChangeTracking(containerDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                ormAccessor.setValueHolderProperty(ormContainerMapping instanceof OneToOneMapping && ((OneToOneMapping)ormContainerMapping).usesIndirection());
                if (oxmMapping instanceof XMLCompositeObjectMapping) {
                    ((XMLCompositeObjectMapping)oxmMapping).getInverseReferenceMapping().setAttributeAccessor(ormAccessor);
                    continue;
                }
                if (!(oxmMapping instanceof XMLCompositeCollectionMapping)) continue;
                ((XMLCompositeCollectionMapping)oxmMapping).getInverseReferenceMapping().setAttributeAccessor(ormAccessor);
            }
            for (DatabaseMapping nextMapping : oxmDescriptor.getMappings()) {
                DatabaseMapping backpointerMapping;
                ClassDescriptor refDescriptor;
                XMLObjectReferenceMapping refMapping;
                if (!(nextMapping instanceof XMLObjectReferenceMapping) || (refMapping = (XMLObjectReferenceMapping)nextMapping).getInverseReferenceMapping().getAttributeAccessor() == null || refMapping.getInverseReferenceMapping().getContainerPolicy() == null || (refDescriptor = ormSession.getClassDescriptor(refMapping.getReferenceClass())) == null || (backpointerMapping = refDescriptor.getMappingForAttributeName(refMapping.getInverseReferenceMapping().getAttributeName())) == null || !backpointerMapping.isCollectionMapping()) continue;
                refMapping.getInverseReferenceMapping().getContainerPolicy().setContainerClass(((CollectionMapping)backpointerMapping).getContainerPolicy().getContainerClass());
            }
        }
    }

    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        DatabaseMapping selfMapping;
        if (xPath == null) {
            return null;
        }
        if (".".equals(xPath)) {
            return (T)object;
        }
        AbstractSession session = this.getSession(object);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        T value = this.getValueByXPath(object, xmlDescriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, returnType);
        if (value == null && (selfMapping = xmlDescriptor.getObjectBuilder().getMappingForField(new XMLField("."))) != null) {
            return this.getValueByXPath(selfMapping.getAttributeValueFromObject(object), selfMapping.getReferenceDescriptor().getObjectBuilder(), new StringTokenizer(xPath, "/"), ((XMLDescriptor)selfMapping.getReferenceDescriptor()).getNamespaceResolver(), returnType);
        }
        return value;
    }

    private <T> T getValueByXPath(Object object, ObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NamespaceResolver namespaceResolver, Class<T> returnType) {
        if (object == null) {
            return null;
        }
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(String.valueOf(xPath) + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = objectBuilder.getMappingForField(xmlField);
            if (mapping == null) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(String.valueOf(xPath) + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = objectBuilder.getMappingForField(xmlField);
                    if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        Object childObject = ((ListContainerPolicy)mapping.getContainerPolicy()).get(xPathFragment.getIndexValue() - 1, mapping.getAttributeValueFromObject(object), null);
                        if (stringTokenizer.hasMoreElements()) {
                            ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                            return this.getValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, returnType);
                        }
                        return (T)childObject;
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    Object childObject = mapping.getAttributeValueFromObject(object);
                    ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                    return this.getValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, returnType);
                }
                return (T)mapping.getAttributeValueFromObject(object);
            }
            xPath = String.valueOf(xPath) + nextToken + "/";
        }
        return null;
    }

    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        AbstractSession session = this.getSession(object);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        this.setValueByXPath(object, xmlDescriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, value);
    }

    private void setValueByXPath(Object object, ObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NamespaceResolver namespaceResolver, Object value) {
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(String.valueOf(xPath) + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = objectBuilder.getMappingForField(xmlField);
            if (mapping == null) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(String.valueOf(xPath) + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = objectBuilder.getMappingForField(xmlField);
                    if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        if (stringTokenizer.hasMoreElements()) {
                            Object childObject = ((ListContainerPolicy)mapping.getContainerPolicy()).get(xPathFragment.getIndexValue() - 1, mapping.getAttributeValueFromObject(object), null);
                            ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                            this.setValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, value);
                            return;
                        }
                        List list = (List)mapping.getAttributeValueFromObject(object);
                        list.add(xPathFragment.getIndexValue() - 1, value);
                        return;
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    Object childObject = mapping.getAttributeValueFromObject(object);
                    ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                    this.setValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, value);
                    return;
                }
                mapping.setAttributeValueInObject(object, value);
                return;
            }
            xPath = String.valueOf(xPath) + nextToken + "/";
        }
    }

    public Object createByQualifiedName(String namespace, String typeName, boolean isGlobalType) throws IllegalArgumentException {
        QName qName = new QName(namespace, typeName);
        XMLDescriptor d = null;
        if (!isGlobalType) {
            d = this.getDescriptor(qName);
        } else {
            XPathFragment frag = new XPathFragment();
            frag.setNamespaceURI(namespace);
            frag.setLocalName(typeName);
            d = this.getDescriptorByGlobalType(frag);
        }
        if (d == null) {
            return null;
        }
        return d.getInstantiationPolicy().buildNewInstance();
    }

    public <T> T createByXPath(Object parentObject, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        AbstractSession session = this.getSession(parentObject);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(parentObject);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        return this.createByXPath(parentObject, xmlDescriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, returnType);
    }

    private <T> T createByXPath(Object object, ObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NamespaceResolver namespaceResolver, Class<T> returnType) {
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(String.valueOf(xPath) + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = objectBuilder.getMappingForField(xmlField);
            if (mapping == null) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() <= 0) continue;
                xmlField.setXPath(String.valueOf(xPath) + nextToken.substring(0, nextToken.indexOf(91)));
                xmlField.initialize();
                mapping = objectBuilder.getMappingForField(xmlField);
                if (mapping == null) continue;
                return (T)mapping.getReferenceDescriptor().getInstantiationPolicy().buildNewInstance();
            }
            if (stringTokenizer.hasMoreElements()) {
                Object childObject = mapping.getAttributeValueFromObject(object);
                ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                return this.createByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, returnType);
            }
            return (T)mapping.getReferenceDescriptor().getInstantiationPolicy().buildNewInstance();
        }
        return null;
    }

    public static class XMLContextState {
        private XMLContext xmlContext;
        private List sessions;
        private Map descriptorsByQName;
        private Map descriptorsByGlobalType;
        private boolean hasDocumentPreservation = false;

        private XMLContextState(XMLContext xmlContext, Collection projects, ClassLoader classLoader) {
            this.xmlContext = xmlContext;
            Iterator iterator = projects.iterator();
            this.sessions = new ArrayList(projects.size());
            this.descriptorsByQName = new HashMap();
            this.descriptorsByGlobalType = new HashMap();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                    SAXPlatform platform = new SAXPlatform();
                    platform.getConversionManager().setLoader(classLoader);
                    project.setLogin(new XMLLogin(platform));
                }
                DatabaseSession session = project.createDatabaseSession();
                session.setLogLevel(8);
                this.setupDocumentPreservationPolicy(session);
                session.login();
                this.sessions.add(session);
                this.storeXMLDescriptorsByQName(session);
            }
        }

        private XMLContextState(XMLContext xmlContext, Project project, ClassLoader classLoader, SessionEventListener sessionEventListener) {
            this.xmlContext = xmlContext;
            if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                platform.getConversionManager().setLoader(classLoader);
                project.setLogin(new XMLLogin(platform));
            }
            this.sessions = new ArrayList(1);
            DatabaseSession session = project.createDatabaseSession();
            if (sessionEventListener != null) {
                session.getEventManager().addListener(sessionEventListener);
            }
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            this.sessions.add(session);
            this.descriptorsByQName = new HashMap();
            this.descriptorsByGlobalType = new HashMap();
            this.storeXMLDescriptorsByQName(session);
        }

        private XMLContextState(XMLContext xmlContext, String sessionNames, ClassLoader classLoader, String xmlResource) {
            this.xmlContext = xmlContext;
            XMLSessionConfigLoader loader = null;
            loader = xmlResource != null ? new XMLSessionConfigLoader(xmlResource) : new XMLSessionConfigLoader();
            this.descriptorsByQName = new HashMap();
            this.descriptorsByGlobalType = new HashMap();
            StringTokenizer st = new StringTokenizer(sessionNames, ":");
            this.sessions = new ArrayList(st.countTokens());
            int index = 0;
            while (st.hasMoreTokens()) {
                this.sessions.add(this.buildSession(st.nextToken(), classLoader, loader));
                ++index;
            }
            int x = index - 1;
            while (x >= 0) {
                this.storeXMLDescriptorsByQName((DatabaseSession)this.sessions.get(x));
                --x;
            }
        }

        private void addDescriptorByQName(QName qName, XMLDescriptor descriptor) {
            XPathQName xpathQName = new XPathQName(qName, true);
            this.addDescriptorByQName(xpathQName, descriptor);
        }

        private void addDescriptorByQName(XPathQName qName, XMLDescriptor descriptor) {
            this.descriptorsByQName.put(qName, descriptor);
        }

        private void addSession(DatabaseSession sessionToAdd) {
            if (sessionToAdd.getDatasourceLogin() == null || !(sessionToAdd.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                sessionToAdd.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = sessionToAdd.getProject().createDatabaseSession();
            if (sessionToAdd.getEventManager().hasListeners()) {
                List<SessionEventListener> listeners = sessionToAdd.getEventManager().getListeners();
                int listenersSize = listeners.size();
                int x = 0;
                while (x < listenersSize) {
                    session.getEventManager().addListener(listeners.get(x));
                    ++x;
                }
            }
            session.setExceptionHandler(sessionToAdd.getExceptionHandler());
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            this.sessions.add(session);
            this.storeXMLDescriptorsByQName(session);
        }

        private DatabaseSession buildSession(String sessionName, ClassLoader classLoader, XMLSessionConfigLoader sessionLoader) throws XMLMarshalException {
            DatabaseSession dbSession = classLoader != null ? (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, classLoader, false, true)) : (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(this.getClass()), false, false, false));
            if (dbSession.getDatasourceLogin() == null || !(dbSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                dbSession.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = dbSession.getProject().createDatabaseSession();
            if (dbSession.getEventManager().hasListeners()) {
                List<SessionEventListener> listeners = dbSession.getEventManager().getListeners();
                int listenersSize = listeners.size();
                int x = 0;
                while (x < listenersSize) {
                    session.getEventManager().addListener(listeners.get(x));
                    ++x;
                }
            }
            session.setExceptionHandler(dbSession.getExceptionHandler());
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            return session;
        }

        private XMLDescriptor getDescriptor(XPathQName qName) {
            return (XMLDescriptor)this.descriptorsByQName.get(qName);
        }

        private XMLDescriptor getDescriptor(QName qName) {
            XPathQName xpathQName = new XPathQName(qName, true);
            return (XMLDescriptor)this.descriptorsByQName.get(xpathQName);
        }

        private XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
            return (XMLDescriptor)this.descriptorsByGlobalType.get(xPathFragment);
        }

        private AbstractSession getReadSession(Class clazz) {
            if (clazz == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(clazz);
                if (xmlDescriptor != null) {
                    next = next.acquireUnitOfWork();
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }

        private AbstractSession getReadSession(XMLDescriptor xmlDescriptor) {
            if (xmlDescriptor == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                if (next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) {
                    next = next.acquireUnitOfWork();
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
        }

        private AbstractSession getReadSession(Object object) {
            if (object == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(object);
                if (xmlDescriptor != null) {
                    next = next.acquireUnitOfWork();
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }

        private AbstractSession getSession(Class clazz) {
            if (clazz == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                if (next.getDescriptor(clazz) != null) {
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }

        private DatabaseSession getSession(int index) {
            if (this.sessions == null) {
                return null;
            }
            return (DatabaseSession)this.sessions.get(index);
        }

        public AbstractSession getSession(Object object) {
            if (object == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                if (next.getDescriptor(object) != null) {
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }

        private AbstractSession getSession(XMLDescriptor xmlDescriptor) {
            if (xmlDescriptor == null) {
                return null;
            }
            int numberOfSessions = this.sessions.size();
            int x = 0;
            while (x < numberOfSessions) {
                AbstractSession next = (AbstractSession)this.sessions.get(x);
                if (next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) {
                    return next;
                }
                ++x;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
        }

        private List getSessions() {
            return this.sessions;
        }

        private boolean hasDocumentPreservation() {
            return this.hasDocumentPreservation;
        }

        private void setupDocumentPreservationPolicy(DatabaseSession session) {
            XMLLogin login = (XMLLogin)session.getDatasourceLogin();
            if (login.getDocumentPreservationPolicy() == null) {
                for (XMLDescriptor xMLDescriptor : session.getProject().getOrderedDescriptors()) {
                    if (!xMLDescriptor.shouldPreserveDocument()) continue;
                    login.setDocumentPreservationPolicy(new DescriptorLevelDocumentPreservationPolicy());
                    break;
                }
            }
            if (login.getDocumentPreservationPolicy() == null) {
                login.setDocumentPreservationPolicy(new NoDocumentPreservationPolicy());
            }
            login.getDocumentPreservationPolicy().initialize(this.xmlContext);
            if (login.getDocumentPreservationPolicy().shouldPreserveDocument() && !this.hasDocumentPreservation) {
                this.hasDocumentPreservation = true;
            }
        }

        private void storeXMLDescriptorByQName(XMLDescriptor xmlDescriptor) {
            Vector tableNames = xmlDescriptor.getTableNames();
            int i = 0;
            while (i < tableNames.size()) {
                int index;
                String defaultRootLocalName;
                String defaultRootName = (String)tableNames.get(i);
                if (defaultRootName != null && (defaultRootLocalName = defaultRootName.substring((index = defaultRootName.indexOf(58)) + 1)) != null && !defaultRootLocalName.equals("")) {
                    XPathQName descriptorQName;
                    if (index > -1) {
                        String defaultRootPrefix = defaultRootName.substring(0, index);
                        String defaultRootNamespaceURI = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                        descriptorQName = new XPathQName(defaultRootNamespaceURI, defaultRootLocalName, true);
                    } else {
                        descriptorQName = xmlDescriptor.getNamespaceResolver() != null ? new XPathQName(xmlDescriptor.getNamespaceResolver().getDefaultNamespaceURI(), defaultRootLocalName, true) : new XPathQName(defaultRootLocalName, true);
                    }
                    if (!xmlDescriptor.hasInheritance() || xmlDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                        this.addDescriptorByQName(descriptorQName, xmlDescriptor);
                    } else {
                        this.storeXMLDescriptorByQName((XMLDescriptor)xmlDescriptor.getInheritancePolicy().getParentDescriptor());
                        XMLDescriptor existingDescriptor = this.getDescriptor(descriptorQName);
                        if (existingDescriptor == null) {
                            this.addDescriptorByQName(descriptorQName, xmlDescriptor);
                        }
                    }
                }
                ++i;
            }
            XMLSchemaReference xmlSchemaReference = xmlDescriptor.getSchemaReference();
            if (xmlSchemaReference != null) {
                String schemaContext = xmlSchemaReference.getSchemaContext();
                if (xmlSchemaReference.getType() == 1 || xmlSchemaReference.getType() == 2) {
                    if (schemaContext != null && schemaContext.lastIndexOf(47) == 0) {
                        schemaContext = schemaContext.substring(1, schemaContext.length());
                        XPathFragment typeFragment = new XPathFragment(schemaContext);
                        if (xmlDescriptor.getNamespaceResolver() != null) {
                            typeFragment.setNamespaceURI(xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(typeFragment.getPrefix()));
                        }
                        this.descriptorsByGlobalType.put(typeFragment, xmlDescriptor);
                    } else {
                        QName qname = xmlSchemaReference.getSchemaContextAsQName();
                        if (qname != null) {
                            if (xmlDescriptor.isWrapper() && xmlDescriptor.getJavaClassName().contains("ObjectWrapper")) {
                                return;
                            }
                            XPathFragment typeFragment = new XPathFragment();
                            typeFragment.setLocalName(qname.getLocalPart());
                            typeFragment.setNamespaceURI(qname.getNamespaceURI());
                            this.descriptorsByGlobalType.put(typeFragment, xmlDescriptor);
                        }
                    }
                }
            }
        }

        private void storeXMLDescriptorsByQName(DatabaseSession session) {
            for (XMLDescriptor xMLDescriptor : session.getProject().getOrderedDescriptors()) {
                this.storeXMLDescriptorByQName(xMLDescriptor);
            }
        }
    }
}

