/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.XRPackager;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;

public class Util {
    public static final String TOPLEVEL = "TOPLEVEL";
    public static final String CLASSES = "classes";
    public static final String DEFAULT_WSDL_LOCATION_URI = "REPLACE_WITH_ENDPOINT_ADDRESS";
    public static final String SWAREF_FILENAME;
    public static final String WSI_SWAREF_XSD_FILE;
    public static final String WEB_XML_FILENAME = "web.xml";
    public static final String DEFAULT_PLATFORM_CLASSNAME = "org.eclipse.persistence.platform.database.OraclePlatform";
    public static final String UNDER_DBWS = "_dbws";
    public static final String WSI_SWAREF = "swaRef";
    public static final String WSI_SWAREF_PREFIX = "ref";
    public static final String WSI_SWAREF_URI = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String WSI_SWAREF_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaRef\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>";
    public static final String THE_INSTANCE_NAME = "theInstance";
    public static final String FINDALL_QUERYNAME = "findAll";
    public static final String CREATE_OPERATION_NAME = "create";
    public static final String UPDATE_OPERATION_NAME = "update";
    public static final String REMOVE_OPERATION_NAME = "delete";
    public static final String DBWS_PROVIDER_PACKAGE = "_dbws";
    public static final String DBWS_PROVIDER_NAME = "DBWSProvider";
    public static final String DOT_CLASS = ".class";
    static final String DOT_JAVA = ".java";
    public static final String DBWS_PROVIDER_CLASS_FILE = "DBWSProvider.class";
    public static final String DBWS_PROVIDER_SOURCE_FILE = "DBWSProvider.java";
    static final String PROVIDER_LISTENER = "ProviderListener";
    public static final String PROVIDER_LISTENER_CLASS_FILE = "ProviderListener.class";
    public static final String PROVIDER_LISTENER_SOURCE_FILE = "ProviderListener.java";
    public static final String PERCENT = "%";
    public static final QName SXF_QNAME_CURSOR;

    public static int getJDBCTypeFromTypeName(String typeName) {
        int jdbcType = 1111;
        if (typeName.equals("NUMERIC")) {
            jdbcType = 2;
        } else if (typeName.equals("VARCHAR")) {
            jdbcType = 12;
        } else if (typeName.equals("VARCHAR2")) {
            jdbcType = 12;
        } else if (typeName.equals("DATE")) {
            jdbcType = 91;
        } else if (typeName.equals("TIME")) {
            jdbcType = 92;
        } else if (typeName.equals("TIMESTAMP")) {
            jdbcType = 93;
        } else if (typeName.equals("DECIMAL")) {
            jdbcType = 3;
        } else if (typeName.equals("INTEGER")) {
            jdbcType = 4;
        } else if (typeName.equals("CHAR")) {
            jdbcType = 1;
        } else if (typeName.equals("NCHAR")) {
            jdbcType = -15;
        } else if (typeName.equals("FLOAT")) {
            jdbcType = 6;
        } else if (typeName.equals("REAL")) {
            jdbcType = 7;
        } else if (typeName.equals("DOUBLE")) {
            jdbcType = 8;
        } else if (typeName.equals("BINARY") || typeName.equals("LONG")) {
            jdbcType = -2;
        } else if (typeName.equals("BLOB")) {
            jdbcType = 2004;
        } else if (typeName.equals("CLOB")) {
            jdbcType = 2005;
        } else if (typeName.equals("NCLOB")) {
            jdbcType = 2011;
        } else if (typeName.equals("RAW")) {
            jdbcType = -3;
        } else if (typeName.equals("LONG RAW")) {
            jdbcType = -4;
        } else if (typeName.equals("UROWID")) {
            jdbcType = 12;
        } else if (typeName.equals("BIGINT")) {
            jdbcType = -5;
        } else if (typeName.equals("STRUCT")) {
            jdbcType = 2002;
        } else if (typeName.equals("ARRAY")) {
            jdbcType = 2003;
        } else if (typeName.equals("BOOLEAN") || typeName.equals("INTEGER") || typeName.equals("SMALLINT") || typeName.equals("TINYINT")) {
            jdbcType = 4;
        }
        return jdbcType;
    }

    public static String getJDBCTypeNameFromType(int jdbcType) {
        String typeName = "OTHER";
        switch (jdbcType) {
            case 2: {
                typeName = "NUMERIC";
                break;
            }
            case 12: {
                typeName = "VARCHAR";
                break;
            }
            case 3: {
                typeName = "DECIMAL";
                break;
            }
            case 1: {
                typeName = "CHAR";
                break;
            }
            case -15: {
                typeName = "NCHAR";
                break;
            }
            case 6: {
                typeName = "FLOAT";
                break;
            }
            case 7: {
                typeName = "REAL";
                break;
            }
            case 8: {
                typeName = "DOUBLE";
                break;
            }
            case -2: {
                typeName = "BINARY";
                break;
            }
            case 2004: {
                typeName = "BLOB";
                break;
            }
            case 2005: {
                typeName = "CLOB";
                break;
            }
            case 2011: {
                typeName = "NCLOB";
                break;
            }
            case -3: {
                typeName = "VARBINARY";
                break;
            }
            case -4: {
                typeName = "LONGVARBINARY";
                break;
            }
            case 91: {
                typeName = "DATE";
                break;
            }
            case 92: {
                typeName = "TIME";
                break;
            }
            case 93: {
                typeName = "TIMESTAMP";
                break;
            }
            case -5: {
                typeName = "BIGINT";
                break;
            }
            case 2003: {
                typeName = "ARRAY";
                break;
            }
            case 2002: {
                typeName = "STRUCT";
            }
        }
        return typeName;
    }

    public static QName getXMLTypeFromJDBCTypeName(String jdbcTypeName) {
        return Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(jdbcTypeName));
    }

    public static QName getXMLTypeFromJDBCType(Short jdbcType) {
        return Util.getXMLTypeFromJDBCType(jdbcType.intValue());
    }

    public static QName getXMLTypeFromJDBCType(int jdbcType) {
        switch (jdbcType) {
            case -15: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return XMLConstants.STRING_QNAME;
            }
            case -5: {
                return XMLConstants.INTEGER_QNAME;
            }
            case -6: 
            case 4: 
            case 5: {
                return XMLConstants.INT_QNAME;
            }
            case 2: 
            case 3: {
                return XMLConstants.DECIMAL_QNAME;
            }
            case 6: 
            case 7: 
            case 8: {
                return XMLConstants.DOUBLE_QNAME;
            }
            case 91: {
                return XMLConstants.DATE_QNAME;
            }
            case 92: {
                return XMLConstants.TIME_QNAME;
            }
            case 93: {
                return XMLConstants.DATE_TIME_QNAME;
            }
        }
        return XMLConstants.BASE_64_BINARY_QNAME;
    }

    public static QName qNameFromString(String qNameAsString, Schema schema) {
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        if (qNameAsString != null) {
            if (qNameAsString.charAt(0) == '{') {
                int endOfNamespaceURI = qNameAsString.indexOf(125);
                if (endOfNamespaceURI == -1) {
                    throw new IllegalArgumentException("cannot create QName from \"" + qNameAsString + "\", missing closing \"}\"");
                }
                nsURI = qNameAsString.substring(1, endOfNamespaceURI);
                localPart = qNameAsString.substring(endOfNamespaceURI + 1);
            } else {
                int colonIdx = qNameAsString.indexOf(58);
                if (colonIdx > 0) {
                    prefix = qNameAsString.substring(0, colonIdx);
                    localPart = qNameAsString.substring(colonIdx + 1);
                    nsURI = schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
                    if (nsURI == null) {
                        nsURI = prefix.equalsIgnoreCase("xsd") ? "http://www.w3.org/2001/XMLSchema" : "";
                    }
                } else {
                    localPart = qNameAsString;
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        }
        return qName;
    }

    public static void addSimpleXMLFormat(Schema schema) {
        ComplexType anyType = new ComplexType();
        anyType.setName("simple-xml-format");
        Sequence anySequence = new Sequence();
        Any any = new Any();
        any.setMinOccurs("0");
        anySequence.addAny(any);
        anyType.setSequence(anySequence);
        schema.addTopLevelComplexTypes(anyType);
    }

    public static boolean noOutArguments(ProcedureType storedProcedure) {
        boolean noOutArguments = true;
        if (storedProcedure.getArguments() != null && storedProcedure.getArguments().size() > 0) {
            for (ArgumentType arg : storedProcedure.getArguments()) {
                if (arg.getDirection() != ArgumentTypeDirection.INOUT && arg.getDirection() != ArgumentTypeDirection.OUT) continue;
                noOutArguments = false;
                break;
            }
        }
        return noOutArguments;
    }

    public static String escapePunctuation(String originalName) {
        if (originalName == null || originalName.length() == 0) {
            return originalName;
        }
        return originalName.trim().replaceAll("[\\p{Punct}&&[^_%]]", "\\\\$0");
    }

    public static boolean isNullStream(OutputStream outputStream) {
        return outputStream == null | outputStream == XRPackager.__nullStream;
    }

    public static String getGeneratedJavaClassName(String tableName, String projectName) {
        String first = tableName.substring(0, 1).toUpperCase();
        String rest = tableName.toLowerCase().substring(1);
        return projectName.toLowerCase() + "." + first + rest;
    }

    public static RelationalDescriptor buildORDescriptor(String tableName, String projectName, List<String> requireCRUDOperations, NamingConventionTransformer nct) {
        RelationalDescriptor desc = new RelationalDescriptor();
        String tablenameAlias = nct.generateSchemaAlias(tableName);
        desc.addTableName(tableName);
        desc.setAlias(tablenameAlias);
        String generatedJavaClassName = Util.getGeneratedJavaClassName(tableName, projectName);
        desc.setJavaClassName(generatedJavaClassName);
        desc.useWeakIdentityMap();
        if (requireCRUDOperations != null && nct.generateSchemaAlias(tableName).equals(tablenameAlias)) {
            requireCRUDOperations.add(tablenameAlias);
        }
        return desc;
    }

    public static XMLDescriptor buildOXDescriptor(String tableName, String projectName, String targetNamespace, NamingConventionTransformer nct) {
        XMLDescriptor xdesc = new XMLDescriptor();
        String generatedJavaClassName = Util.getGeneratedJavaClassName(tableName, projectName);
        xdesc.setJavaClassName(generatedJavaClassName);
        String tablenameAlias = nct.generateSchemaAlias(tableName);
        xdesc.setAlias(tablenameAlias);
        NamespaceResolver nr = new NamespaceResolver();
        nr.setDefaultNamespaceURI(targetNamespace);
        xdesc.setNamespaceResolver(nr);
        xdesc.setDefaultRootElement(tablenameAlias);
        XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
        schemaReference.setSchemaContext("/" + tablenameAlias);
        schemaReference.setType(1);
        xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
        return xdesc;
    }

    public static QName buildCustomQName(String typeString, DBWSBuilder builder) {
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        int colonIdx = typeString.indexOf(58);
        if (colonIdx > 0) {
            prefix = typeString.substring(0, colonIdx);
            nsURI = builder.schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
            nsURI = prefix.equalsIgnoreCase("xsd") ? "http://www.w3.org/2001/XMLSchema" : "";
            localPart = typeString.substring(colonIdx + 1);
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        } else {
            qName = Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + typeString, builder.schema);
        }
        return qName;
    }

    public static boolean requiresSimpleXMLFormat(XRServiceModel serviceModel) {
        boolean requiresSimpleXMLFormat = false;
        for (Operation operation : serviceModel.getOperationsList()) {
            QueryOperation qo;
            if (!(operation instanceof QueryOperation) || !(qo = (QueryOperation)operation).getResult().isSimpleXMLFormat()) continue;
            requiresSimpleXMLFormat = true;
            break;
        }
        return requiresSimpleXMLFormat;
    }

    public static boolean sqlMatch(String pattern, String input) {
        if (pattern != null && pattern.length() > 0) {
            String tmp = pattern.replace('_', '.').replace(PERCENT, ".*");
            Pattern p = Pattern.compile(tmp, 66);
            return p.matcher(input).matches();
        }
        return false;
    }

    public static boolean hasComplexArgs(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            DatabaseType argType = arg.getDataType();
            if (!(argType instanceof PLSQLType) && !(argType instanceof VArrayType) && !(argType instanceof ObjectType) && !(argType instanceof ObjectTableType)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPLSQLScalarArgs(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            DatabaseType argType = arg.getDataType();
            if (argType != ScalarDatabaseTypeEnum.BOOLEAN_TYPE && argType != ScalarDatabaseTypeEnum.BINARY_INTEGER_TYPE && argType != ScalarDatabaseTypeEnum.PLS_INTEGER_TYPE) continue;
            return true;
        }
        return false;
    }

    static {
        WSI_SWAREF_XSD_FILE = SWAREF_FILENAME = WSI_SWAREF.toLowerCase() + ".xsd";
        SXF_QNAME_CURSOR = new QName("", "cursor of simple-xml-format");
    }

    public static enum InOut {
        IN,
        OUT,
        INOUT,
        RETURN;

    }
}

