/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RootSCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class TopLinkSessionsAdapter
extends RootSCAdapter {
    public static final String VERSION_PROPERTY = "version";
    private Collection sessions;
    public static final String SESSIONS_COLLECTION = "sessions";
    public static final String VERSION_9_0_4 = "9.0.4";
    public static final String VERSION_10g = "10g";
    private Collection managedSessions;
    private static final String CR = System.getProperty("line.separator");

    public TopLinkSessionsAdapter(SCSessionsProperties properties, Preferences preferences, boolean buildModel) {
        super(properties, preferences, buildModel);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        CollectionTools.addAll((Collection)children, (Iterator)this.sessionBrokers());
        CollectionTools.addAll((Collection)children, (Iterator)this.databaseSessions());
    }

    protected Object buildModel() {
        return new SessionConfigs();
    }

    protected void initialize() {
        super.initialize();
        this.sessions = new Vector();
        this.managedSessions = new Vector();
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.topLinkSessions().setVersion(Version.getVersion());
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.sessions.addAll(this.adaptAll(this.getSessionConfigs()));
        this.initializeBroker();
    }

    private void initializeBroker() {
        Iterator i = this.sessionBrokers();
        while (i.hasNext()) {
            SessionBrokerAdapter broker = (SessionBrokerAdapter)i.next();
            Iterator j = broker.sessionNames();
            while (j.hasNext()) {
                broker.internalAddSessionNamed((String)j.next());
            }
        }
    }

    protected void postInitializationFromModel() {
        Iterator i = this.allSessions();
        while (i.hasNext()) {
            ((SCAdapter)((Object)i.next())).postInitializationFromModel();
        }
    }

    protected void preSaving() {
        Iterator i = this.allSessions();
        while (i.hasNext()) {
            ((SCAdapter)((Object)i.next())).preSaving();
        }
    }

    protected void postSaving() {
        Iterator i = this.allSessions();
        while (i.hasNext()) {
            ((SCAdapter)((Object)i.next())).postSaving();
        }
    }

    public String getVersion() {
        return this.topLinkSessions().getVersion();
    }

    void setVersion(String version) {
        String old = this.topLinkSessions().getVersion();
        this.topLinkSessions().setVersion(version);
        this.firePropertyChanged(VERSION_PROPERTY, old, version);
    }

    public Collection getSessionsNames() {
        return this.getSessionsNames(this.sessions());
    }

    public Collection getManagedSessionsNames() {
        return this.getSessionsNames(this.managedSessions());
    }

    public Collection getAllSessionsNames() {
        return this.getSessionsNames(this.allSessions());
    }

    public Collection getDatabaseSessionsNames() {
        return this.getSessionsNames(this.databaseSessions());
    }

    Collection getSessionsNames(Iterator sessions) {
        return CollectionTools.collection((Iterator)new TransformationIterator(sessions){

            protected Object transform(Object next) {
                return ((SessionAdapter)next).getName();
            }
        });
    }

    Iterator getNames(Iterator sessions) {
        return new TransformationIterator(sessions){

            protected Object transform(Object next) {
                return ((SessionAdapter)next).getName();
            }
        };
    }

    public Iterator sessionNames() {
        return this.getNames(this.sessions());
    }

    public Iterator managedSessionNames() {
        return this.getNames(this.managedSessions());
    }

    public Iterator databaseSessionNames() {
        return this.getNames(this.databaseSessions());
    }

    public Iterator allSessionNames() {
        return this.getNames(this.allSessions());
    }

    public Iterator sessions() {
        return new CloneIterator(this.sessions);
    }

    public int sessionsSize() {
        return this.sessions.size();
    }

    public Iterator managedSessions() {
        return new CloneIterator(this.managedSessions);
    }

    public Iterator sessionBrokers() {
        return new FilteringIterator(this.sessions()){

            protected boolean accept(Object next) {
                return ((SessionAdapter)next).isBroker();
            }
        };
    }

    public Iterator sessionBrokerNames() {
        return this.getNames(this.sessionBrokers());
    }

    Iterator managedSessions(final SessionBrokerAdapter broker) {
        return new FilteringIterator(this.managedSessions()){

            protected boolean accept(Object next) {
                return ((DatabaseSessionAdapter)next).getBroker() == broker;
            }
        };
    }

    public int managedSessionsSize() {
        return this.managedSessions.size();
    }

    public Iterator databaseSessions() {
        return new FilteringIterator(this.sessions()){

            protected boolean accept(Object next) {
                return !((SessionAdapter)next).isBroker();
            }
        };
    }

    public int databaseSessionsSize() {
        return CollectionTools.collection((Iterator)this.databaseSessions()).size();
    }

    public Iterator allSessions() {
        return new CompositeIterator(this.sessions(), this.managedSessions());
    }

    private Collection getSessionConfigs() {
        return this.topLinkSessions().getSessionConfigs();
    }

    public SessionAdapter sessionNamed(String name) {
        Iterator i = this.sessions();
        while (i.hasNext()) {
            SessionAdapter session = (SessionAdapter)i.next();
            if (!name.equals(session.getName())) continue;
            return session;
        }
        return null;
    }

    public SessionAdapter databaseSessionNamed(String name) {
        SessionAdapter session = this.sessionNamed(name);
        if (session.isBroker()) {
            return null;
        }
        return session;
    }

    public DatabaseSessionAdapter managedSessionNamed(String name) {
        Iterator i = this.managedSessions();
        while (i.hasNext()) {
            DatabaseSessionAdapter session = (DatabaseSessionAdapter)i.next();
            if (!name.equals(session.getName())) continue;
            return session;
        }
        return null;
    }

    private SessionAdapter addSession(SessionAdapter sessionAdapter) {
        sessionAdapter.markEntireConfigurationClean();
        this.getSessionConfigs().add(sessionAdapter.getModel());
        this.addItemToCollection(sessionAdapter, this.sessions, SESSIONS_COLLECTION);
        return sessionAdapter;
    }

    public void removeSession(SessionAdapter sessionAdapter) {
        this.getSessionConfigs().remove(sessionAdapter.getModel());
        this.removeItemFromCollection(sessionAdapter, this.sessions, SESSIONS_COLLECTION);
    }

    public void removeSessions(Collection sessionAdapters) {
        this.getSessionConfigs().removeAll(this.modelObjectsFrom(sessionAdapters));
        this.removeItemsFromCollection(sessionAdapters, this.sessions, SESSIONS_COLLECTION);
    }

    public DatabaseSessionAdapter addDatabaseSessionNamed(String name, ServerPlatform sp, DataSource ds) {
        DatabaseSessionAdapter session = new DatabaseSessionAdapter(this, name, sp, ds);
        return (DatabaseSessionAdapter)this.addSession(session);
    }

    public ServerSessionAdapter addServerSessionNamed(String name, ServerPlatform sp, DataSource ds) {
        ServerSessionAdapter session = new ServerSessionAdapter(this, name, sp, ds);
        return (ServerSessionAdapter)this.addSession(session);
    }

    public SessionBrokerAdapter addSessionBrokerNamed(String name, ServerPlatform sp) {
        SessionBrokerAdapter broker = new SessionBrokerAdapter(this, name, sp);
        return (SessionBrokerAdapter)this.addSession(broker);
    }

    public void removeSessionNamed(String name) {
        this.removeSession(this.sessionNamed(name));
    }

    private final SessionConfigs topLinkSessions() {
        return (SessionConfigs)this.getModel();
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(" [").append(CR);
        Iterator i = this.allSessions();
        while (i.hasNext()) {
            SessionAdapter session = (SessionAdapter)i.next();
            sb.append("\t\t");
            session.toString(sb);
            if (!i.hasNext()) continue;
            sb.append(',').append(CR);
        }
        sb.append(" ] ");
    }

    DatabaseSessionAdapter addManagedSessionNamed(String name) {
        SessionAdapter session = this.sessionNamed(name);
        if (session == null) {
            throw new NoSuchElementException();
        }
        if (session.isBroker()) {
            throw new IllegalArgumentException(session.toString());
        }
        this.removeItemFromCollection(session, this.sessions, SESSIONS_COLLECTION);
        this.managedSessions.add(session);
        return (DatabaseSessionAdapter)session;
    }

    DatabaseSessionAdapter removeManagedSessionNamed(String name) {
        DatabaseSessionAdapter session = this.managedSessionNamed(name);
        this.managedSessions.remove(session);
        this.addItemToCollection(session, this.sessions, SESSIONS_COLLECTION);
        return session;
    }

    Collection removeManagedSessions(Collection sessions) {
        this.managedSessions.removeAll(sessions);
        this.addItemsToCollection(sessions, this.sessions, SESSIONS_COLLECTION);
        return sessions;
    }
}

