/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class NonSynchronizedSubVector
extends NonSynchronizedVector {
    private Vector l;
    private int offset;
    private int size;

    public NonSynchronizedSubVector(Vector list, int fromIndex, int toIndex) {
        super(0);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    public Object set(int index, Object element) {
        return this.l.set(index + this.offset, element);
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public Object elementAt(int index) {
        return this.get(index);
    }

    public Object firstElement() {
        return this.get(0);
    }

    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    public int indexOf(Object elem, int index) {
        int size = this.size();
        if (elem == null) {
            int i = index;
            while (i < size) {
                if (this.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = index;
            while (i < size) {
                if (elem.equals(this.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int index) {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " >= " + size);
        }
        if (elem == null) {
            int i = index;
            while (i >= 0) {
                if (this.get(i) == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = index;
            while (i >= 0) {
                if (elem.equals(this.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object get(int index) {
        return this.l.get(index + this.offset);
    }

    public int size() {
        return this.size;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(index + this.offset, element);
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int index) {
        Object result = this.l.remove(index + this.offset);
        --this.size;
        ++this.modCount;
        return result;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.l.addAll(this.offset + index, c);
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < NonSynchronizedSubVector.this.size();
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedSubVector.this.elementCount) {
                    return NonSynchronizedSubVector.this.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.l.toArray(), this.offset, result, 0, this.size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.l.toArray(), this.offset, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new ListIterator(index){
            private ListIterator i;
            {
                this.i = NonSynchronizedSubVector.this.l.listIterator(n + NonSynchronizedSubVector.this.offset);
            }

            public boolean hasNext() {
                return this.nextIndex() < NonSynchronizedSubVector.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - NonSynchronizedSubVector.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - NonSynchronizedSubVector.this.offset;
            }

            public void remove() {
                this.i.remove();
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size - 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }

            public void set(Object o) {
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size + 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }
        };
    }
}

