/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.jboss;

import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.platform.server.JMXServerPlatformBase;
import org.eclipse.persistence.services.jboss.MBeanJBossRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.jboss.JBossTransactionController;

public class JBossPlatform
extends JMXServerPlatformBase
implements JMXEnabledPlatform {
    static {
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "/deploy/";
        APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = ".jar/";
        APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = ".war/";
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "/}";
        APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "postfix,match~not;required^";
    }

    public JBossPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.enableRuntimeServices();
        this.prepareServerSpecificServicesMBean();
    }

    public boolean isRuntimeServicesEnabledDefault() {
        return true;
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = JBossTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    public JPAClassLoaderHolder getNewTempClassLoader(PersistenceUnitInfo puInfo) {
        ClassLoader realClassLoader = puInfo.getClassLoader();
        AbstractSessionLog.getLog().log(6, "persistence_unit_processor_jboss_temp_classloader_bypassed", puInfo.getPersistenceUnitName(), realClassLoader);
        return new JPAClassLoaderHolder(realClassLoader, false);
    }

    public void prepareServerSpecificServicesMBean() {
        if (this.shouldRegisterRuntimeBean) {
            this.setRuntimeServicesMBean(new MBeanJBossRuntimeServices(this.getDatabaseSession()));
        }
    }

    public void serverSpecificRegisterMBean() {
        super.serverSpecificRegisterMBean();
        this.initializeApplicationNameAndModuleName();
    }
}

