/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.utils.rename;

import java.util.Comparator;
import org.eclipse.persistence.utils.rename.RenameFileData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameValue {
    private String sourceValue;
    private String replaceValue;

    public RenameValue(String source, String replace) {
        this.sourceValue = source;
        this.replaceValue = replace;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public String getReplaceValue() {
        return this.replaceValue;
    }

    public RenameFileData replace(RenameFileData data) {
        int pos;
        int srcLen = this.getSourceValue().length();
        int replaceLen = this.getReplaceValue().length();
        String newStr = data.getFileContentsString();
        int lastPos = pos = newStr.indexOf(this.getSourceValue());
        while (pos >= 0) {
            String firstPart = newStr.substring(0, pos);
            String lastPart = newStr.substring(pos + srcLen, newStr.length());
            newStr = firstPart + this.getReplaceValue() + lastPart;
            lastPos = pos + replaceLen;
            pos = newStr.indexOf(this.getSourceValue(), lastPos);
            data.setChanged(true);
        }
        data.setFileContentsString(newStr);
        return data;
    }

    public String toString() {
        return "REPLACE> " + this.getSourceValue() + " -> " + this.getReplaceValue();
    }

    protected static Comparator<RenameValue> renameValueComparator() {
        return new Comparator<RenameValue>(){

            @Override
            public int compare(RenameValue rv1, RenameValue rv2) {
                return rv2.getSourceValue().length() - rv1.getSourceValue().length();
            }
        };
    }
}

