/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBArrayAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private String componentClassName;
    private Class componentClass;
    private String adaptedClassName;
    private Class<? extends ManyValue> adaptedClass;
    private ClassLoader classLoader;

    public JAXBArrayAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy containerPolicy, ClassLoader classLoader) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
        this.classLoader = classLoader;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object arrayValue = this.nestedAccessor.getAttributeValueFromObject(object);
        if (arrayValue == null) {
            return null;
        }
        int length = Array.getLength(arrayValue);
        Object results = this.containerPolicy.containerInstance(length);
        if (this.adaptedClass == null) {
            int x = 0;
            while (x < length) {
                this.containerPolicy.addInto(Array.get(arrayValue, x), results, null);
                ++x;
            }
        } else {
            int x = 0;
            while (x < length) {
                try {
                    ManyValue manyValue = (ManyValue)PrivilegedAccessHelper.newInstanceFromClass(this.adaptedClass);
                    manyValue.setItem(Array.get(arrayValue, x));
                    this.containerPolicy.addInto((Object)manyValue, results, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ++x;
            }
        }
        return results;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Object firstItem;
        List listValue = (List)value;
        if (listValue == null || listValue.isEmpty()) {
            this.nestedAccessor.setAttributeValueInObject(object, null);
        }
        ArrayList<Integer> dimensionsList = new ArrayList<Integer>();
        int size = listValue.size();
        dimensionsList.add(size);
        if (size > 0 && (firstItem = listValue.get(0)) instanceof ManyValue) {
            this.getDimensions(dimensionsList, ((ManyValue)firstItem).getItem());
        }
        int[] dimensions = new int[dimensionsList.size()];
        int x = 0;
        while (x < dimensions.length) {
            dimensions[x] = (Integer)dimensionsList.get(x);
            ++x;
        }
        Object arrayValue = Array.newInstance(this.componentClass, dimensions);
        Iterator collectionValueIterator = listValue.iterator();
        int index = 0;
        while (collectionValueIterator.hasNext()) {
            Object next = collectionValueIterator.next();
            if (next instanceof ManyValue) {
                next = ((ManyValue)next).getItem();
            }
            Array.set(arrayValue, index++, next);
        }
        this.nestedAccessor.setAttributeValueInObject(object, arrayValue);
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.adaptedClass == null && this.adaptedClassName != null) {
            try {
                this.adaptedClass = PrivilegedAccessHelper.getClassForName((String)this.adaptedClassName, (boolean)true, (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.componentClass == null && this.componentClassName != null) {
            try {
                this.componentClass = PrivilegedAccessHelper.getClassForName((String)this.componentClassName, (boolean)true, (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setAdaptedClass(Class adaptedClass) {
        this.adaptedClass = this.componentClass;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public void setAdaptedClassName(String adaptedClassName) {
        this.adaptedClassName = adaptedClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    private List<Integer> getDimensions(List<Integer> dimensions, Object array) {
        dimensions.add(Array.getLength(array));
        Object nestedArray = Array.get(array, 0);
        if (nestedArray.getClass().isArray()) {
            return this.getDimensions(dimensions, nestedArray);
        }
        return dimensions;
    }

    public void setNestedAccessor(AttributeAccessor a) {
        this.nestedAccessor = a;
    }

    public void setIsWriteOnly(boolean aBoolean) {
        super.setIsWriteOnly(aBoolean);
        this.nestedAccessor.setIsWriteOnly(aBoolean);
    }

    public void setIsReadOnly(boolean aBoolean) {
        super.setIsReadOnly(aBoolean);
        this.nestedAccessor.setIsReadOnly(aBoolean);
    }
}

