/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.persistence.internal.jpa.jpql.DeleteQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.ObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReadAllQueryBuilder;
import org.eclipse.persistence.internal.jpa.jpql.UpdateQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaManagedTypeProvider;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.EclipseLinkJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HermesParser {
    private DatabaseQueryVisitor databaseQueryVisitor;
    private DeleteQueryVisitor deleteQueryVisitor;
    private final JPQLQueryContext queryContext = new JPQLQueryContext();
    private ReadAllQueryBuilder readAllQueryBuilder;
    private ObjectLevelReadQueryVisitor readAllQueryVisitor;
    private UpdateQueryVisitor updateQueryVisitor;
    private boolean validateQueries;

    public HermesParser(boolean validateQueries) {
        this.validateQueries = validateQueries;
    }

    private void addArguments(DatabaseQuery databaseQuery) {
        for (Map.Entry<String, Class<?>> inputParameters : this.queryContext.inputParameters()) {
            databaseQuery.addArgument(inputParameters.getKey().substring(1), inputParameters.getValue());
        }
    }

    private IManagedTypeProvider buildProvider(AbstractSession session) {
        return new JavaManagedTypeProvider(session);
    }

    public DatabaseQuery buildQuery(String jpqlQuery, AbstractSession session) {
        return this.populateQueryImp(jpqlQuery, null, session);
    }

    private ReadAllQuery buildReadAllQuery(SelectStatement expression) {
        ReadAllQueryBuilder visitor = this.readAllQueryBuilder();
        try {
            expression.accept((ExpressionVisitor)visitor);
            ReadAllQuery readAllQuery = visitor.query;
            return readAllQuery;
        }
        finally {
            visitor.query = null;
        }
    }

    public org.eclipse.persistence.expressions.Expression buildSelectionCriteria(String entityName, String selectionCriteria, AbstractSession session) {
        try {
            JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)selectionCriteria, this.jpqlGrammar(), "conditional_expression", this.validateQueries);
            this.queryContext.cache(session, null, jpqlExpression, selectionCriteria);
            this.queryContext.addRangeVariableDeclaration(entityName, "this");
            org.eclipse.persistence.expressions.Expression expression = this.queryContext.buildExpression(jpqlExpression.getQueryStatement());
            return expression;
        }
        finally {
            this.queryContext.dispose();
        }
    }

    private DatabaseQueryVisitor databaseQueryVisitor() {
        if (this.databaseQueryVisitor == null) {
            this.databaseQueryVisitor = new DatabaseQueryVisitor();
        }
        return this.databaseQueryVisitor;
    }

    private DeleteQueryVisitor deleteQueryVisitor() {
        if (this.deleteQueryVisitor == null) {
            this.deleteQueryVisitor = new DeleteQueryVisitor(this.queryContext);
        }
        return this.deleteQueryVisitor;
    }

    private JPQLGrammar jpqlGrammar() {
        return DefaultEclipseLinkJPQLGrammar.instance();
    }

    private void logProblems(List<JPQLQueryProblem> problems, String messageKey) {
        ResourceBundle bundle = ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int count = problems.size();
        while (index < count) {
            JPQLQueryProblem problem = problems.get(index);
            String message = bundle.getString(problem.getMessageKey());
            message = MessageFormat.format(message, problem.getMessageArguments());
            sb.append("\n");
            sb.append("[");
            sb.append(problem.getStartPosition());
            sb.append(", ");
            sb.append(problem.getEndPosition());
            sb.append("] ");
            sb.append(message);
            ++index;
        }
        String errorMessage = bundle.getString(messageKey);
        errorMessage = MessageFormat.format(errorMessage, this.queryContext.getJPQLQuery(), sb);
    }

    private ObjectLevelReadQueryVisitor objectLevelReadQueryVisitor() {
        if (this.readAllQueryVisitor == null) {
            this.readAllQueryVisitor = new ObjectLevelReadQueryVisitor(this.queryContext);
        }
        return this.readAllQueryVisitor;
    }

    public void populateQuery(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        this.populateQueryImp(jpqlQuery, query, session);
    }

    private DatabaseQuery populateQueryImp(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlQuery, this.jpqlGrammar(), this.validateQueries);
        this.queryContext.cache(session, (DatabaseQuery)query, jpqlExpression, jpqlQuery);
        try {
            this.validate(jpqlExpression, session, jpqlQuery);
            jpqlExpression.accept((ExpressionVisitor)this.databaseQueryVisitor());
            if (query == null) {
                query = this.queryContext.getDatabaseQuery();
                this.addArguments((DatabaseQuery)query);
            }
            DatabaseQuery databaseQuery = query;
            return databaseQuery;
        }
        finally {
            this.queryContext.dispose();
        }
    }

    private ReadAllQueryBuilder readAllQueryBuilder() {
        if (this.readAllQueryBuilder == null) {
            this.readAllQueryBuilder = new ReadAllQueryBuilder(this.queryContext);
        }
        return this.readAllQueryBuilder;
    }

    private UpdateQueryVisitor updateQueryVisitor() {
        if (this.updateQueryVisitor == null) {
            this.updateQueryVisitor = new UpdateQueryVisitor(this.queryContext);
        }
        return this.updateQueryVisitor;
    }

    private void validate(JPQLExpression expression, AbstractSession session, String jpqlQuery) {
        if (this.validateQueries) {
            ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
            EclipseLinkJPQLQueryHelper queryHelper = new EclipseLinkJPQLQueryHelper(this.jpqlGrammar());
            queryHelper.setJPQLExpression(expression);
            queryHelper.setQuery((IQuery)new JavaQuery(this.buildProvider(session), (CharSequence)jpqlQuery));
            queryHelper.validateGrammar((Expression)expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(problems, "HERMES_PARSER_GRAMMAR_VALIDATOR_ERROR_MESSAGE");
                problems.clear();
            }
            queryHelper.validateSemantic((Expression)expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(problems, "HERMES_PARSER_SEMANTIC_VALIDATOR_ERROR_MESSAGE");
            }
        }
    }

    private class DatabaseQueryVisitor
    extends AbstractExpressionVisitor {
        private DatabaseQueryVisitor() {
        }

        public void visit(DeleteStatement expression) {
            DeleteAllQuery query = (DeleteAllQuery)HermesParser.this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new DeleteAllQuery();
                HermesParser.this.queryContext.setDatabasQuery((DatabaseQuery)query);
            }
            query.setJPQLString(HermesParser.this.queryContext.getJPQLQuery());
            query.setSession(HermesParser.this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            DeleteQueryVisitor visitor = HermesParser.this.deleteQueryVisitor();
            try {
                visitor.query = query;
                expression.accept((ExpressionVisitor)visitor);
            }
            finally {
                visitor.query = null;
            }
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)HermesParser.this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = HermesParser.this.buildReadAllQuery(expression);
                HermesParser.this.queryContext.setDatabasQuery((DatabaseQuery)query);
            }
            query.setJPQLString(HermesParser.this.queryContext.getJPQLQuery());
            if (query.isReportQuery()) {
                HermesParser.this.queryContext.populateReportQuery((AbstractSelectStatement)expression, (ReportQuery)query);
            } else {
                ObjectLevelReadQueryVisitor visitor = HermesParser.this.objectLevelReadQueryVisitor();
                try {
                    visitor.query = query;
                    expression.accept((ExpressionVisitor)visitor);
                }
                finally {
                    visitor.query = null;
                }
            }
        }

        public void visit(UpdateStatement expression) {
            UpdateAllQuery query = (UpdateAllQuery)HermesParser.this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new UpdateAllQuery();
                HermesParser.this.queryContext.setDatabasQuery((DatabaseQuery)query);
            }
            query.setJPQLString(HermesParser.this.queryContext.getJPQLQuery());
            query.setSession(HermesParser.this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            UpdateQueryVisitor visitor = HermesParser.this.updateQueryVisitor();
            try {
                visitor.query = query;
                expression.accept((ExpressionVisitor)visitor);
            }
            finally {
                visitor.query = null;
            }
        }
    }
}

