/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSQLRecordMetadata
extends PLSQLComplexTypeMetadata {
    private List<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();

    public PLSQLRecordMetadata() {
        super("<plsql-record>");
    }

    public PLSQLRecordMetadata(MetadataAnnotation record, MetadataAccessor accessor) {
        super(record, accessor);
        Object[] objectArray = (Object[])record.getAttributeArray("fields");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            this.fields.add(new PLSQLParameterMetadata((MetadataAnnotation)field, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        PLSQLRecordMetadata parameter;
        if (objectToCompare instanceof PLSQLRecordMetadata && !this.valuesMatch(this.fields, (parameter = (PLSQLRecordMetadata)objectToCompare).getFields())) {
            return false;
        }
        return super.equals(objectToCompare);
    }

    public List<PLSQLParameterMetadata> getFields() {
        return this.fields;
    }

    public PLSQLrecord process(MetadataProject project) {
        PLSQLrecord record = new PLSQLrecord();
        super.process((ComplexDatabaseType)record, project);
        for (PLSQLParameterMetadata field : this.fields) {
            PLSQLargument argument = new PLSQLargument();
            argument.name = field.getName();
            argument.databaseType = PLSQLParameterMetadata.getDatabaseTypeEnum(field.getDatabaseType(), project);
            if (field.getLength() != null) {
                argument.length = field.getLength();
            }
            if (field.getPrecision() != null) {
                argument.precision = field.getPrecision();
            }
            if (field.getScale() != null) {
                argument.scale = field.getScale();
            }
            record.addField(argument);
        }
        return record;
    }

    public void setFields(List<PLSQLParameterMetadata> fields) {
        this.fields = fields;
    }
}

