/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;

public abstract class BaseJPQLQueryFormatter
implements StateObjectVisitor,
IJPQLQueryFormatter {
    protected final IJPQLQueryFormatter.IdentifierStyle style;
    protected final StringBuilder writer;
    protected static final String COMMA = ",";
    protected static final String COMMA_SPACE = ", ";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String SPACE = " ";

    protected BaseJPQLQueryFormatter(IJPQLQueryFormatter.IdentifierStyle style) {
        Assert.isNotNull((Object)style, "The IdentifierStyle cannot be null");
        this.style = style;
        this.writer = new StringBuilder();
    }

    protected String capitalizeEachWord(String identifier) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(identifier, SPACE);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            sb.append(Character.toUpperCase(token.charAt(0)));
            sb.append(token.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    protected String formatIdentifier(String identifier) {
        switch (this.style) {
            case CAPITALIZE_EACH_WORD: {
                return this.capitalizeEachWord(identifier);
            }
            case LOWERCASE: {
                return identifier.toLowerCase();
            }
        }
        return identifier.toUpperCase();
    }

    protected IJPQLQueryFormatter.IdentifierStyle getIdentifierStyle() {
        return this.style;
    }

    public String toString() {
        return this.writer.toString();
    }

    public String toString(StateObject stateObject) {
        if (this.writer.length() > 0) {
            this.writer.delete(0, this.writer.length());
        }
        stateObject.accept(this);
        return this.toString();
    }
}

