/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractJoinStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractRangeVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.JoinStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.VariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdentificationVariableDeclarationStateObject
extends AbstractListHolderStateObject<AbstractJoinStateObject>
implements VariableDeclarationStateObject {
    private AbstractRangeVariableDeclarationStateObject rangeVariableDeclaration;
    public static final String JOINS_LIST = "joins";

    protected AbstractIdentificationVariableDeclarationStateObject(AbstractFromClauseStateObject parent) {
        super(parent);
    }

    protected AbstractIdentificationVariableDeclarationStateObject(AbstractFromClauseStateObject parent, String root, String identificationVariable) {
        super(parent);
        this.setRootPath(root);
        this.setIdentificationVariable(identificationVariable);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        children.add(this.rangeVariableDeclaration);
        super.addChildren(children);
    }

    public JoinStateObject addInnerJoin(String path, String identificationVariable) {
        return this.addJoin("INNER JOIN", path, identificationVariable);
    }

    public JoinStateObject addJoin(String joinType) {
        JoinStateObject stateObject = new JoinStateObject(this, joinType, false);
        this.addItem(stateObject);
        return stateObject;
    }

    public JoinStateObject addJoin(String joinType, ListIterator<String> paths, String identificationVariable) {
        JoinStateObject stateObject = this.addJoin(joinType);
        stateObject.setJoinAssociationPaths(paths);
        stateObject.setIdentificationVariable(identificationVariable);
        return stateObject;
    }

    public JoinStateObject addJoin(String path, String identificationVariable) {
        return this.addJoin("JOIN", path, identificationVariable);
    }

    public JoinStateObject addJoin(String joinType, String path, String identificationVariable) {
        JoinStateObject stateObject = this.addJoin(joinType);
        stateObject.setJoinAssociationPath(path);
        stateObject.setIdentificationVariable(identificationVariable);
        return stateObject;
    }

    public JoinStateObject addLeftJoin(String path, String identificationVariable) {
        return this.addJoin("LEFT JOIN", path, identificationVariable);
    }

    public JoinStateObject addLeftOuterJoin(String path, String identificationVariable) {
        return this.addJoin("LEFT OUTER JOIN", path, identificationVariable);
    }

    protected abstract AbstractRangeVariableDeclarationStateObject buildRangeVariableDeclarationStateObject();

    @Override
    public IdentificationVariableDeclaration getExpression() {
        return (IdentificationVariableDeclaration)super.getExpression();
    }

    public String getIdentificationVariable() {
        return this.getRangeVariableDeclaration().getIdentificationVariable();
    }

    @Override
    public AbstractFromClauseStateObject getParent() {
        return (AbstractFromClauseStateObject)super.getParent();
    }

    public AbstractRangeVariableDeclarationStateObject getRangeVariableDeclaration() {
        return this.rangeVariableDeclaration;
    }

    public String getRootPath() {
        return this.getRangeVariableDeclaration().getRootPath();
    }

    public StateObject getRootStateObject() {
        return this.getRangeVariableDeclaration().getRootStateObject();
    }

    @Override
    public IterableListIterator<IdentificationVariableStateObject> identificationVariables() {
        ArrayList<IdentificationVariableStateObject> stateObjects = new ArrayList<IdentificationVariableStateObject>();
        stateObjects.add(this.rangeVariableDeclaration.getIdentificationVariableStateObject());
        for (JoinStateObject join : this.joins()) {
            stateObjects.add(join.getIdentificationVariableStateObject());
        }
        return new CloneListIterator<IdentificationVariableStateObject>(stateObjects);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.rangeVariableDeclaration = this.buildRangeVariableDeclarationStateObject();
    }

    public List<JoinStateObject> joins() {
        final ArrayList<JoinStateObject> joins = new ArrayList<JoinStateObject>();
        AbstractStateObjectVisitor visitor = new AbstractStateObjectVisitor(){

            public void visit(JoinStateObject stateObject) {
                joins.add(stateObject);
            }
        };
        for (AbstractJoinStateObject child : this.items()) {
            child.accept(visitor);
        }
        return joins;
    }

    @Override
    protected String listName() {
        return JOINS_LIST;
    }

    public void parseJoin(String jpqlFragment) {
        this.buildStateObject(jpqlFragment, "join");
    }

    public void setExpression(IdentificationVariableDeclaration expression) {
        super.setExpression(expression);
    }

    public void setIdentificationVariable(String identificationVariable) {
        this.rangeVariableDeclaration.setIdentificationVariable(identificationVariable);
    }

    public void setRootPath(String root) {
        this.getRangeVariableDeclaration().setRootPath(root);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        this.rangeVariableDeclaration.toString(writer);
        if (this.itemsSize() > 0) {
            writer.append(' ');
            this.toStringItems(writer, false);
        }
    }
}

