/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;

public class AllOrAnyExpressionStateObject
extends AbstractSingleEncapsulatedExpressionStateObject {
    private String identifier;
    public static final String IDENTIFIER_PROPERTY = "identifier";

    public AllOrAnyExpressionStateObject(StateObject parent, String identifier) {
        super(parent);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public AllOrAnyExpressionStateObject(StateObject parent, String identifier, StateObject stateObject) {
        super(parent, stateObject);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public AllOrAnyExpressionStateObject(StateObject parent, String identifier, String jpqlFragment) {
        super(parent, jpqlFragment);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public AllOrAnyExpression getExpression() {
        return (AllOrAnyExpression)super.getExpression();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected String getQueryBNFId() {
        return "subquery";
    }

    public void setExpression(AllOrAnyExpression expression) {
        super.setExpression(expression);
    }

    public void setIdentifier(String identifier) {
        this.validateIdentifier(identifier);
        String oldIdentifier = this.identifier;
        this.identifier = identifier;
        this.firePropertyChanged(IDENTIFIER_PROPERTY, oldIdentifier, identifier);
    }

    public void setStateObject(StateObject stateObject) {
        super.setStateObject(stateObject);
    }

    private void validateIdentifier(String identifier) {
        Assert.isValid(identifier, "The identifier is not valid: " + identifier, "ALL", "ANY", "SOME");
    }
}

