/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultVariableStateObject
extends AbstractStateObject {
    private boolean as;
    private IdentificationVariableStateObject resultVariable;
    private StateObject stateObject;
    public static final String AS_PROPERTY = "as";
    public static final String RESULT_VARIABLE_PROPERTY = "resultVariable";
    public static final String STATE_OBJECT_PROPERTY = "selectStateObject";

    public ResultVariableStateObject(SelectClauseStateObject parent) {
        super(parent);
    }

    public ResultVariableStateObject(SelectClauseStateObject parent, StateObject stateObject, boolean as, String resultVariable) {
        super(parent);
        this.as = as;
        this.stateObject = this.parent(stateObject);
        this.resultVariable.setTextInternally(resultVariable);
    }

    public ResultVariableStateObject(SelectClauseStateObject parent, StateObject stateObject, String resultVariable) {
        this(parent, stateObject, false, resultVariable);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public ResultVariableStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
        children.add(this.resultVariable);
    }

    @Override
    public ResultVariable getExpression() {
        return (ResultVariable)super.getExpression();
    }

    @Override
    public SelectClauseStateObject getParent() {
        return (SelectClauseStateObject)super.getParent();
    }

    public String getResultVariable() {
        return this.resultVariable.getText();
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasResultVariable() {
        return this.resultVariable.hasText();
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.resultVariable = new IdentificationVariableStateObject(this);
    }

    public void parse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "select_clause_select_expression");
        this.setStateObject((StateObject)stateObject);
    }

    public void removeAs() {
        if (this.as) {
            this.setAs(true);
        }
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setExpression(ResultVariable expression) {
        super.setExpression(expression);
    }

    public void setResultVariable(String resultVariable) {
        String oldResultVariable = this.getResultVariable();
        this.resultVariable.setText(resultVariable);
        this.firePropertyChanged(RESULT_VARIABLE_PROPERTY, oldResultVariable, resultVariable);
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    public void toggleAs() {
        this.setAs(!this.as);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stateObject != null) {
            this.stateObject.toString(writer);
            writer.append(' ');
        }
        if (this.as) {
            writer.append("AS");
        }
        if (this.hasResultVariable()) {
            writer.append(' ');
            this.resultVariable.toTextInternal(writer);
        }
    }
}

