/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;

public abstract class SimpleStateObject
extends AbstractStateObject {
    private String text;
    public static final String TEXT_PROPERTY = "text";

    protected SimpleStateObject(StateObject parent) {
        super(parent);
    }

    protected SimpleStateObject(StateObject parent, String text) {
        super(parent);
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasText() {
        return !ExpressionTools.stringIsEmpty(this.text);
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        this.firePropertyChanged(TEXT_PROPERTY, oldText, text);
    }

    protected void setTextInternally(String text) {
        this.text = text;
    }

    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.text != null) {
            writer.append(this.text);
        }
    }
}

