/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorExpressionStateObject
extends AbstractListHolderStateObject<StateObject> {
    private String className;
    private IType type;
    public static final String CLASS_NAME_PROPERTY = "className";
    public static final String CONSTRUCTOR_ITEMS_LIST = "constructorItems";

    public ConstructorExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public ConstructorExpressionStateObject(StateObject parent, Class<?> type) {
        this(parent, type.getName());
    }

    public ConstructorExpressionStateObject(StateObject parent, Class<?> type, List<? extends StateObject> constructorItems) {
        super(parent, constructorItems);
        this.className = type.getName();
    }

    public ConstructorExpressionStateObject(StateObject parent, Class<?> type, String jpqlFragment) {
        this(parent, type);
        this.parse(jpqlFragment);
    }

    public ConstructorExpressionStateObject(StateObject parent, String className) {
        super(parent);
        this.className = className;
    }

    public ConstructorExpressionStateObject(StateObject parent, String className, List<? extends StateObject> constructorItems) {
        super(parent, constructorItems);
        this.className = className;
    }

    public ConstructorExpressionStateObject(StateObject parent, String className, String jpqlFragment) {
        super(parent);
        this.className = className;
        this.parse(jpqlFragment);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public ConstructorExpression getExpression() {
        return (ConstructorExpression)super.getExpression();
    }

    public IType getType() {
        this.resolveType();
        return this.type;
    }

    @Override
    protected String listName() {
        return CONSTRUCTOR_ITEMS_LIST;
    }

    public void parse(String jpqlFragment) {
        List stateObjects = this.buildStateObjects(jpqlFragment, "constructor_item");
        this.addItems(stateObjects);
    }

    public void resolveType() {
        this.type = this.getType(this.className);
    }

    public void setClassName(Class<?> type) {
        this.setClassName(type.getName());
    }

    public void setClassName(String className) {
        String oldClassName = this.className;
        this.className = className;
        this.firePropertyChanged(CLASS_NAME_PROPERTY, oldClassName, className);
    }

    public void setExpression(ConstructorExpression expression) {
        super.setExpression(expression);
    }

    public void setType(IType type) {
        this.type = type;
        this.setClassName(type != null ? type.getName() : null);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("NEW");
        if (this.className != null) {
            writer.append(' ');
            writer.append(this.className);
        }
        writer.append('(');
        this.toStringItems(writer, true);
        writer.append(')');
    }
}

