/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.multitenant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.MultitenantType;
import org.eclipse.persistence.annotations.TenantDiscriminatorColumn;
import org.eclipse.persistence.annotations.TenantDiscriminatorColumns;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.SingleTableMultitenantPolicy;
import org.eclipse.persistence.descriptors.VPDMultitenantPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.TenantDiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenantMetadata
extends ORMetadata {
    private Boolean m_includeCriteria;
    private List<TenantDiscriminatorColumnMetadata> m_tenantDiscriminatorColumns = new ArrayList<TenantDiscriminatorColumnMetadata>();
    private String m_type;

    public MultitenantMetadata() {
        super("<multitenant>");
    }

    public MultitenantMetadata(MetadataAnnotation multitenant, MetadataAccessor accessor) {
        super(multitenant, accessor);
        this.m_type = (String)multitenant.getAttribute("value");
        this.m_includeCriteria = (Boolean)multitenant.getAttributeBooleanDefaultTrue("includeCriteria");
        if (accessor.isAnnotationPresent(TenantDiscriminatorColumns.class)) {
            Object[] objectArray = (Object[])accessor.getAnnotation(TenantDiscriminatorColumns.class).getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object tenantDiscriminatorColumn = objectArray[n2];
                this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata((MetadataAnnotation)tenantDiscriminatorColumn, accessor));
                ++n2;
            }
        }
        if (accessor.isAnnotationPresent(TenantDiscriminatorColumn.class)) {
            this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata(accessor.getAnnotation(TenantDiscriminatorColumn.class), accessor));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MultitenantMetadata) {
            MultitenantMetadata multitenant = (MultitenantMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, multitenant.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_includeCriteria, multitenant.getIncludeCriteria())) {
                return false;
            }
            return this.valuesMatch(this.m_tenantDiscriminatorColumns, multitenant.getTenantDiscriminatorColumns());
        }
        return false;
    }

    public Boolean getIncludeCriteria() {
        return this.m_includeCriteria;
    }

    public List<TenantDiscriminatorColumnMetadata> getTenantDiscriminatorColumns() {
        return this.m_tenantDiscriminatorColumns;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean includeCriteria() {
        return this.m_includeCriteria == null || this.m_includeCriteria != false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_tenantDiscriminatorColumns, accessibleObject);
    }

    public void process(MetadataDescriptor descriptor) {
        RelationalDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_type == null || this.m_type.equals(MultitenantType.SINGLE_TABLE.name()) || this.m_type.equals(MultitenantType.VPD.name())) {
            SingleTableMultitenantPolicy policy;
            if (this.m_type == null || this.m_type.equals(MultitenantType.SINGLE_TABLE.name())) {
                policy = new SingleTableMultitenantPolicy(classDescriptor);
                this.getProject().setAllowNativeSQLQueries(false);
                policy.setIncludeTenantCriteria(this.includeCriteria());
            } else {
                policy = new VPDMultitenantPolicy(classDescriptor);
                ((ServerSession)this.getProject().getSession()).getDefaultConnectionPolicy().setExclusiveMode(ConnectionPolicy.ExclusiveMode.Always);
                policy.setIncludeTenantCriteria(false);
            }
            this.processTenantDiscriminators(descriptor, policy);
            classDescriptor.setMultitenantPolicy(policy);
            if (this.getProject().usesMultitenantSharedEmf()) {
                if (this.getProject().usesMultitenantSharedCache()) {
                    if (classDescriptor.isSharedIsolation()) {
                        classDescriptor.setCacheIsolation(CacheIsolationType.PROTECTED);
                    }
                } else {
                    classDescriptor.setCacheIsolation(CacheIsolationType.ISOLATED);
                }
            }
        } else {
            throw new RuntimeException("Unsupported multitenant type: " + this.m_type);
        }
    }

    protected void processTenantDiscriminators(MetadataDescriptor descriptor, SingleTableMultitenantPolicy policy) {
        EntityAccessor parentAccessor;
        if (descriptor.isInheritanceSubclass() && !(parentAccessor = descriptor.getInheritanceRootDescriptor().getEntityAccessor()).getInheritance().usesTablePerClassStrategy()) {
            if (!this.m_tenantDiscriminatorColumns.isEmpty()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_tenant_discriminator_column", descriptor.getJavaClass());
            }
            return;
        }
        if (this.m_tenantDiscriminatorColumns.isEmpty()) {
            this.m_tenantDiscriminatorColumns = descriptor.getDefaultTenantDiscriminatorColumns();
            if (this.m_tenantDiscriminatorColumns.isEmpty()) {
                this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata(descriptor.getClassAccessor()));
            } else {
                for (TenantDiscriminatorColumnMetadata tenantDiscriminator : this.m_tenantDiscriminatorColumns) {
                    tenantDiscriminator.setAccessibleObject(this.getAccessibleObject());
                    tenantDiscriminator.setProject(this.getProject());
                }
            }
        }
        for (TenantDiscriminatorColumnMetadata tenantDiscriminator : this.m_tenantDiscriminatorColumns) {
            tenantDiscriminator.process(descriptor, policy);
        }
    }

    public void setIncludeCriteria(Boolean includeCriteria) {
        this.m_includeCriteria = includeCriteria;
    }

    public void setTenantDiscriminatorColumns(List<TenantDiscriminatorColumnMetadata> tenantDiscriminatorColumns) {
        this.m_tenantDiscriminatorColumns = tenantDiscriminatorColumns;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

