/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.AbstractGrammarValidator;
import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.DefaultContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.NumericTypeComparator;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPQLQueryHelper {
    private AbstractContentAssistVisitor contentAssistVisitor;
    private AbstractGrammarValidator grammarValidator;
    private final JPQLQueryContext queryContext;
    private AbstractSemanticValidator semanticValidator;

    public AbstractJPQLQueryHelper(JPQLGrammar jpqlGrammar) {
        this.queryContext = this.buildJPQLQueryContext(jpqlGrammar);
    }

    protected AbstractJPQLQueryHelper(JPQLQueryContext queryContext) {
        Assert.isNotNull(queryContext, "The JPQLQueryContext cannot be null");
        this.queryContext = queryContext;
    }

    public ContentAssistProposals buildContentAssistProposals(int position) {
        QueryPosition queryPosition = this.getJPQLExpression().buildPosition(this.queryContext.getQuery().getExpression(), position);
        AbstractContentAssistVisitor visitor = this.getContentAssistVisitor();
        try {
            visitor.prepare(queryPosition);
            queryPosition.getExpression().accept(visitor);
            DefaultContentAssistProposals defaultContentAssistProposals = visitor.getProposals();
            return defaultContentAssistProposals;
        }
        finally {
            visitor.dispose();
        }
    }

    protected abstract AbstractContentAssistVisitor buildContentAssistVisitor(JPQLQueryContext var1);

    protected abstract AbstractGrammarValidator buildGrammarValidator(JPQLQueryContext var1);

    protected abstract JPQLQueryContext buildJPQLQueryContext(JPQLGrammar var1);

    protected Comparator<IType> buildNumericTypeComparator() {
        return new NumericTypeComparator(this.getTypeHelper());
    }

    protected abstract AbstractSemanticValidator buildSemanticValidator(JPQLQueryContext var1);

    public void dispose() {
        this.queryContext.dispose();
    }

    protected AbstractContentAssistVisitor getContentAssistVisitor() {
        if (this.contentAssistVisitor == null) {
            this.contentAssistVisitor = this.buildContentAssistVisitor(this.queryContext);
        }
        return this.contentAssistVisitor;
    }

    public JPQLGrammar getGrammar() {
        return this.queryContext.getGrammar();
    }

    protected AbstractGrammarValidator getGrammarValidator() {
        if (this.grammarValidator == null) {
            this.grammarValidator = this.buildGrammarValidator(this.queryContext);
        }
        return this.grammarValidator;
    }

    public JPQLExpression getJPQLExpression() {
        return this.queryContext.getJPQLExpression();
    }

    public IType getParameterType(String parameterName) {
        char character;
        char c = character = parameterName.length() > 0 ? parameterName.charAt(0) : (char)'\u0000';
        if (character != ':' && character != '?') {
            return this.getTypeHelper().objectType();
        }
        Collection<InputParameter> inputParameters = this.queryContext.findInputParameters(parameterName);
        if (inputParameters.isEmpty()) {
            return this.getTypeHelper().objectType();
        }
        TreeSet<IType> types = new TreeSet<IType>(this.buildNumericTypeComparator());
        for (InputParameter inputParameter : inputParameters) {
            IType type = this.queryContext.getParameterType(inputParameter);
            if (!type.isResolvable()) continue;
            types.add(type);
        }
        return types.isEmpty() ? this.getTypeHelper().objectType() : types.first();
    }

    public String getParsedJPQLQuery() {
        return this.getJPQLExpression().toParsedText();
    }

    public IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    public IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    public JPQLQueryContext getQueryContext() {
        return this.queryContext;
    }

    public IType getResultType() {
        IType type = this.queryContext.getType(this.getJPQLExpression());
        if (!type.isResolvable()) {
            type = this.getTypeHelper().objectType();
        }
        return type;
    }

    protected AbstractSemanticValidator getSemanticValidator() {
        if (this.semanticValidator == null) {
            this.semanticValidator = this.buildSemanticValidator(this.queryContext);
        }
        return this.semanticValidator;
    }

    public IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    public TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    public void setJPQLExpression(JPQLExpression jpqlExpression) {
        this.queryContext.setJPQLExpression(jpqlExpression);
    }

    public void setQuery(IQuery query) {
        this.queryContext.setQuery(query);
    }

    public List<JPQLQueryProblem> validate() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validate(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validate(Expression expression, List<JPQLQueryProblem> problems) {
        this.validateGrammar(expression, problems);
        this.validateSemantic(expression, problems);
    }

    public List<JPQLQueryProblem> validateGrammar() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validateGrammar(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateGrammar(Expression expression, List<JPQLQueryProblem> problems) {
        AbstractGrammarValidator visitor = this.getGrammarValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }

    public List<JPQLQueryProblem> validateSemantic() {
        ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
        this.validateSemantic(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateSemantic(Expression expression, List<JPQLQueryProblem> problems) {
        AbstractSemanticValidator visitor = this.getSemanticValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }
}

