/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode = 0;
    private Schema schema;
    private Object[] schemas;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLUnmarshaller xmlUnmarshaller;
    private XMLParser xmlParser;
    private boolean isResultAlwaysXMLRoot;
    private boolean isWhitespacePreserving;
    private SAXParserFactory saxParserFactory;
    private String systemId = null;
    private Map<String, Boolean> parserFeatures;

    public SAXUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) throws XMLMarshalException {
        this.parserFeatures = parserFeatures;
        try {
            this.xmlUnmarshaller = xmlUnmarshaller;
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }

    private SAXParserFactory getSAXParserFactory() throws XMLMarshalException {
        if (this.saxParserFactory == null) {
            try {
                this.saxParserFactory = SAXParserFactory.newInstance();
                this.saxParserFactory.setNamespaceAware(true);
                Schema schema = this.getSchema();
                if (schema != null) {
                    this.saxParserFactory.setSchema(schema);
                }
                this.saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                try {
                    this.saxParserFactory.setFeature("http://java.sun.com/xml/schema/features/report-ignored-element-content-whitespace", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {}
                if (this.parserFeatures != null) {
                    for (Map.Entry<String, Boolean> parserFeature : this.parserFeatures.entrySet()) {
                        try {
                            this.saxParserFactory.setFeature(parserFeature.getKey(), parserFeature.getValue());
                        }
                        catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        }
                        catch (SAXNotSupportedException sAXNotSupportedException) {}
                    }
                }
                return this.saxParserFactory;
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.saxParserFactory;
    }

    private SAXParser getSAXParser() {
        if (this.saxParser == null) {
            try {
                this.saxParser = this.getSAXParserFactory().newSAXParser();
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.saxParser;
    }

    private XMLParser getXMLParser() {
        this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        this.xmlParser.setNamespaceAware(true);
        if (this.errorHandler != null) {
            this.xmlParser.setErrorHandler(this.errorHandler);
        }
        if (this.entityResolver != null) {
            this.xmlParser.setEntityResolver(this.entityResolver);
        }
        this.xmlParser.setValidationMode(this.validationMode);
        this.xmlParser.setWhitespacePreserving(this.isWhitespacePreserving);
        return this.xmlParser;
    }

    private XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            try {
                this.xmlReader = new XMLReader(this.getSAXParser().getXMLReader());
                if (this.errorHandler != null) {
                    this.xmlReader.setErrorHandler(this.errorHandler);
                }
                if (this.entityResolver != null) {
                    this.xmlReader.setEntityResolver(this.entityResolver);
                }
                this.setValidationMode(this.getValidationMode());
                if (this.getSchema() != null) {
                    this.xmlReader.setFeature(VALIDATING, this.xmlReader.getFeature(VALIDATING));
                }
                return this.xmlReader;
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.xmlReader;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.xmlReader != null) {
            this.xmlReader.setEntityResolver(entityResolver);
        }
        if (this.xmlParser != null) {
            this.xmlParser.setEntityResolver(entityResolver);
        }
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.xmlReader != null) {
            this.xmlReader.setErrorHandler(errorHandler);
        }
        if (this.xmlParser != null) {
            this.xmlParser.setErrorHandler(errorHandler);
        }
        this.errorHandler = errorHandler;
    }

    @Override
    public int getValidationMode() {
        return this.validationMode;
    }

    @Override
    public void setValidationMode(int validationMode) {
        try {
            this.validationMode = validationMode;
            if (this.xmlParser != null) {
                this.xmlParser.setValidationMode(validationMode);
            }
            if (this.xmlReader == null) {
                return;
            }
            switch (validationMode) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception exception) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.isWhitespacePreserving = isWhitespacePreserving;
        if (this.xmlParser != null) {
            this.xmlParser.setWhitespacePreserving(isWhitespacePreserving);
        }
    }

    @Override
    public void setSchemas(Object[] schemas) {
        this.schemas = schemas;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
        if (this.saxParserFactory != null) {
            this.saxParserFactory.setSchema(schema);
            this.saxParser = null;
            this.xmlReader = null;
        }
        if (this.xmlParser != null) {
            this.xmlParser.setXMLSchema(schema);
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Object unmarshal(File file) {
        try {
            Object object;
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.getXMLParser().parse(file).getDocumentElement();
                Object object2 = this.unmarshal(domElement);
                return object2;
            }
            this.systemId = file.toURI().toURL().toExternalForm();
            FileInputStream inputStream = new FileInputStream(file);
            try {
                object = this.unmarshal(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
            inputStream.close();
            return object;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(File file, Class clazz) {
        try {
            Object object;
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.getXMLParser().parse(file).getDocumentElement();
                Object object2 = this.unmarshal(domElement, clazz);
                return object2;
            }
            this.systemId = file.toURI().toURL().toExternalForm();
            FileInputStream inputStream = new FileInputStream(file);
            try {
                object = this.unmarshal(inputStream, clazz);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
            inputStream.close();
            return object;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz);
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        if (inputSource != null) {
            inputSource.setSystemId(this.systemId);
        }
        return this.unmarshal(this.getXMLReader(), inputSource);
    }

    public Object unmarshal(InputSource inputSource, XMLReader xmlReader) {
        try {
            if (inputSource != null) {
                inputSource.setSystemId(this.systemId);
            }
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(saxUnmarshallerHandler);
            xmlReader.parse(inputSource);
            saxUnmarshallerHandler.resolveReferences();
            Object object = saxUnmarshallerHandler.getObject();
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        if (inputSource != null) {
            inputSource.setSystemId(this.systemId);
        }
        return this.unmarshal(this.getXMLReader(), inputSource, clazz);
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xmlReader) {
        UnmarshalRecord unmarshalRecord;
        if (inputSource != null) {
            inputSource.setSystemId(this.systemId);
        }
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            if (clazz == ClassConstants.OBJECT) {
                try {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                    saxUnmarshallerHandler.setXMLReader(xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    xmlReader.setContentHandler(saxUnmarshallerHandler);
                    xmlReader.parse(inputSource);
                    saxUnmarshallerHandler.resolveReferences();
                    return saxUnmarshallerHandler.getObject();
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            try {
                unmarshalRecord.setXMLReader(xmlReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                xmlReader.setContentHandler(unmarshalRecord);
                xmlReader.setLexicalHandler(unmarshalRecord);
                xmlReader.parse(inputSource);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Node node) {
        DOMReader reader = new DOMReader(this.xmlUnmarshaller);
        return this.unmarshal(reader, node);
    }

    public Object unmarshal(DOMReader reader, Node node) {
        try {
            SAXUnmarshallerHandler handler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            reader.setContentHandler(handler);
            handler.setXMLReader(reader);
            handler.setUnmarshaller(this.xmlUnmarshaller);
            reader.parse(node);
            handler.resolveReferences();
            Object object = handler.getObject();
            return object;
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Node node, Class clazz) {
        DOMReader reader = new DOMReader(this.xmlUnmarshaller);
        return this.unmarshal(reader, node, clazz);
    }

    public Object unmarshal(DOMReader domReader, Node node, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            if (clazz == ClassConstants.OBJECT) {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                saxUnmarshallerHandler.setXMLReader(domReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                domReader.setContentHandler(saxUnmarshallerHandler);
                try {
                    domReader.parse(node);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
                saxUnmarshallerHandler.resolveReferences();
                return saxUnmarshallerHandler.getObject();
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            try {
                unmarshalRecord.setXMLReader(domReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                domReader.setContentHandler(unmarshalRecord);
                domReader.setLexicalHandler(unmarshalRecord);
                domReader.parse(node);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(reader).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(reader).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz);
    }

    @Override
    public Object unmarshal(Source source) {
        try {
            if (source instanceof SAXSource) {
                SAXSource saxSource = (SAXSource)source;
                XMLReader xmlReader = null;
                if (saxSource.getXMLReader() != null) {
                    xmlReader = saxSource.getXMLReader() instanceof XMLReader ? (XMLReader)saxSource.getXMLReader() : new XMLReader(saxSource.getXMLReader());
                    this.setValidatorHandler(xmlReader);
                }
                if (xmlReader == null) {
                    Object object = this.unmarshal(saxSource.getInputSource());
                    return object;
                }
                Object object = this.unmarshal(saxSource.getInputSource(), xmlReader);
                return object;
            }
            if (source instanceof DOMSource) {
                DOMSource domSource = (DOMSource)source;
                Object object = this.unmarshal(domSource.getNode());
                return object;
            }
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                if (streamSource.getReader() != null) {
                    Object object = this.unmarshal(streamSource.getReader());
                    return object;
                }
                if (streamSource.getInputStream() != null) {
                    Object object = this.unmarshal(streamSource.getInputStream());
                    return object;
                }
                Object object = this.unmarshal(streamSource.getSystemId());
                return object;
            }
            XMLUnmarshallerHandler handler = this.xmlUnmarshaller.getUnmarshallerHandler();
            XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            SAXResult result = new SAXResult(handler);
            transformer.transform(source, (Result)result);
            Object object = handler.getResult();
            return object;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() != null) {
                xmlReader = saxSource.getXMLReader() instanceof XMLReader ? (XMLReader)saxSource.getXMLReader() : new XMLReader(saxSource.getXMLReader());
                this.setValidatorHandler(xmlReader);
            }
            if (saxSource.getXMLReader() == null) {
                return this.unmarshal(saxSource.getInputSource(), clazz);
            }
            return this.unmarshal(saxSource.getInputSource(), clazz, xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode(), clazz);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getReader() != null) {
                return this.unmarshal(streamSource.getReader(), clazz);
            }
            if (streamSource.getInputStream() != null) {
                return this.unmarshal(streamSource.getInputStream(), clazz);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz);
        }
        DOMResult result = new DOMResult();
        XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        transformer.transform(source, (Result)result);
        return this.unmarshal(result.getNode(), clazz);
    }

    @Override
    public Object unmarshal(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (Exception e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        this.systemId = url.toExternalForm();
        boolean hasThrownException = false;
        try {
            Object object = this.unmarshal(inputStream);
            return object;
        }
        catch (RuntimeException runtimeException) {
            hasThrownException = true;
            throw runtimeException;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                    this.xmlUnmarshaller.getStringBuffer().reset();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
        }
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        try {
            InputStream inputStream = url.openStream();
            this.systemId = url.toExternalForm();
            Object result = this.unmarshal(inputStream, clazz);
            inputStream.close();
            Object object = result;
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    public Object unmarshal(String systemId) {
        try {
            XMLReader xmlReader = this.getXMLReader();
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(saxUnmarshallerHandler);
            xmlReader.parse(systemId);
            saxUnmarshallerHandler.resolveReferences();
            Object object = saxUnmarshallerHandler.getObject();
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    public Object unmarshal(String systemId, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            if (clazz == ClassConstants.OBJECT) {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                try {
                    try {
                        XMLReader xmlReader = this.getXMLReader();
                        saxUnmarshallerHandler.setXMLReader(xmlReader);
                        saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                        saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                        xmlReader.setContentHandler(saxUnmarshallerHandler);
                        xmlReader.parse(systemId);
                    }
                    catch (IOException e) {
                        throw XMLMarshalException.unmarshalException(e);
                    }
                    catch (SAXException e) {
                        throw this.convertSAXException(e);
                    }
                }
                finally {
                    this.xmlUnmarshaller.getStringBuffer().reset();
                }
                saxUnmarshallerHandler.resolveReferences();
                return saxUnmarshallerHandler.getObject();
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            try {
                XMLReader xmlReader = this.getXMLReader();
                unmarshalRecord.setXMLReader(xmlReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                xmlReader.setContentHandler(unmarshalRecord);
                xmlReader.setLexicalHandler(unmarshalRecord);
                xmlReader.parse(systemId);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource) {
        try {
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (xmlContext.hasDocumentPreservation()) {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                Object object = this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement());
                return object;
            }
            XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(xmlContext);
            saxUnmarshallerHandler.setXMLReader(extendedXMLReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            extendedXMLReader.setContentHandler(saxUnmarshallerHandler);
            extendedXMLReader.parse(inputSource);
            saxUnmarshallerHandler.resolveReferences();
            Object object = saxUnmarshallerHandler.getObject();
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource, Class clazz) {
        try {
            UnmarshalRecord unmarshalRecord;
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (xmlContext.hasDocumentPreservation()) {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                Object object = this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement(), clazz);
                return object;
            }
            boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
            XMLDescriptor xmlDescriptor = null;
            AbstractSession session = null;
            if (isPrimitiveWrapper) {
                unmarshalRecord = new XMLRootRecord(clazz);
                unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
            } else {
                if (clazz == ClassConstants.OBJECT) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                    saxUnmarshallerHandler.setXMLReader((XMLReader)xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    xmlReader.setContentHandler(saxUnmarshallerHandler);
                    xmlReader.parse(inputSource);
                    saxUnmarshallerHandler.resolveReferences();
                    Object object = saxUnmarshallerHandler.getObject();
                    return object;
                }
                session = xmlContext.getReadSession(clazz);
                xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
                unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
            }
            XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
            unmarshalRecord.setXMLReader(extendedXMLReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            extendedXMLReader.setContentHandler(unmarshalRecord);
            extendedXMLReader.setLexicalHandler(unmarshalRecord);
            extendedXMLReader.parse(inputSource);
            this.xmlUnmarshaller.resolveReferences(session);
            if (isPrimitiveWrapper || clazz == ClassConstants.OBJECT) {
                Object object = unmarshalRecord.getCurrentObject();
                return object;
            }
            Object object = xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    private EclipseLinkException convertSAXException(SAXException saxException) {
        Exception internalException = saxException.getException();
        if (internalException != null) {
            if (EclipseLinkException.class.isAssignableFrom(internalException.getClass())) {
                return (EclipseLinkException)internalException;
            }
            return XMLMarshalException.unmarshalException(internalException);
        }
        return XMLMarshalException.unmarshalException(saxException);
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    private boolean isPrimitiveWrapper(Class clazz) {
        return XMLConversionManager.getDefaultJavaTypes().get(clazz) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz) || ClassConstants.DURATION.isAssignableFrom(clazz);
    }

    private void setContentHandler(XMLReader xmlReader, ContentHandler contentHandler) {
        this.setValidatorHandler(xmlReader);
        xmlReader.setContentHandler(contentHandler);
    }

    private void setValidatorHandler(XMLReader xmlReader) {
        Schema schema = this.getSchema();
        if (schema != null) {
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            xmlReader.setValidatorHandler(validatorHandler);
            validatorHandler.setErrorHandler(this.getErrorHandler());
        }
    }
}

