/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.model.IListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.model.ListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.util.CollectionTools;
import org.eclipse.persistence.jpa.jpql.util.iterator.ArrayListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathExpressionStateObject
extends AbstractStateObject
implements ListHolderStateObject<String> {
    private StateObject identificationVariable;
    private List<String> paths;
    public static final String IDENTIFICATION_VARIABLE_PROPERTY = "identificationVariable";
    public static final String PATHS_LIST = "paths";

    protected AbstractPathExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected AbstractPathExpressionStateObject(StateObject parent, String path) {
        super(parent);
        this.setPath(path);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        StateObject stateObject = this.getIdentificationVariable();
        if (stateObject != null) {
            children.add(stateObject);
        }
    }

    @Override
    public String addItem(String item) {
        this.getChangeSupport().addItem(this, this.paths, PATHS_LIST, item);
        return item;
    }

    @Override
    public void addItems(List<? extends String> items) {
        this.getChangeSupport().addItems(this, this.paths, PATHS_LIST, items);
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<String> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    public void append(String text) {
        StringBuilder word = new StringBuilder();
        int pathCount = this.paths.size();
        boolean appendToLastSegment = true;
        int startIndex = pathCount;
        int index = 0;
        int count = text.length();
        while (index < count) {
            char character = text.charAt(index);
            if (character == '.') {
                if (word.length() > 0) {
                    if (appendToLastSegment) {
                        String currentPath = this.paths.get(pathCount - 1);
                        this.paths.set(pathCount - 1, String.valueOf(currentPath) + word);
                        startIndex = pathCount - 1;
                    } else {
                        this.paths.add(word.toString());
                        ++pathCount;
                    }
                    word.delete(0, word.length());
                }
                appendToLastSegment = false;
            } else {
                word.append(character);
            }
            ++index;
        }
        if (word.length() > 0) {
            if (appendToLastSegment) {
                String currentPath = this.paths.get(pathCount - 1);
                this.paths.set(pathCount - 1, String.valueOf(currentPath) + word);
                startIndex = pathCount - 1;
            } else {
                this.paths.add(word.toString());
            }
        }
        ListChangeEvent<String> event = new ListChangeEvent<String>(this, this.paths, IListChangeEvent.EventType.CHANGED, PATHS_LIST, this.paths, startIndex, this.itemsSize());
        this.getChangeSupport().fireListChangeEvent(event);
    }

    @Override
    public boolean canMoveDown(String item) {
        return false;
    }

    @Override
    public boolean canMoveUp(String item) {
        return false;
    }

    @Override
    public AbstractPathExpression getExpression() {
        return (AbstractPathExpression)super.getExpression();
    }

    public StateObject getIdentificationVariable() {
        if (this.identificationVariable == null && this.hasItems()) {
            this.identificationVariable = this.buildStateObject(this.getItem(0), "state_field_path_expression");
        }
        return this.identificationVariable;
    }

    @Override
    public String getItem(int index) {
        return this.paths.get(index);
    }

    public String getPath() {
        return this.toString();
    }

    public boolean hasIdentificationVariable() {
        return this.getIdentificationVariable() != null;
    }

    @Override
    public boolean hasItems() {
        return !this.paths.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.paths = new ArrayList<String>();
    }

    @Override
    public IterableListIterator<String> items() {
        return new CloneListIterator<String>(this.paths);
    }

    @Override
    public int itemsSize() {
        return this.paths.size();
    }

    @Override
    public String moveDown(String item) {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " does not support moveDown(String).");
    }

    @Override
    public String moveUp(String item) {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " does not support moveUp(String).");
    }

    @Override
    public void removeItem(int index) {
        if (index == 0) {
            this.setIdentificationVariableInternally(null);
        }
        this.removeItem(this.getItem(index));
    }

    @Override
    public void removeItem(String item) {
        this.getChangeSupport().removeItem(this, this.paths, PATHS_LIST, item);
    }

    @Override
    public void removeItems(Collection<String> items) {
        this.getChangeSupport().removeItems(this, this.paths, PATHS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<String> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public void setIdentificationVariable(StateObject identificationVariable) {
        this.setIdentificationVariableInternally(identificationVariable);
        this.getChangeSupport().replaceItem(this, this.paths, PATHS_LIST, 0, identificationVariable.toString());
    }

    protected void setIdentificationVariableInternally(StateObject identificationVariable) {
        StateObject oldIdentificationVariable = this.identificationVariable;
        this.identificationVariable = this.parent(identificationVariable);
        this.firePropertyChanged(IDENTIFICATION_VARIABLE_PROPERTY, oldIdentificationVariable, identificationVariable);
    }

    public void setPath(int index, String path) {
        if (index == 0) {
            this.setIdentificationVariableInternally(null);
        }
        this.getChangeSupport().replaceItem(this, this.paths, PATHS_LIST, index, path);
    }

    public void setPath(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            paths.add(token);
        }
        this.setPaths(paths.listIterator());
    }

    public void setPaths(ListIterator<String> paths) {
        this.setIdentificationVariableInternally(null);
        this.getChangeSupport().replaceItems(this, this.paths, PATHS_LIST, CollectionTools.list(paths));
    }

    public void setPaths(String ... paths) {
        this.setPaths(new ArrayListIterator<String>(paths));
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        String variable;
        StateObject stateObject = this.getIdentificationVariable();
        if (stateObject != null && (variable = stateObject.toString()).length() > 0) {
            writer.append(variable);
            if (this.hasItems()) {
                writer.append('.');
            }
        }
        int index = 1;
        int count = this.paths.size();
        while (index < count) {
            writer.append(this.paths.get(index));
            if (index < count - 1) {
                writer.append('.');
            }
            ++index;
        }
    }
}

